/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.contents;

import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.stmt.QueryBuilder;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.contents.ContentsId;
import mil.nga.geopackage.extension.contents.ContentsIdDao;
import mil.nga.geopackage.property.GeoPackageProperties;

public class ContentsIdExtension
extends BaseExtension {
    private static final Logger logger = Logger.getLogger(ContentsIdExtension.class.getName());
    public static final String EXTENSION_AUTHOR = "nga";
    public static final String EXTENSION_NAME_NO_AUTHOR = "contents_id";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("nga", "contents_id");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "contents_id");
    private final ContentsIdDao contentsIdDao;

    public ContentsIdExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
        this.contentsIdDao = geoPackage.getContentsIdDao();
    }

    public ContentsIdDao getDao() {
        return this.contentsIdDao;
    }

    public boolean has() {
        boolean exists = false;
        try {
            exists = this.has(EXTENSION_NAME, null, null) && this.contentsIdDao.isTableExists();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check for contents id for GeoPackage: " + this.geoPackage.getName(), e);
        }
        return exists;
    }

    public ContentsId get(Contents contents) {
        return this.get(contents.getTableName());
    }

    public ContentsId get(String tableName) {
        ContentsId contentsId = null;
        try {
            if (this.contentsIdDao.isTableExists()) {
                contentsId = this.contentsIdDao.queryForTableName(tableName);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query contents id for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + tableName, e);
        }
        return contentsId;
    }

    public Long getId(Contents contents) {
        return this.getId(contents.getTableName());
    }

    public Long getId(String tableName) {
        Long id = null;
        ContentsId contentsId = this.get(tableName);
        if (contentsId != null) {
            id = contentsId.getId();
        }
        return id;
    }

    public ContentsId create(Contents contents) {
        return this.create(contents.getTableName());
    }

    public ContentsId create(String tableName) {
        if (!this.has()) {
            this.getOrCreateExtension();
        }
        ContentsId contentsId = new ContentsId();
        Contents contents = this.geoPackage.getTableContents(tableName);
        contentsId.setContents(contents);
        try {
            this.contentsIdDao.create(contentsId);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create contents id for GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + tableName, e);
        }
        return contentsId;
    }

    public long createId(Contents contents) {
        return this.createId(contents.getTableName());
    }

    public long createId(String tableName) {
        ContentsId contentsId = this.create(tableName);
        return contentsId.getId();
    }

    public ContentsId getOrCreate(Contents contents) {
        return this.getOrCreate(contents.getTableName());
    }

    public ContentsId getOrCreate(String tableName) {
        ContentsId contentsId = this.get(tableName);
        if (contentsId == null) {
            contentsId = this.create(tableName);
        }
        return contentsId;
    }

    public long getOrCreateId(Contents contents) {
        return this.getOrCreateId(contents.getTableName());
    }

    public long getOrCreateId(String tableName) {
        ContentsId contentsId = this.getOrCreate(tableName);
        return contentsId.getId();
    }

    public boolean delete(Contents contents) {
        return this.delete(contents.getTableName());
    }

    public boolean delete(String tableName) {
        boolean deleted = false;
        try {
            if (this.contentsIdDao.isTableExists()) {
                deleted = this.contentsIdDao.deleteByTableName(tableName) > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Contents Id extension table. GeoPackage: " + this.geoPackage.getName() + ", Table Name: " + tableName, e);
        }
        return deleted;
    }

    public int createIds() {
        return this.createIds("");
    }

    public int createIds(ContentsDataType type) {
        return this.createIds(type.getName());
    }

    public int createIds(String type) {
        this.getOrCreateExtension();
        List<String> tables = this.getMissing(type);
        for (String tableName : tables) {
            this.getOrCreate(tableName);
        }
        return tables.size();
    }

    public int deleteIds() {
        int deleted = 0;
        try {
            if (this.contentsIdDao.isTableExists()) {
                deleted = this.contentsIdDao.delete(this.contentsIdDao.deleteBuilder().prepare());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete all contents ids. GeoPackage: " + this.geoPackage.getName(), e);
        }
        return deleted;
    }

    public int deleteIds(ContentsDataType type) {
        return this.deleteIds(type.getName());
    }

    public int deleteIds(String type) {
        int deleted = 0;
        try {
            if (this.contentsIdDao.isTableExists()) {
                List<ContentsId> contentsIds = this.getIds(type);
                deleted = this.contentsIdDao.delete(contentsIds);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete contents ids by type. GeoPackage: " + this.geoPackage.getName() + ", Type: " + type, e);
        }
        return deleted;
    }

    public List<ContentsId> getIds() {
        ArrayList<ContentsId> contentsIds = null;
        try {
            contentsIds = this.contentsIdDao.isTableExists() ? this.contentsIdDao.queryForAll() : new ArrayList<ContentsId>();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for all contents ids. GeoPackage: " + this.geoPackage.getName(), e);
        }
        return contentsIds;
    }

    public long count() {
        long count = 0L;
        if (this.has()) {
            try {
                count = this.contentsIdDao.countOf();
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to count contents ids. GeoPackage: " + this.geoPackage.getName(), e);
            }
        }
        return count;
    }

    public List<ContentsId> getIds(ContentsDataType type) {
        return this.getIds(type.getName());
    }

    public List<ContentsId> getIds(String type) {
        List<ContentsId> contentsIds = null;
        ContentsDao contentsDao = this.geoPackage.getContentsDao();
        try {
            if (this.contentsIdDao.isTableExists()) {
                QueryBuilder contentsQueryBuilder = contentsDao.queryBuilder();
                QueryBuilder contentsIdQueryBuilder = this.contentsIdDao.queryBuilder();
                contentsQueryBuilder.where().eq("data_type", (Object)type);
                contentsIdQueryBuilder.join(contentsQueryBuilder);
                contentsIds = contentsIdQueryBuilder.query();
            } else {
                contentsIds = new ArrayList<ContentsId>();
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for contents id by contents data type. GeoPackage: " + this.geoPackage.getName() + ", Type: " + type, e);
        }
        return contentsIds;
    }

    public List<String> getMissing() {
        return this.getMissing("");
    }

    public List<String> getMissing(ContentsDataType type) {
        return this.getMissing(type.getName());
    }

    public List<String> getMissing(String type) {
        ArrayList<String> missing = new ArrayList<String>();
        ContentsDao contentsDao = this.geoPackage.getContentsDao();
        GenericRawResults results = null;
        try {
            String[] queryArgs;
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append("table_name");
            query.append(" FROM ");
            query.append("gpkg_contents");
            StringBuilder where = new StringBuilder();
            if (type != null && !type.isEmpty()) {
                where.append("data_type");
                where.append(" = ?");
                queryArgs = new String[]{type};
            } else {
                queryArgs = new String[]{};
                type = null;
            }
            if (this.contentsIdDao.isTableExists()) {
                if (where.length() > 0) {
                    where.append(" AND ");
                }
                where.append("table_name");
                where.append(" NOT IN (SELECT ");
                where.append("table_name");
                where.append(" FROM ");
                where.append("nga_contents_id");
                where.append(")");
            }
            if (where.length() > 0) {
                query.append(" WHERE ").append((CharSequence)where);
            }
            results = contentsDao.queryRaw(query.toString(), queryArgs);
            for (String[] resultRow : results) {
                missing.add(resultRow[0]);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for missing contents ids. GeoPackage: " + this.geoPackage.getName() + ", Type: " + type, e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close generic raw results from missing contents ids query. type: " + type, e);
                }
            }
        }
        return missing;
    }

    public Extensions getOrCreateExtension() {
        this.geoPackage.createContentsIdTable();
        Extensions extension = this.getOrCreate(EXTENSION_NAME, null, null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        ContentsDao contentsDao = this.geoPackage.getContentsDao();
        try {
            if (contentsDao.queryForId("nga_contents_id") == null) {
                Contents contents = new Contents();
                contents.setTableName("nga_contents_id");
                contents.setDataTypeString("gpkg_extensions");
                contents.setIdentifier("nga_contents_id");
                contentsDao.create(contents);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create contents entry for contents id. GeoPackage: " + this.geoPackage.getName(), e);
        }
        return extension;
    }

    public Extensions getExtension() {
        Extensions extension = this.get(EXTENSION_NAME, null, null);
        return extension;
    }

    public void removeExtension() {
        try {
            if (this.contentsIdDao.isTableExists()) {
                this.geoPackage.dropTable(this.contentsIdDao.getTableName());
            }
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
            this.geoPackage.getContentsDao().deleteById("nga_contents_id");
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Contents Id extension and table. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }
}

