/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.attributes.AttributesColumn;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.UniqueConstraint;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.NGAExtensions;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.user.UserCoreDao;
import mil.nga.geopackage.user.UserCoreResult;
import mil.nga.geopackage.user.UserCoreRow;

public abstract class PropertiesCoreExtension<TGeoPackage extends GeoPackageCore, TRow extends UserCoreRow<?, ?>, TResult extends UserCoreResult<?, ?, TRow>, TDao extends UserCoreDao<?, ?, TRow, TResult>>
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "nga";
    public static final String EXTENSION_NAME_NO_AUTHOR = "properties";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("nga", "properties");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty("geopackage.extensions", "properties");
    public static final String TABLE_NAME = EXTENSION_NAME;
    public static final String COLUMN_PROPERTY = "property";
    public static final String COLUMN_VALUE = "value";

    protected PropertiesCoreExtension(TGeoPackage geoPackage) {
        super((GeoPackageCore)geoPackage);
    }

    public TGeoPackage getGeoPackage() {
        return (TGeoPackage)this.geoPackage;
    }

    public Extensions getOrCreate() {
        if (!this.geoPackage.isTable(TABLE_NAME)) {
            AttributesColumn propertyColumn = AttributesColumn.createColumn(COLUMN_PROPERTY, GeoPackageDataType.TEXT, true, null);
            AttributesColumn valueColumn = AttributesColumn.createColumn(COLUMN_VALUE, GeoPackageDataType.TEXT);
            ArrayList<AttributesColumn> additionalColumns = new ArrayList<AttributesColumn>();
            additionalColumns.add(propertyColumn);
            additionalColumns.add(valueColumn);
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            constraints.add(new UniqueConstraint(propertyColumn, valueColumn));
            this.geoPackage.createAttributesTableWithId(TABLE_NAME, additionalColumns, constraints);
        }
        Extensions extension = this.getOrCreate(EXTENSION_NAME, TABLE_NAME, null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public boolean has() {
        return this.has(EXTENSION_NAME, TABLE_NAME, null) && this.geoPackage.isTable(TABLE_NAME);
    }

    protected abstract TDao getDao();

    protected abstract TRow newRow();

    public int numProperties() {
        return this.getProperties().size();
    }

    public List<String> getProperties() {
        List<String> properties = null;
        properties = this.has() ? ((UserCoreDao)this.getDao()).querySingleColumnTypedResults("SELECT DISTINCT property FROM " + TABLE_NAME, null) : new ArrayList<String>();
        return properties;
    }

    public boolean hasProperty(String property) {
        return this.hasValues(property);
    }

    public int numValues() {
        int count = 0;
        if (this.has()) {
            count = ((UserCoreDao)this.getDao()).count();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numValues(String property) {
        int count = 0;
        if (this.has()) {
            try (TResult result = this.queryForValues(property);){
                count = result.getCount();
            }
        }
        return count;
    }

    public boolean hasSingleValue(String property) {
        return this.numValues(property) == 1;
    }

    public boolean hasValues(String property) {
        return this.numValues(property) > 0;
    }

    public String getValue(String property) {
        String value = null;
        List<String> values = this.getValues(property);
        if (!values.isEmpty()) {
            value = values.get(0);
        }
        return value;
    }

    public List<String> getValues(String property) {
        return this.getValues((UserCoreResult<?, ?, ?>)this.queryForValues(property));
    }

    public boolean hasValue(String property, String value) {
        boolean hasValue = false;
        if (this.has()) {
            Map<String, Object> fieldValues = this.buildFieldValues(property, value);
            hasValue = ((UserCoreDao)this.getDao()).countForFieldValues(fieldValues) > 0;
        }
        return hasValue;
    }

    public boolean addValue(String property, String value) {
        if (!this.has()) {
            this.getOrCreate();
        }
        boolean added = false;
        if (!this.hasValue(property, value)) {
            TRow row = this.newRow();
            ((UserCoreRow)row).setValue(COLUMN_PROPERTY, (Object)property);
            ((UserCoreRow)row).setValue(COLUMN_VALUE, (Object)value);
            ((UserCoreDao)this.getDao()).insert(row);
            added = true;
        }
        return added;
    }

    public int deleteProperty(String property) {
        int count = 0;
        if (this.has()) {
            TDao dao = this.getDao();
            String where = ((UserCoreDao)dao).buildWhere(COLUMN_PROPERTY, property);
            String[] whereArgs = ((UserCoreDao)dao).buildWhereArgs(property);
            count = ((UserCoreDao)dao).delete(where, whereArgs);
        }
        return count;
    }

    public int deleteValue(String property, String value) {
        int count = 0;
        if (this.has()) {
            Map<String, Object> fieldValues = this.buildFieldValues(property, value);
            count = ((UserCoreDao)this.getDao()).delete(fieldValues);
        }
        return count;
    }

    public int deleteAll() {
        int count = 0;
        if (this.has()) {
            count = ((UserCoreDao)this.getDao()).deleteAll();
        }
        return count;
    }

    public void removeExtension() {
        NGAExtensions.deletePropertiesExtension(this.geoPackage);
    }

    private Map<String, Object> buildFieldValues(String property, String value) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(COLUMN_PROPERTY, property);
        fieldValues.put(COLUMN_VALUE, value);
        return fieldValues;
    }

    private TResult queryForValues(String property) {
        TResult result = null;
        if (this.has()) {
            result = ((UserCoreDao)this.getDao()).queryForEq(COLUMN_PROPERTY, property);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getValues(UserCoreResult<?, ?, ?> results) {
        List<String> values = null;
        if (results != null) {
            try {
                if (results.getCount() > 0) {
                    int columnIndex = results.getColumnIndex(COLUMN_VALUE);
                    values = this.getColumnResults(columnIndex, results);
                }
                values = new ArrayList();
            }
            finally {
                results.close();
            }
        } else {
            values = new ArrayList<String>();
        }
        return values;
    }

    private List<String> getColumnResults(int columnIndex, UserCoreResult<?, ?, ?> results) {
        ArrayList<String> values = new ArrayList<String>();
        while (results.moveToNext()) {
            values.add(results.getString(columnIndex));
        }
        return values;
    }
}

