/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import mil.nga.geopackage.core.contents.ContentsDataType;

public enum RelationType {
    FEATURES("features", ContentsDataType.FEATURES),
    SIMPLE_ATTRIBUTES("simple_attributes", ContentsDataType.ATTRIBUTES),
    MEDIA("media", ContentsDataType.ATTRIBUTES),
    ATTRIBUTES(ContentsDataType.ATTRIBUTES.getName(), ContentsDataType.ATTRIBUTES),
    TILES(ContentsDataType.TILES.getName(), ContentsDataType.TILES);

    private final String name;
    private final String dataType;

    private RelationType(String name, ContentsDataType dataType) {
        this(name, dataType.getName());
    }

    private RelationType(String name, String dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    public String getName() {
        return this.name;
    }

    public String getDataType() {
        return this.dataType;
    }

    public static RelationType fromName(String name) {
        RelationType relationType = null;
        if (name != null) {
            for (RelationType type : RelationType.values()) {
                if (!name.equals(type.getName())) continue;
                relationType = type;
                break;
            }
        }
        return relationType;
    }
}

