/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.scale;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.extension.scale.TileScalingDao;
import mil.nga.geopackage.extension.scale.TileScalingType;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;

@DatabaseTable(tableName="nga_tile_scaling", daoClass=TileScalingDao.class)
public class TileScaling {
    public static final String TABLE_NAME = "nga_tile_scaling";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_SCALING_TYPE = "scaling_type";
    public static final String COLUMN_ZOOM_IN = "zoom_in";
    public static final String COLUMN_ZOOM_OUT = "zoom_out";
    @DatabaseField(columnName="table_name", id=true, canBeNull=false)
    private String tableName;
    @DatabaseField(columnName="scaling_type", canBeNull=false)
    private String scalingType;
    @DatabaseField(columnName="zoom_in")
    private Long zoomIn;
    @DatabaseField(columnName="zoom_out")
    private Long zoomOut;

    public TileScaling() {
    }

    public TileScaling(TileMatrixSet tileMatrixSet, TileScalingType scalingType, Long zoomIn, Long zoomOut) {
        this.setTileMatrixSet(tileMatrixSet);
        this.setScalingType(scalingType);
        this.zoomIn = zoomIn;
        this.zoomOut = zoomOut;
    }

    public TileScaling(String tableName, TileScalingType scalingType, Long zoomIn, Long zoomOut) {
        this.tableName = tableName;
        this.setScalingType(scalingType);
        this.zoomIn = zoomIn;
        this.zoomOut = zoomOut;
    }

    public TileScaling(TileScalingType scalingType, Long zoomIn, Long zoomOut) {
        this.setScalingType(scalingType);
        this.zoomIn = zoomIn;
        this.zoomOut = zoomOut;
    }

    public TileScaling(TileScaling tileScaling) {
        this.tableName = tileScaling.tableName;
        this.scalingType = tileScaling.scalingType;
        this.zoomIn = tileScaling.zoomIn;
        this.zoomOut = tileScaling.zoomOut;
    }

    public void setTileMatrixSet(TileMatrixSet tileMatrixSet) {
        this.setTableName(tileMatrixSet != null ? tileMatrixSet.getTableName() : null);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TileScalingType getScalingType() {
        return TileScalingType.fromName(this.scalingType);
    }

    public void setScalingType(TileScalingType scalingType) {
        this.scalingType = scalingType.getName();
    }

    public String getScalingTypeString() {
        return this.scalingType;
    }

    public void setScalingTypeString(String scalingType) {
        this.scalingType = scalingType;
    }

    public Long getZoomIn() {
        return this.zoomIn;
    }

    public void setZoomIn(Long zoomIn) {
        this.zoomIn = zoomIn;
    }

    public Long getZoomOut() {
        return this.zoomOut;
    }

    public void setZoomOut(Long zoomOut) {
        this.zoomOut = zoomOut;
    }

    public boolean isZoomIn() {
        return (this.zoomIn == null || this.zoomIn > 0L) && this.scalingType != null && this.getScalingType() != TileScalingType.OUT;
    }

    public boolean isZoomOut() {
        return (this.zoomOut == null || this.zoomOut > 0L) && this.scalingType != null && this.getScalingType() != TileScalingType.IN;
    }
}

