/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.factory;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.attributes.AttributesColumn;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDao;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSfSql;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSfSqlDao;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSqlMm;
import mil.nga.geopackage.core.srs.SpatialReferenceSystemSqlMmDao;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.GeoPackageExtensions;
import mil.nga.geopackage.extension.MetadataExtension;
import mil.nga.geopackage.extension.SchemaExtension;
import mil.nga.geopackage.extension.contents.ContentsId;
import mil.nga.geopackage.extension.contents.ContentsIdDao;
import mil.nga.geopackage.extension.coverage.GriddedCoverage;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDao;
import mil.nga.geopackage.extension.coverage.GriddedTile;
import mil.nga.geopackage.extension.coverage.GriddedTileDao;
import mil.nga.geopackage.extension.index.GeometryIndex;
import mil.nga.geopackage.extension.index.GeometryIndexDao;
import mil.nga.geopackage.extension.index.TableIndex;
import mil.nga.geopackage.extension.index.TableIndexDao;
import mil.nga.geopackage.extension.link.FeatureTileLink;
import mil.nga.geopackage.extension.link.FeatureTileLinkDao;
import mil.nga.geopackage.extension.related.ExtendedRelation;
import mil.nga.geopackage.extension.related.ExtendedRelationsDao;
import mil.nga.geopackage.extension.scale.TileScaling;
import mil.nga.geopackage.extension.scale.TileScalingDao;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.features.columns.GeometryColumnsSfSql;
import mil.nga.geopackage.features.columns.GeometryColumnsSfSqlDao;
import mil.nga.geopackage.features.columns.GeometryColumnsSqlMm;
import mil.nga.geopackage.features.columns.GeometryColumnsSqlMmDao;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.metadata.Metadata;
import mil.nga.geopackage.metadata.MetadataDao;
import mil.nga.geopackage.metadata.reference.MetadataReference;
import mil.nga.geopackage.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.schema.columns.DataColumns;
import mil.nga.geopackage.schema.columns.DataColumnsDao;
import mil.nga.geopackage.schema.constraints.DataColumnConstraints;
import mil.nga.geopackage.schema.constraints.DataColumnConstraintsDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.sf.proj.Projection;

public abstract class GeoPackageCoreImpl
implements GeoPackageCore {
    private final String name;
    private final String path;
    private final GeoPackageCoreConnection database;
    private final GeoPackageTableCreator tableCreator;
    protected final boolean writable;

    protected GeoPackageCoreImpl(String name, String path, GeoPackageCoreConnection database, GeoPackageTableCreator tableCreator, boolean writable) {
        this.name = name;
        this.path = path;
        this.database = database;
        this.tableCreator = tableCreator;
        this.writable = writable;
    }

    @Override
    public void close() {
        this.database.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public GeoPackageCoreConnection getDatabase() {
        return this.database;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public String getApplicationId() {
        return this.database.getApplicationId();
    }

    @Override
    public int getUserVersion() {
        return this.database.getUserVersion();
    }

    @Override
    public int getUserVersionMajor() {
        return this.getUserVersion() / 10000;
    }

    @Override
    public int getUserVersionMinor() {
        return this.getUserVersion() % 10000 / 100;
    }

    @Override
    public int getUserVersionPatch() {
        return this.getUserVersion() % 100;
    }

    @Override
    public List<String> getFeatureTables() {
        List<String> tableNames = this.getTables(ContentsDataType.FEATURES);
        return tableNames;
    }

    @Override
    public List<String> getTileTables() {
        List<String> tableNames = this.getTables(ContentsDataType.TILES);
        return tableNames;
    }

    @Override
    public List<String> getAttributesTables() {
        List<String> tableNames = this.getTables(ContentsDataType.ATTRIBUTES);
        return tableNames;
    }

    @Override
    public List<String> getTables(ContentsDataType type) {
        return this.getTables(type.getName());
    }

    @Override
    public List<String> getTables(String type) {
        List<String> tableNames;
        ContentsDao contentDao = this.getContentsDao();
        try {
            tableNames = contentDao.getTables(type);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + type + " tables", e);
        }
        return tableNames;
    }

    @Override
    public List<String> getFeatureAndTileTables() {
        ArrayList<String> tables = new ArrayList<String>();
        tables.addAll(this.getFeatureTables());
        tables.addAll(this.getTileTables());
        return tables;
    }

    @Override
    public List<String> getTables() {
        List<String> tables;
        ContentsDao contentDao = this.getContentsDao();
        try {
            tables = contentDao.getTables();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve tables", e);
        }
        return tables;
    }

    @Override
    public boolean isFeatureTable(String table) {
        return this.isTableType(ContentsDataType.FEATURES, table);
    }

    @Override
    public boolean isTileTable(String table) {
        return this.isTableType(ContentsDataType.TILES, table);
    }

    @Override
    public boolean isAttributeTable(String table) {
        return this.isTableType(ContentsDataType.ATTRIBUTES, table);
    }

    @Override
    public boolean isTableType(ContentsDataType type, String table) {
        return this.isTableType(type.getName(), table);
    }

    @Override
    public boolean isTableType(String type, String table) {
        return type.equals(this.getTableType(table));
    }

    @Override
    public boolean isFeatureOrTileTable(String table) {
        boolean isType = false;
        Contents contents = this.getTableContents(table);
        if (contents != null) {
            ContentsDataType dataType = contents.getDataType();
            isType = dataType != null && (dataType == ContentsDataType.FEATURES || dataType == ContentsDataType.TILES);
        }
        return isType;
    }

    @Override
    public boolean isContentsTable(String table) {
        return this.getTableContents(table) != null;
    }

    @Override
    public boolean isTable(String table) {
        return this.database.tableExists(table);
    }

    @Override
    public Contents getTableContents(String table) {
        ContentsDao contentDao = this.getContentsDao();
        Contents contents = null;
        try {
            contents = (Contents)contentDao.queryForId(table);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table contents: " + table, e);
        }
        return contents;
    }

    @Override
    public String getTableType(String table) {
        String tableType = null;
        Contents contents = this.getTableContents(table);
        if (contents != null) {
            tableType = contents.getDataTypeString();
        }
        return tableType;
    }

    @Override
    public ContentsDataType getTableDataType(String table) {
        ContentsDataType tableType = null;
        Contents contents = this.getTableContents(table);
        if (contents != null) {
            tableType = contents.getDataType();
        }
        return tableType;
    }

    @Override
    public BoundingBox getContentsBoundingBox(Projection projection) {
        ContentsDao contentsDao = this.getContentsDao();
        BoundingBox boundingBox = contentsDao.getBoundingBox(projection);
        return boundingBox;
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection) {
        return this.getBoundingBox(projection, false);
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection, boolean manual) {
        BoundingBox boundingBox = this.getContentsBoundingBox(projection);
        List<String> tables = this.getTables();
        for (String table : tables) {
            BoundingBox tableBoundingBox = this.getBoundingBox(projection, table, manual);
            if (tableBoundingBox == null) continue;
            if (boundingBox != null) {
                boundingBox = boundingBox.union(tableBoundingBox);
                continue;
            }
            boundingBox = tableBoundingBox;
        }
        return boundingBox;
    }

    @Override
    public BoundingBox getContentsBoundingBox(String table) {
        ContentsDao contentsDao = this.getContentsDao();
        BoundingBox boundingBox = contentsDao.getBoundingBox(table);
        return boundingBox;
    }

    @Override
    public BoundingBox getContentsBoundingBox(Projection projection, String table) {
        ContentsDao contentsDao = this.getContentsDao();
        BoundingBox boundingBox = contentsDao.getBoundingBox(projection, table);
        return boundingBox;
    }

    @Override
    public BoundingBox getBoundingBox(String table) {
        return this.getBoundingBox(null, table);
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection, String table) {
        return this.getBoundingBox(projection, table, false);
    }

    @Override
    public BoundingBox getBoundingBox(String table, boolean manual) {
        return this.getBoundingBox(null, table, manual);
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection, String table, boolean manual) {
        BoundingBox boundingBox = this.getContentsBoundingBox(projection, table);
        BoundingBox tableBoundingBox = null;
        String tableType = this.getTableType(table);
        ContentsDataType dataType = ContentsDataType.fromName(tableType);
        if (dataType != null) {
            switch (dataType) {
                case FEATURES: {
                    tableBoundingBox = this.getFeatureBoundingBox(projection, table, manual);
                    break;
                }
                case TILES: 
                case GRIDDED_COVERAGE: {
                    try {
                        TileMatrixSet tileMatrixSet = (TileMatrixSet)this.getTileMatrixSetDao().queryForId(table);
                        tableBoundingBox = tileMatrixSet.getBoundingBox(projection);
                        break;
                    }
                    catch (SQLException e) {
                        throw new GeoPackageException("Failed to retrieve tile matrix set for table: " + table, e);
                    }
                }
            }
        }
        if (tableBoundingBox != null) {
            boundingBox = boundingBox == null ? tableBoundingBox : boundingBox.union(tableBoundingBox);
        }
        return boundingBox;
    }

    @Override
    public SpatialReferenceSystemDao getSpatialReferenceSystemDao() {
        SpatialReferenceSystemDao dao = (SpatialReferenceSystemDao)((Object)this.createDao(SpatialReferenceSystem.class));
        dao.setCrsWktExtension(new CrsWktExtension(this));
        return dao;
    }

    @Override
    public SpatialReferenceSystemSqlMmDao getSpatialReferenceSystemSqlMmDao() {
        SpatialReferenceSystemSqlMmDao dao = (SpatialReferenceSystemSqlMmDao)((Object)this.createDao(SpatialReferenceSystemSqlMm.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public SpatialReferenceSystemSfSqlDao getSpatialReferenceSystemSfSqlDao() {
        SpatialReferenceSystemSfSqlDao dao = (SpatialReferenceSystemSfSqlDao)((Object)this.createDao(SpatialReferenceSystemSfSql.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public ContentsDao getContentsDao() {
        ContentsDao dao = (ContentsDao)((Object)this.createDao(Contents.class));
        dao.setDatabase(this.database);
        return dao;
    }

    @Override
    public GeometryColumnsDao getGeometryColumnsDao() {
        return (GeometryColumnsDao)((Object)this.createDao(GeometryColumns.class));
    }

    @Override
    public GeometryColumnsSqlMmDao getGeometryColumnsSqlMmDao() {
        GeometryColumnsSqlMmDao dao = (GeometryColumnsSqlMmDao)((Object)this.createDao(GeometryColumnsSqlMm.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public GeometryColumnsSfSqlDao getGeometryColumnsSfSqlDao() {
        GeometryColumnsSfSqlDao dao = (GeometryColumnsSfSqlDao)((Object)this.createDao(GeometryColumnsSfSql.class));
        this.verifyTableExists(dao);
        return dao;
    }

    @Override
    public boolean createGeometryColumnsTable() {
        this.verifyWritable();
        boolean created = false;
        GeometryColumnsDao dao = this.getGeometryColumnsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createGeometryColumns() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GeometryColumns.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createFeatureTable(FeatureTable table) {
        this.createUserTable(table);
    }

    @Override
    public GeometryColumns createFeatureTableWithMetadata(GeometryColumns geometryColumns, BoundingBox boundingBox, long srsId) {
        return this.createFeatureTableWithMetadata(geometryColumns, null, null, boundingBox, srsId);
    }

    @Override
    public GeometryColumns createFeatureTableWithMetadata(GeometryColumns geometryColumns, String idColumnName, BoundingBox boundingBox, long srsId) {
        return this.createFeatureTableWithMetadata(geometryColumns, idColumnName, null, boundingBox, srsId);
    }

    @Override
    public GeometryColumns createFeatureTableWithMetadata(GeometryColumns geometryColumns, List<FeatureColumn> additionalColumns, BoundingBox boundingBox, long srsId) {
        return this.createFeatureTableWithMetadata(geometryColumns, null, additionalColumns, boundingBox, srsId);
    }

    @Override
    public GeometryColumns createFeatureTableWithMetadata(GeometryColumns geometryColumns, String idColumnName, List<FeatureColumn> additionalColumns, BoundingBox boundingBox, long srsId) {
        if (idColumnName == null) {
            idColumnName = "id";
        }
        ArrayList<FeatureColumn> columns = new ArrayList<FeatureColumn>();
        columns.add(FeatureColumn.createPrimaryKeyColumn(idColumnName));
        columns.add(FeatureColumn.createGeometryColumn(geometryColumns.getColumnName(), geometryColumns.getGeometryType()));
        if (additionalColumns != null) {
            columns.addAll(additionalColumns);
        }
        return this.createFeatureTableWithMetadata(geometryColumns, boundingBox, srsId, columns);
    }

    @Override
    public GeometryColumns createFeatureTableWithMetadata(GeometryColumns geometryColumns, BoundingBox boundingBox, long srsId, List<FeatureColumn> columns) {
        SpatialReferenceSystem srs = this.getSrs(srsId);
        this.createGeometryColumnsTable();
        FeatureTable table = new FeatureTable(geometryColumns, columns);
        this.createFeatureTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(geometryColumns.getTableName());
            contents.setDataType(ContentsDataType.FEATURES);
            contents.setIdentifier(geometryColumns.getTableName());
            if (boundingBox != null) {
                contents.setMinX(boundingBox.getMinLongitude());
                contents.setMinY(boundingBox.getMinLatitude());
                contents.setMaxX(boundingBox.getMaxLongitude());
                contents.setMaxY(boundingBox.getMaxLatitude());
            }
            contents.setSrs(srs);
            this.getContentsDao().create(contents);
            table.setContents(contents);
            geometryColumns.setContents(contents);
            geometryColumns.setSrs(contents.getSrs());
            this.getGeometryColumnsDao().create(geometryColumns);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(geometryColumns.getTableName());
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(geometryColumns.getTableName());
            throw new GeoPackageException("Failed to create table and metadata: " + geometryColumns.getTableName(), e);
        }
        return geometryColumns;
    }

    @Override
    public TileMatrixSetDao getTileMatrixSetDao() {
        return (TileMatrixSetDao)((Object)this.createDao(TileMatrixSet.class));
    }

    @Override
    public boolean createTileMatrixSetTable() {
        this.verifyWritable();
        boolean created = false;
        TileMatrixSetDao dao = this.getTileMatrixSetDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTileMatrixSet() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileMatrixSet.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public TileMatrixDao getTileMatrixDao() {
        return (TileMatrixDao)((Object)this.createDao(TileMatrix.class));
    }

    @Override
    public boolean createTileMatrixTable() {
        this.verifyWritable();
        boolean created = false;
        TileMatrixDao dao = this.getTileMatrixDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTileMatrix() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileMatrix.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createTileTable(TileTable table) {
        this.createUserTable(table);
    }

    @Override
    public TileMatrixSet createTileTableWithMetadata(String tableName, BoundingBox contentsBoundingBox, long contentsSrsId, BoundingBox tileMatrixSetBoundingBox, long tileMatrixSetSrsId) {
        return this.createTileTableWithMetadata(ContentsDataType.TILES, tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId);
    }

    @Override
    public TileMatrixSet createTileTableWithMetadata(ContentsDataType dataType, String tableName, BoundingBox contentsBoundingBox, long contentsSrsId, BoundingBox tileMatrixSetBoundingBox, long tileMatrixSetSrsId) {
        TileMatrixSet tileMatrixSet = null;
        SpatialReferenceSystem contentsSrs = this.getSrs(contentsSrsId);
        SpatialReferenceSystem tileMatrixSetSrs = this.getSrs(tileMatrixSetSrsId);
        this.createTileMatrixSetTable();
        this.createTileMatrixTable();
        List<TileColumn> columns = TileTable.createRequiredColumns();
        TileTable table = new TileTable(tableName, columns);
        this.createTileTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(tableName);
            contents.setDataType(dataType);
            contents.setIdentifier(tableName);
            contents.setMinX(contentsBoundingBox.getMinLongitude());
            contents.setMinY(contentsBoundingBox.getMinLatitude());
            contents.setMaxX(contentsBoundingBox.getMaxLongitude());
            contents.setMaxY(contentsBoundingBox.getMaxLatitude());
            contents.setSrs(contentsSrs);
            this.getContentsDao().create(contents);
            table.setContents(contents);
            tileMatrixSet = new TileMatrixSet();
            tileMatrixSet.setContents(contents);
            tileMatrixSet.setSrs(tileMatrixSetSrs);
            tileMatrixSet.setMinX(tileMatrixSetBoundingBox.getMinLongitude());
            tileMatrixSet.setMinY(tileMatrixSetBoundingBox.getMinLatitude());
            tileMatrixSet.setMaxX(tileMatrixSetBoundingBox.getMaxLongitude());
            tileMatrixSet.setMaxY(tileMatrixSetBoundingBox.getMaxLatitude());
            this.getTileMatrixSetDao().create(tileMatrixSet);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(tableName);
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(tableName);
            throw new GeoPackageException("Failed to create table and metadata: " + tableName, e);
        }
        return tileMatrixSet;
    }

    private SpatialReferenceSystem getSrs(long srsId) {
        SpatialReferenceSystem srs;
        try {
            srs = this.getSpatialReferenceSystemDao().queryForId(srsId);
        }
        catch (SQLException e1) {
            throw new GeoPackageException("Failed to retrieve Spatial Reference System. SRS ID: " + srsId);
        }
        if (srs == null) {
            throw new GeoPackageException("Spatial Reference System could not be found. SRS ID: " + srsId);
        }
        return srs;
    }

    @Override
    public DataColumnsDao getDataColumnsDao() {
        return (DataColumnsDao)((Object)this.createDao(DataColumns.class));
    }

    @Override
    public boolean createDataColumnsTable() {
        this.verifyWritable();
        boolean created = false;
        DataColumnsDao dao = this.getDataColumnsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createDataColumns() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + DataColumns.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public DataColumnConstraintsDao getDataColumnConstraintsDao() {
        return (DataColumnConstraintsDao)((Object)this.createDao(DataColumnConstraints.class));
    }

    @Override
    public boolean createDataColumnConstraintsTable() {
        this.verifyWritable();
        boolean created = false;
        DataColumnConstraintsDao dao = this.getDataColumnConstraintsDao();
        try {
            if (!dao.isTableExists()) {
                boolean bl = created = this.tableCreator.createDataColumnConstraints() > 0;
                if (created) {
                    SchemaExtension schemaExtension = new SchemaExtension(this);
                    schemaExtension.getOrCreate();
                }
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + DataColumnConstraints.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public MetadataDao getMetadataDao() {
        return (MetadataDao)((Object)this.createDao(Metadata.class));
    }

    @Override
    public boolean createMetadataTable() {
        this.verifyWritable();
        boolean created = false;
        MetadataDao dao = this.getMetadataDao();
        try {
            if (!dao.isTableExists()) {
                boolean bl = created = this.tableCreator.createMetadata() > 0;
                if (created) {
                    MetadataExtension metadataExtension = new MetadataExtension(this);
                    metadataExtension.getOrCreate();
                }
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + Metadata.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public MetadataReferenceDao getMetadataReferenceDao() {
        return (MetadataReferenceDao)((Object)this.createDao(MetadataReference.class));
    }

    @Override
    public boolean createMetadataReferenceTable() {
        this.verifyWritable();
        boolean created = false;
        MetadataReferenceDao dao = this.getMetadataReferenceDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createMetadataReference() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + MetadataReference.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public ExtensionsDao getExtensionsDao() {
        return (ExtensionsDao)((Object)this.createDao(Extensions.class));
    }

    @Override
    public boolean createExtensionsTable() {
        this.verifyWritable();
        boolean created = false;
        ExtensionsDao dao = this.getExtensionsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createExtensions() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + Extensions.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void deleteTable(String table) {
        this.verifyWritable();
        GeoPackageExtensions.deleteTableExtensions(this, table);
        ContentsDao contentsDao = this.getContentsDao();
        contentsDao.deleteTable(table);
    }

    @Override
    public void deleteTableQuietly(String tableName) {
        this.verifyWritable();
        try {
            this.deleteTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public <T, S extends BaseDaoImpl<T, ?>> S createDao(Class<T> type) {
        BaseDaoImpl dao;
        try {
            dao = (BaseDaoImpl)DaoManager.createDao((ConnectionSource)this.database.getConnectionSource(), type);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create " + type.getSimpleName() + " dao", e);
        }
        return (S)dao;
    }

    @Override
    public void endTransaction() {
        this.endTransaction(true);
    }

    @Override
    public void failTransaction() {
        this.endTransaction(false);
    }

    @Override
    public void endAndBeginTransaction() {
        this.endTransaction();
        this.beginTransaction();
    }

    @Override
    public <T> T callInTransaction(Callable<T> callable) throws SQLException {
        return (T)TransactionManager.callInTransaction((ConnectionSource)this.database.getConnectionSource(), callable);
    }

    @Override
    public boolean enableForeignKeys() {
        return this.database.enableForeignKeys();
    }

    @Override
    public boolean foreignKeys() {
        return this.database.foreignKeys();
    }

    @Override
    public boolean foreignKeys(boolean on) {
        return this.database.foreignKeys(on);
    }

    private void verifyTableExists(BaseDaoImpl<?, ?> dao) {
        try {
            if (!dao.isTableExists()) {
                throw new GeoPackageException("Table or view does not exist for: " + dao.getDataClass().getSimpleName());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to detect if table or view exists for dao: " + dao.getDataClass().getSimpleName(), e);
        }
    }

    @Override
    public void verifyWritable() {
        if (!this.writable) {
            throw new GeoPackageException("GeoPackage file is not writable. Name: " + this.name + (this.path != null ? ", Path: " + this.path : ""));
        }
    }

    @Override
    public void dropTable(String table) {
        this.tableCreator.dropTable(table);
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        if (this.getTableDataType(tableName) != null) {
            this.copyTable(tableName, newTableName);
            this.deleteTable(tableName);
        } else {
            AlterTable.renameTable(this.database, tableName, newTableName);
        }
    }

    @Override
    public void copyTable(String tableName, String newTableName) {
        this.copyTable(tableName, newTableName, true, true);
    }

    @Override
    public void copyTableNoExtensions(String tableName, String newTableName) {
        this.copyTable(tableName, newTableName, true, false);
    }

    @Override
    public void copyTableAsEmpty(String tableName, String newTableName) {
        this.copyTable(tableName, newTableName, false, false);
    }

    protected void copyTable(String tableName, String newTableName, boolean transferContent, boolean extensions) {
        block7: {
            block6: {
                ContentsDataType dataType = this.getTableDataType(tableName);
                if (dataType == null) break block6;
                switch (dataType) {
                    case ATTRIBUTES: {
                        this.copyAttributeTable(tableName, newTableName, transferContent);
                        break block7;
                    }
                    case FEATURES: {
                        this.copyFeatureTable(tableName, newTableName, transferContent);
                        break block7;
                    }
                    case TILES: 
                    case GRIDDED_COVERAGE: {
                        this.copyTileTable(tableName, newTableName, transferContent);
                        break block7;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported data type: " + (Object)((Object)dataType));
                    }
                }
            }
            this.copyUserTable(tableName, newTableName, transferContent, false);
        }
        if (extensions) {
            GeoPackageExtensions.copyTableExtensions(this, tableName, newTableName);
        }
    }

    protected void copyAttributeTable(String tableName, String newTableName, boolean transferContent) {
        this.copyUserTable(tableName, newTableName, transferContent);
    }

    protected void copyFeatureTable(String tableName, String newTableName, boolean transferContent) {
        GeometryColumnsDao geometryColumnsDao = this.getGeometryColumnsDao();
        GeometryColumns geometryColumns = null;
        try {
            geometryColumns = geometryColumnsDao.queryForTableName(tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table geometry columns: " + tableName, e);
        }
        if (geometryColumns == null) {
            throw new GeoPackageException("No geometry columns for table: " + tableName);
        }
        Contents contents = this.copyUserTable(tableName, newTableName, transferContent);
        geometryColumns.setContents(contents);
        try {
            geometryColumnsDao.create(geometryColumns);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create geometry columns for feature table: " + newTableName, e);
        }
    }

    protected void copyTileTable(String tableName, String newTableName, boolean transferContent) {
        TileMatrixSetDao tileMatrixSetDao = this.getTileMatrixSetDao();
        TileMatrixSet tileMatrixSet = null;
        try {
            tileMatrixSet = (TileMatrixSet)tileMatrixSetDao.queryForId(tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table tile matrix set: " + tableName, e);
        }
        if (tileMatrixSet == null) {
            throw new GeoPackageException("No tile matrix set for table: " + tableName);
        }
        TileMatrixDao tileMatrixDao = this.getTileMatrixDao();
        List tileMatrixes = null;
        try {
            tileMatrixes = tileMatrixDao.queryForEq("table_name", tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table tile matrixes: " + tableName, e);
        }
        Contents contents = this.copyUserTable(tableName, newTableName, transferContent);
        tileMatrixSet.setContents(contents);
        try {
            tileMatrixSetDao.create(tileMatrixSet);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create tile matrix set for tile table: " + newTableName, e);
        }
        for (TileMatrix tileMatrix : tileMatrixes) {
            tileMatrix.setContents(contents);
            try {
                tileMatrixDao.create(tileMatrix);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create tile matrix for tile table: " + newTableName, e);
            }
        }
    }

    protected Contents copyUserTable(String tableName, String newTableName, boolean transferContent) {
        return this.copyUserTable(tableName, newTableName, transferContent, true);
    }

    protected Contents copyUserTable(String tableName, String newTableName, boolean transferContent, boolean validateContents) {
        AlterTable.copyTable(this.database, tableName, newTableName, transferContent);
        Contents contents = this.copyContents(tableName, newTableName);
        if (contents == null && validateContents) {
            throw new GeoPackageException("No table contents found for table: " + tableName);
        }
        return contents;
    }

    protected Contents copyContents(String tableName, String newTableName) {
        Contents contents = this.getTableContents(tableName);
        if (contents != null) {
            contents.setTableName(newTableName);
            contents.setIdentifier(newTableName);
            try {
                this.getContentsDao().create(contents);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create contents for table: " + newTableName + ", copied from table: " + tableName, e);
            }
        }
        return contents;
    }

    @Override
    public void vacuum() {
        CoreSQLUtils.vacuum(this.database);
    }

    @Override
    public GriddedCoverageDao getGriddedCoverageDao() {
        return (GriddedCoverageDao)((Object)this.createDao(GriddedCoverage.class));
    }

    @Override
    public boolean createGriddedCoverageTable() {
        this.verifyWritable();
        boolean created = false;
        GriddedCoverageDao dao = this.getGriddedCoverageDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createGriddedCoverage() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GriddedCoverage.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public GriddedTileDao getGriddedTileDao() {
        return (GriddedTileDao)((Object)this.createDao(GriddedTile.class));
    }

    @Override
    public boolean createGriddedTileTable() {
        this.verifyWritable();
        boolean created = false;
        GriddedTileDao dao = this.getGriddedTileDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createGriddedTile() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GriddedTile.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public TableIndexDao getTableIndexDao() {
        return (TableIndexDao)((Object)this.createDao(TableIndex.class));
    }

    @Override
    public boolean createTableIndexTable() {
        this.verifyWritable();
        boolean created = false;
        TableIndexDao dao = this.getTableIndexDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTableIndex() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TableIndex.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public GeometryIndexDao getGeometryIndexDao() {
        return (GeometryIndexDao)((Object)this.createDao(GeometryIndex.class));
    }

    @Override
    public boolean createGeometryIndexTable() {
        this.verifyWritable();
        boolean created = false;
        GeometryIndexDao dao = this.getGeometryIndexDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createGeometryIndex() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GeometryIndex.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public boolean indexGeometryIndexTable() {
        this.verifyWritable();
        boolean indexed = false;
        GeometryIndexDao dao = this.getGeometryIndexDao();
        try {
            if (dao.isTableExists()) {
                indexed = this.tableCreator.indexGeometryIndex() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GeometryIndex.class.getSimpleName() + " table exists to index", e);
        }
        return indexed;
    }

    @Override
    public boolean unindexGeometryIndexTable() {
        this.verifyWritable();
        boolean unindexed = false;
        GeometryIndexDao dao = this.getGeometryIndexDao();
        try {
            if (dao.isTableExists()) {
                unindexed = this.tableCreator.unindexGeometryIndex() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GeometryIndex.class.getSimpleName() + " table exists to unindex", e);
        }
        return unindexed;
    }

    @Override
    public FeatureTileLinkDao getFeatureTileLinkDao() {
        return (FeatureTileLinkDao)((Object)this.createDao(FeatureTileLink.class));
    }

    @Override
    public boolean createFeatureTileLinkTable() {
        this.verifyWritable();
        boolean created = false;
        FeatureTileLinkDao dao = this.getFeatureTileLinkDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createFeatureTileLink() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + FeatureTileLink.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createAttributesTable(AttributesTable table) {
        this.createUserTable(table);
    }

    @Override
    public AttributesTable createAttributesTableWithId(String tableName, List<AttributesColumn> additionalColumns) {
        return this.createAttributesTable(tableName, (String)null, additionalColumns);
    }

    @Override
    public AttributesTable createAttributesTableWithId(String tableName, List<AttributesColumn> additionalColumns, Collection<Constraint> constraints) {
        return this.createAttributesTable(tableName, null, additionalColumns, constraints);
    }

    @Override
    public AttributesTable createAttributesTable(String tableName, String idColumnName, List<AttributesColumn> additionalColumns) {
        return this.createAttributesTable(tableName, idColumnName, additionalColumns, null);
    }

    @Override
    public AttributesTable createAttributesTable(String tableName, String idColumnName, List<AttributesColumn> additionalColumns, Collection<Constraint> constraints) {
        if (idColumnName == null) {
            idColumnName = "id";
        }
        ArrayList<AttributesColumn> columns = new ArrayList<AttributesColumn>();
        columns.add(AttributesColumn.createPrimaryKeyColumn(idColumnName));
        if (additionalColumns != null) {
            columns.addAll(additionalColumns);
        }
        return this.createAttributesTable(tableName, columns, constraints);
    }

    @Override
    public AttributesTable createAttributesTable(String tableName, List<AttributesColumn> columns) {
        return this.createAttributesTable(tableName, columns, null);
    }

    @Override
    public AttributesTable createAttributesTable(String tableName, List<AttributesColumn> columns, Collection<Constraint> constraints) {
        AttributesTable table = new AttributesTable(tableName, columns);
        if (constraints != null) {
            table.addConstraints(constraints);
        }
        this.createAttributesTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(tableName);
            contents.setDataType(ContentsDataType.ATTRIBUTES);
            contents.setIdentifier(tableName);
            this.getContentsDao().create(contents);
            table.setContents(contents);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(tableName);
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(tableName);
            throw new GeoPackageException("Failed to create table and metadata: " + tableName, e);
        }
        return table;
    }

    @Override
    public TileScalingDao getTileScalingDao() {
        return (TileScalingDao)((Object)this.createDao(TileScaling.class));
    }

    @Override
    public boolean createTileScalingTable() {
        this.verifyWritable();
        boolean created = false;
        TileScalingDao dao = this.getTileScalingDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTileScaling() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileScaling.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public ExtendedRelationsDao getExtendedRelationsDao() {
        return (ExtendedRelationsDao)((Object)this.createDao(ExtendedRelation.class));
    }

    @Override
    public boolean createExtendedRelationsTable() {
        this.verifyWritable();
        boolean created = false;
        ExtendedRelationsDao dao = this.getExtendedRelationsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createExtendedRelations() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + ExtendedRelation.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public ContentsIdDao getContentsIdDao() {
        return (ContentsIdDao)((Object)this.createDao(ContentsId.class));
    }

    @Override
    public boolean createContentsIdTable() {
        this.verifyWritable();
        boolean created = false;
        ContentsIdDao dao = this.getContentsIdDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createContentsId() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + ContentsId.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createUserTable(UserTable<? extends UserColumn> table) {
        this.verifyWritable();
        this.tableCreator.createTable(table);
    }
}

