/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.columns;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.core.contents.ContentsDataType;
import mil.nga.geopackage.core.srs.SpatialReferenceSystem;
import mil.nga.geopackage.features.columns.GeometryColumnsSfSqlDao;
import mil.nga.geopackage.schema.TableColumnKey;
import mil.nga.sf.GeometryType;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.wkb.GeometryCodes;

@DatabaseTable(tableName="geometry_columns", daoClass=GeometryColumnsSfSqlDao.class)
public class GeometryColumnsSfSql {
    public static final String TABLE_NAME = "geometry_columns";
    public static final String COLUMN_F_TABLE_NAME = "f_table_name";
    public static final String COLUMN_F_GEOMETRY_COLUMN = "f_geometry_column";
    public static final String COLUMN_ID_1 = "f_table_name";
    public static final String COLUMN_ID_2 = "f_geometry_column";
    public static final String COLUMN_GEOMETRY_TYPE = "geometry_type";
    public static final String COLUMN_COORD_DIMENSION = "coord_dimension";
    public static final String COLUMN_SRID = "srid";
    @DatabaseField(columnName="f_table_name", canBeNull=false, unique=true, foreign=true, foreignAutoRefresh=true)
    private Contents contents;
    @DatabaseField(columnName="f_table_name", id=true, canBeNull=false, uniqueCombo=true, readOnly=true)
    private String fTableName;
    @DatabaseField(columnName="f_geometry_column", canBeNull=false, uniqueCombo=true)
    private String fGeometryColumn;
    @DatabaseField(columnName="geometry_type", canBeNull=false)
    private int geometryType;
    @DatabaseField(columnName="coord_dimension", canBeNull=false)
    private byte coordDimension;
    @DatabaseField(columnName="srid", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private SpatialReferenceSystem srs;
    @DatabaseField(columnName="srid", canBeNull=false, readOnly=true)
    private long srid;

    public GeometryColumnsSfSql() {
    }

    public GeometryColumnsSfSql(GeometryColumnsSfSql geometryColumns) {
        this.contents = geometryColumns.contents;
        this.fTableName = geometryColumns.fTableName;
        this.fGeometryColumn = geometryColumns.fGeometryColumn;
        this.geometryType = geometryColumns.geometryType;
        this.coordDimension = geometryColumns.coordDimension;
        this.srs = geometryColumns.srs;
        this.srid = geometryColumns.srid;
    }

    public TableColumnKey getId() {
        return new TableColumnKey(this.fTableName, this.fGeometryColumn);
    }

    public void setId(TableColumnKey id) {
        this.fTableName = id.getTableName();
        this.fGeometryColumn = id.getColumnName();
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        if (contents != null) {
            ContentsDataType dataType = contents.getDataType();
            if (dataType == null || dataType != ContentsDataType.FEATURES) {
                throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + GeometryColumnsSfSql.class.getSimpleName() + " must have a data type of " + ContentsDataType.FEATURES.getName());
            }
            this.fTableName = contents.getId();
        }
    }

    public String getFTableName() {
        return this.fTableName;
    }

    public String getFGeometryColumn() {
        return this.fGeometryColumn;
    }

    public void setFGeometryColumn(String fGeometryColumn) {
        this.fGeometryColumn = fGeometryColumn;
    }

    public GeometryType getGeometryType() {
        return GeometryCodes.getGeometryType((int)this.geometryType);
    }

    public void setGeometryType(GeometryType geometryType) {
        this.geometryType = GeometryCodes.getCode((GeometryType)geometryType);
    }

    public int getGeometryTypeCode() {
        return this.geometryType;
    }

    public void setCoordDimension(byte coordDimension) {
        this.validateCoordDimension(COLUMN_COORD_DIMENSION, coordDimension);
        this.coordDimension = coordDimension;
    }

    public byte getCoordDimension() {
        return this.coordDimension;
    }

    public SpatialReferenceSystem getSrs() {
        return this.srs;
    }

    public void setSrs(SpatialReferenceSystem srs) {
        this.srs = srs;
        if (srs != null) {
            this.srid = srs.getId();
        }
    }

    public long getSrid() {
        return this.srid;
    }

    public Projection getProjection() {
        return this.getSrs().getProjection();
    }

    private void validateCoordDimension(String column, byte value) {
        if (value < 2 || value > 5) {
            throw new GeoPackageException(column + " value must be between 2 and 5");
        }
    }
}

