/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.schema.columns;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.core.contents.Contents;
import mil.nga.geopackage.schema.TableColumnKey;
import mil.nga.geopackage.schema.columns.DataColumnsDao;
import mil.nga.geopackage.schema.constraints.DataColumnConstraints;
import mil.nga.geopackage.schema.constraints.DataColumnConstraintsDao;

@DatabaseTable(tableName="gpkg_data_columns", daoClass=DataColumnsDao.class)
public class DataColumns {
    public static final String TABLE_NAME = "gpkg_data_columns";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_COLUMN_NAME = "column_name";
    public static final String COLUMN_ID_1 = "table_name";
    public static final String COLUMN_ID_2 = "column_name";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_TITLE = "title";
    public static final String COLUMN_DESCRIPTION = "description";
    public static final String COLUMN_MIME_TYPE = "mime_type";
    public static final String COLUMN_CONSTRAINT_NAME = "constraint_name";
    @DatabaseField(columnName="table_name", canBeNull=false, unique=true, foreign=true, foreignAutoRefresh=true)
    private Contents contents;
    @DatabaseField(columnName="table_name", id=true, canBeNull=false, uniqueCombo=true, readOnly=true)
    private String tableName;
    @DatabaseField(columnName="column_name", canBeNull=false, uniqueCombo=true)
    private String columnName;
    @DatabaseField(columnName="name")
    private String name;
    @DatabaseField(columnName="title")
    private String title;
    @DatabaseField(columnName="description")
    private String description;
    @DatabaseField(columnName="mime_type")
    private String mimeType;
    @DatabaseField(columnName="constraint_name")
    private String constraintName;

    public DataColumns() {
    }

    public DataColumns(DataColumns dataColumns) {
        this.contents = dataColumns.contents;
        this.tableName = dataColumns.tableName;
        this.columnName = dataColumns.columnName;
        this.name = dataColumns.name;
        this.title = dataColumns.title;
        this.description = dataColumns.description;
        this.mimeType = dataColumns.mimeType;
        this.constraintName = dataColumns.constraintName;
    }

    public TableColumnKey getId() {
        return new TableColumnKey(this.tableName, this.columnName);
    }

    public void setId(TableColumnKey id) {
        this.tableName = id.getTableName();
        this.columnName = id.getColumnName();
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        this.tableName = contents != null ? contents.getId() : null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraint(DataColumnConstraints constraint) {
        String name = null;
        if (constraint != null) {
            name = constraint.getConstraintName();
        }
        this.setConstraintName(name);
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public List<DataColumnConstraints> getConstraints(DataColumnConstraintsDao dao) throws SQLException {
        List<DataColumnConstraints> constraints = null;
        if (this.constraintName != null) {
            constraints = dao.queryByConstraintName(this.constraintName);
        }
        return constraints;
    }
}

