/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.user;

import java.util.List;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.user.UserColumns;

public class TileColumns
extends UserColumns<TileColumn> {
    public static final String ID = "id";
    public static final String ZOOM_LEVEL = "zoom_level";
    public static final String TILE_COLUMN = "tile_column";
    public static final String TILE_ROW = "tile_row";
    public static final String TILE_DATA = "tile_data";
    private int zoomLevelIndex = -1;
    private int tileColumnIndex = -1;
    private int tileRowIndex = -1;
    private int tileDataIndex = -1;

    public TileColumns(String tableName, List<TileColumn> columns) {
        this(tableName, columns, false);
    }

    public TileColumns(String tableName, List<TileColumn> columns, boolean custom) {
        super(tableName, columns, custom);
        this.updateColumns();
    }

    public TileColumns(TileColumns tileColumns) {
        super(tileColumns);
        this.zoomLevelIndex = tileColumns.zoomLevelIndex;
        this.tileColumnIndex = tileColumns.tileColumnIndex;
        this.tileRowIndex = tileColumns.tileRowIndex;
        this.tileDataIndex = tileColumns.tileDataIndex;
    }

    public TileColumns copy() {
        return new TileColumns(this);
    }

    @Override
    protected void updateColumns() {
        super.updateColumns();
        Integer zoomLevel = this.getColumnIndex(ZOOM_LEVEL, false);
        if (!this.isCustom()) {
            this.missingCheck(zoomLevel, ZOOM_LEVEL);
        }
        if (zoomLevel != null) {
            this.typeCheck(GeoPackageDataType.INTEGER, this.getColumn(zoomLevel));
            this.zoomLevelIndex = zoomLevel;
        }
        Integer tileColumn = this.getColumnIndex(TILE_COLUMN, false);
        if (!this.isCustom()) {
            this.missingCheck(tileColumn, TILE_COLUMN);
        }
        if (tileColumn != null) {
            this.typeCheck(GeoPackageDataType.INTEGER, this.getColumn(tileColumn));
            this.tileColumnIndex = tileColumn;
        }
        Integer tileRow = this.getColumnIndex(TILE_ROW, false);
        if (!this.isCustom()) {
            this.missingCheck(tileRow, TILE_ROW);
        }
        if (tileRow != null) {
            this.typeCheck(GeoPackageDataType.INTEGER, this.getColumn(tileRow));
            this.tileRowIndex = tileRow;
        }
        Integer tileData = this.getColumnIndex(TILE_DATA, false);
        if (!this.isCustom()) {
            this.missingCheck(tileData, TILE_DATA);
        }
        if (tileData != null) {
            this.typeCheck(GeoPackageDataType.BLOB, this.getColumn(tileData));
            this.tileDataIndex = tileData;
        }
    }

    public int getZoomLevelIndex() {
        return this.zoomLevelIndex;
    }

    public void setZoomLevelIndex(int zoomLevelIndex) {
        this.zoomLevelIndex = zoomLevelIndex;
    }

    public boolean hasZoomLevelColumn() {
        return this.zoomLevelIndex >= 0;
    }

    public TileColumn getZoomLevelColumn() {
        TileColumn column = null;
        if (this.hasZoomLevelColumn()) {
            column = (TileColumn)this.getColumn(this.zoomLevelIndex);
        }
        return column;
    }

    public int getTileColumnIndex() {
        return this.tileColumnIndex;
    }

    public void setTileColumnIndex(int tileColumnIndex) {
        this.tileColumnIndex = tileColumnIndex;
    }

    public boolean hasTileColumnColumn() {
        return this.tileColumnIndex >= 0;
    }

    public TileColumn getTileColumnColumn() {
        TileColumn column = null;
        if (this.hasTileColumnColumn()) {
            column = (TileColumn)this.getColumn(this.tileColumnIndex);
        }
        return column;
    }

    public int getTileRowIndex() {
        return this.tileRowIndex;
    }

    public void setTileRowIndex(int tileRowIndex) {
        this.tileRowIndex = tileRowIndex;
    }

    public boolean hasTileRowColumn() {
        return this.tileRowIndex >= 0;
    }

    public TileColumn getTileRowColumn() {
        TileColumn column = null;
        if (this.hasTileRowColumn()) {
            column = (TileColumn)this.getColumn(this.tileRowIndex);
        }
        return column;
    }

    public int getTileDataIndex() {
        return this.tileDataIndex;
    }

    public void setTileDataIndex(int tileDataIndex) {
        this.tileDataIndex = tileDataIndex;
    }

    public boolean hasTileDataColumn() {
        return this.tileDataIndex >= 0;
    }

    public TileColumn getTileDataColumn() {
        TileColumn column = null;
        if (this.hasTileDataColumn()) {
            column = (TileColumn)this.getColumn(this.tileDataIndex);
        }
        return column;
    }
}

