/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.UserColumn;

public abstract class UserColumns<TColumn extends UserColumn> {
    private String tableName;
    private String[] columnNames;
    private final List<TColumn> columns;
    private boolean custom;
    private final Map<String, Integer> nameToIndex;
    private int pkIndex;

    protected UserColumns(String tableName, List<TColumn> columns, boolean custom) {
        this.tableName = tableName;
        this.columns = columns;
        this.custom = custom;
        this.nameToIndex = new HashMap<String, Integer>();
    }

    protected UserColumns(UserColumns<TColumn> userColumns) {
        this.tableName = userColumns.tableName;
        this.columnNames = new String[userColumns.columnNames.length];
        System.arraycopy(userColumns.columnNames, 0, this.columnNames, 0, this.columnNames.length);
        this.columns = new ArrayList<TColumn>();
        for (UserColumn column : userColumns.columns) {
            UserColumn copiedColumn = column.copy();
            this.columns.add(copiedColumn);
        }
        this.nameToIndex = new HashMap<String, Integer>();
        this.nameToIndex.putAll(userColumns.nameToIndex);
        this.pkIndex = userColumns.pkIndex;
    }

    public abstract UserColumns<TColumn> copy();

    protected void updateColumns() {
        this.nameToIndex.clear();
        if (!this.custom) {
            HashSet<Integer> indices = new HashSet<Integer>();
            ArrayList<Object> needsIndex = new ArrayList<Object>();
            for (Object column : this.columns) {
                if (((UserColumn)column).hasIndex()) {
                    int n = ((UserColumn)column).getIndex();
                    if (indices.contains(n)) {
                        throw new GeoPackageException("Duplicate index: " + n + ", Table Name: " + this.tableName);
                    }
                    indices.add(n);
                    continue;
                }
                needsIndex.add(column);
            }
            int currentIndex = -1;
            for (UserColumn userColumn : needsIndex) {
                while (indices.contains(++currentIndex)) {
                }
                userColumn.setIndex(currentIndex);
            }
            Collections.sort(this.columns);
        }
        this.pkIndex = -1;
        this.columnNames = new String[this.columns.size()];
        for (int index = 0; index < this.columns.size(); ++index) {
            UserColumn column = (UserColumn)this.columns.get(index);
            String columnName = column.getName();
            String lowerCaseColumnName = columnName.toLowerCase();
            if (!this.custom) {
                if (column.getIndex() != index) {
                    throw new GeoPackageException("No column found at index: " + index + ", Table Name: " + this.tableName);
                }
                if (this.nameToIndex.containsKey(lowerCaseColumnName)) {
                    throw new GeoPackageException("Duplicate column found at index: " + index + ", Table Name: " + this.tableName + ", Name: " + columnName);
                }
            }
            if (column.isPrimaryKey()) {
                if (this.pkIndex != -1) {
                    StringBuilder stringBuilder = new StringBuilder("More than one primary key column was found for ");
                    if (this.custom) {
                        stringBuilder.append("custom specified table columns");
                    } else {
                        stringBuilder.append("table");
                    }
                    stringBuilder.append(". table: " + this.tableName + ", index1: " + this.pkIndex + ", index2: " + index);
                    if (this.custom) {
                        stringBuilder.append(", columns: " + this.columnNames);
                    }
                    throw new GeoPackageException(stringBuilder.toString());
                }
                this.pkIndex = index;
            }
            this.columnNames[index] = columnName;
            this.nameToIndex.put(lowerCaseColumnName, index);
        }
    }

    protected void duplicateCheck(int index, Integer previousIndex, String column) {
        if (previousIndex != null) {
            throw new GeoPackageException("More than one " + column + " column was found for table '" + this.tableName + "'. Index " + previousIndex + " and " + index);
        }
    }

    protected void typeCheck(GeoPackageDataType expected, TColumn column) {
        GeoPackageDataType actual = ((UserColumn)column).getDataType();
        if (actual == null || !actual.equals((Object)expected)) {
            throw new GeoPackageException("Unexpected " + ((UserColumn)column).getName() + " column data type was found for table '" + this.tableName + "', expected: " + expected.name() + ", actual: " + (actual != null ? actual.name() : "null"));
        }
    }

    protected void missingCheck(Integer index, String column) {
        if (index == null) {
            throw new GeoPackageException("No " + column + " column was found for table '" + this.tableName + "'");
        }
    }

    public int getColumnIndex(String columnName) {
        return this.getColumnIndex(columnName, true);
    }

    public Integer getColumnIndex(String columnName, boolean required) {
        Integer index = this.nameToIndex.get(columnName.toLowerCase());
        if (required && index == null) {
            StringBuilder error = new StringBuilder("Column does not exist in ");
            if (this.custom) {
                error.append("custom specified table columns");
            } else {
                error.append("table");
            }
            error.append(". table: " + this.tableName + ", column: " + columnName);
            if (this.custom) {
                error.append(", columns: " + this.columnNames);
            }
            throw new GeoPackageException(error.toString());
        }
        return index;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public List<TColumn> getColumns() {
        return this.columns;
    }

    public TColumn getColumn(int index) {
        return (TColumn)((UserColumn)this.columns.get(index));
    }

    public TColumn getColumn(String columnName) {
        return this.getColumn(this.getColumnIndex(columnName));
    }

    public boolean hasColumn(String columnName) {
        return this.nameToIndex.containsKey(columnName.toLowerCase());
    }

    public int columnCount() {
        return this.columns.size();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean hasPkColumn() {
        return this.pkIndex >= 0;
    }

    public int getPkColumnIndex() {
        return this.pkIndex;
    }

    public TColumn getPkColumn() {
        UserColumn column = null;
        if (this.hasPkColumn()) {
            column = (UserColumn)this.columns.get(this.pkIndex);
        }
        return (TColumn)column;
    }

    public String getPkColumnName() {
        return ((UserColumn)this.getPkColumn()).getName();
    }

    public List<TColumn> columnsOfType(GeoPackageDataType type) {
        ArrayList<UserColumn> columnsOfType = new ArrayList<UserColumn>();
        for (UserColumn column : this.columns) {
            if (column.getDataType() != type) continue;
            columnsOfType.add(column);
        }
        return columnsOfType;
    }

    public void addColumn(TColumn column) {
        this.columns.add(column);
        this.updateColumns();
    }

    public void renameColumn(TColumn column, String newColumnName) {
        this.renameColumn(((UserColumn)column).getName(), newColumnName);
        ((UserColumn)column).setName(newColumnName);
    }

    public void renameColumn(String columnName, String newColumnName) {
        this.renameColumn(this.getColumnIndex(columnName), newColumnName);
    }

    public void renameColumn(int index, String newColumnName) {
        ((UserColumn)this.columns.get(index)).setName(newColumnName);
        this.updateColumns();
    }

    public void dropColumn(TColumn column) {
        this.dropColumn(((UserColumn)column).getIndex());
    }

    public void dropColumn(String columnName) {
        this.dropColumn(this.getColumnIndex(columnName));
    }

    public void dropColumn(int index) {
        this.columns.remove(index);
        for (int i = index; i < this.columns.size(); ++i) {
            ((UserColumn)this.columns.get(i)).resetIndex();
        }
        this.updateColumns();
    }

    public void alterColumn(TColumn column) {
        TColumn existingColumn = this.getColumn(((UserColumn)column).getName());
        ((UserColumn)column).setIndex(((UserColumn)existingColumn).getIndex());
        this.columns.set(((UserColumn)column).getIndex(), column);
    }
}

