/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage;

import com.j256.ormlite.misc.TransactionManager;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.attributes.AttributesTableMetadata;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDao;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.ExtensionManager;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.features.user.FeatureTableMetadata;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixDao;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.geopackage.tiles.user.TileColumn;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.tiles.user.TileTableMetadata;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.sf.proj.Projection;

public abstract class GeoPackageCoreImpl
implements GeoPackageCore {
    private final String name;
    private final String path;
    private final GeoPackageCoreConnection database;
    private final GeoPackageTableCreator tableCreator;
    protected final boolean writable;

    protected GeoPackageCoreImpl(String name, String path, GeoPackageCoreConnection database) {
        this(name, path, database, true);
    }

    protected GeoPackageCoreImpl(String name, String path, GeoPackageCoreConnection database, boolean writable) {
        this.name = name;
        this.path = path;
        this.database = database;
        this.tableCreator = new GeoPackageTableCreator(database);
        this.writable = writable;
    }

    @Override
    public void close() {
        this.database.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public GeoPackageCoreConnection getDatabase() {
        return this.database;
    }

    @Override
    public GeoPackageTableCreator getTableCreator() {
        return this.tableCreator;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public String getApplicationId() {
        return this.database.getApplicationId();
    }

    @Override
    public Integer getApplicationIdInteger() {
        return this.database.getApplicationIdInteger();
    }

    @Override
    public String getApplicationIdHex() {
        return this.database.getApplicationIdHex();
    }

    @Override
    public Integer getUserVersion() {
        return this.database.getUserVersion();
    }

    @Override
    public Integer getUserVersionMajor() {
        return this.database.getUserVersionMajor();
    }

    @Override
    public Integer getUserVersionMinor() {
        return this.database.getUserVersionMinor();
    }

    @Override
    public Integer getUserVersionPatch() {
        return this.database.getUserVersionPatch();
    }

    @Override
    public List<String> getFeatureTables() {
        return this.getTables(ContentsDataType.FEATURES);
    }

    @Override
    public List<String> getTileTables() {
        return this.getTables(ContentsDataType.TILES);
    }

    @Override
    public List<String> getAttributesTables() {
        return this.getTables(ContentsDataType.ATTRIBUTES);
    }

    @Override
    public List<String> getTables(ContentsDataType type) {
        List<String> tableNames;
        try {
            tableNames = this.getContentsDao().getTables(type);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + (Object)((Object)type) + " tables", e);
        }
        return tableNames;
    }

    @Override
    public List<String> getTables(ContentsDataType ... types) {
        List<String> tableNames;
        try {
            tableNames = this.getContentsDao().getTables(types);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve tables of types: " + types, e);
        }
        return tableNames;
    }

    @Override
    public List<String> getTables(String type) {
        List<String> tableNames;
        try {
            tableNames = this.getContentsDao().getTables(type);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + type + " tables", e);
        }
        return tableNames;
    }

    @Override
    public List<String> getTables(String ... types) {
        List<String> tableNames;
        try {
            tableNames = this.getContentsDao().getTables(types);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve tables of types: " + types, e);
        }
        return tableNames;
    }

    @Override
    public List<Contents> getTypeContents(ContentsDataType type) {
        List<Contents> contents;
        try {
            contents = this.getContentsDao().getContents(type);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + (Object)((Object)type) + " contents", e);
        }
        return contents;
    }

    @Override
    public List<Contents> getTypeContents(ContentsDataType ... types) {
        List<Contents> contents;
        try {
            contents = this.getContentsDao().getContents(types);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve contents of types: " + types, e);
        }
        return contents;
    }

    @Override
    public List<Contents> getTypeContents(String type) {
        List<Contents> contents;
        try {
            contents = this.getContentsDao().getContents(type);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + type + " contents", e);
        }
        return contents;
    }

    @Override
    public List<Contents> getTypeContents(String ... types) {
        List<Contents> contents;
        try {
            contents = this.getContentsDao().getContents(types);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve contents of types: " + types, e);
        }
        return contents;
    }

    @Override
    public List<String> getTables() {
        List<String> tables;
        ContentsDao contentDao = this.getContentsDao();
        try {
            tables = contentDao.getTables();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve tables", e);
        }
        return tables;
    }

    @Override
    public boolean isFeatureTable(String table) {
        return this.isTableType(table, ContentsDataType.FEATURES);
    }

    @Override
    public boolean isTileTable(String table) {
        return this.isTableType(table, ContentsDataType.TILES);
    }

    @Override
    public boolean isAttributeTable(String table) {
        return this.isTableType(table, ContentsDataType.ATTRIBUTES);
    }

    @Override
    public boolean isTableType(String table, ContentsDataType type) {
        return this.isTableType(table, new ContentsDataType[]{type});
    }

    @Override
    public boolean isTableType(String table, ContentsDataType ... types) {
        HashSet<ContentsDataType> typeSet = new HashSet<ContentsDataType>(Arrays.asList(types));
        return typeSet.contains((Object)this.getTableDataType(table));
    }

    @Override
    public boolean isTableType(String table, String type) {
        return this.isTableType(table, new String[]{type});
    }

    @Override
    public boolean isTableType(String table, String ... types) {
        ContentsDataType dataType;
        HashSet<String> typeSet = new HashSet<String>(Arrays.asList(types));
        boolean isType = typeSet.contains(this.getTableType(table));
        if (!isType && (dataType = this.getTableDataType(table)) != null) {
            isType = typeSet.contains(dataType.getName());
        }
        return isType;
    }

    @Override
    public boolean isContentsTable(String table) {
        return this.getTableContents(table) != null;
    }

    @Override
    public boolean isTable(String table) {
        return this.database.tableExists(table);
    }

    @Override
    public boolean isView(String view) {
        return this.database.viewExists(view);
    }

    @Override
    public boolean isTableOrView(String name) {
        return this.database.tableOrViewExists(name);
    }

    @Override
    public Contents getTableContents(String table) {
        ContentsDao contentDao = this.getContentsDao();
        Contents contents = null;
        try {
            contents = (Contents)contentDao.queryForId(table);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table contents: " + table, e);
        }
        return contents;
    }

    @Override
    public String getTableType(String table) {
        String tableType = null;
        Contents contents = this.getTableContents(table);
        if (contents != null) {
            tableType = contents.getDataTypeName();
        }
        return tableType;
    }

    @Override
    public ContentsDataType getTableDataType(String table) {
        ContentsDataType tableType = null;
        Contents contents = this.getTableContents(table);
        if (contents != null) {
            tableType = contents.getDataType();
        }
        return tableType;
    }

    @Override
    public BoundingBox getContentsBoundingBox(Projection projection) {
        return this.getContentsDao().getBoundingBox(projection);
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection) {
        return this.getBoundingBox(projection, false);
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection, boolean manual) {
        BoundingBox boundingBox = this.getContentsBoundingBox(projection);
        BoundingBox tableBoundingBox = this.getTableBoundingBox(projection, manual);
        if (tableBoundingBox != null) {
            boundingBox = boundingBox != null ? boundingBox.union(tableBoundingBox) : tableBoundingBox;
        }
        return boundingBox;
    }

    @Override
    public BoundingBox getTableBoundingBox(Projection projection) {
        return this.getTableBoundingBox(projection, false);
    }

    @Override
    public BoundingBox getTableBoundingBox(Projection projection, boolean manual) {
        BoundingBox boundingBox = null;
        List<String> tables = this.getTables();
        for (String table : tables) {
            BoundingBox tableBoundingBox = this.getBoundingBox(projection, table, manual);
            if (tableBoundingBox == null) continue;
            if (boundingBox != null) {
                boundingBox = boundingBox.union(tableBoundingBox);
                continue;
            }
            boundingBox = tableBoundingBox;
        }
        return boundingBox;
    }

    @Override
    public BoundingBox getContentsBoundingBox(String table) {
        ContentsDao contentsDao = this.getContentsDao();
        BoundingBox boundingBox = contentsDao.getBoundingBox(table);
        return boundingBox;
    }

    @Override
    public BoundingBox getContentsBoundingBox(Projection projection, String table) {
        ContentsDao contentsDao = this.getContentsDao();
        BoundingBox boundingBox = contentsDao.getBoundingBox(projection, table);
        return boundingBox;
    }

    @Override
    public BoundingBox getBoundingBox(String table) {
        return this.getBoundingBox(null, table);
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection, String table) {
        return this.getBoundingBox(projection, table, false);
    }

    @Override
    public BoundingBox getBoundingBox(String table, boolean manual) {
        return this.getBoundingBox(null, table, manual);
    }

    @Override
    public BoundingBox getBoundingBox(Projection projection, String table, boolean manual) {
        BoundingBox tableBoundingBox = this.getTableBoundingBox(projection, table, manual);
        if (tableBoundingBox != null && projection == null) {
            projection = this.getProjection(table);
        }
        BoundingBox boundingBox = this.getContentsBoundingBox(projection, table);
        if (tableBoundingBox != null) {
            boundingBox = boundingBox == null ? tableBoundingBox : boundingBox.union(tableBoundingBox);
        }
        return boundingBox;
    }

    @Override
    public BoundingBox getTableBoundingBox(String table) {
        return this.getTableBoundingBox(null, table);
    }

    @Override
    public BoundingBox getTableBoundingBox(Projection projection, String table) {
        return this.getTableBoundingBox(projection, table, false);
    }

    @Override
    public BoundingBox getTableBoundingBox(String table, boolean manual) {
        return this.getTableBoundingBox(null, table, manual);
    }

    @Override
    public BoundingBox getTableBoundingBox(Projection projection, String table, boolean manual) {
        BoundingBox boundingBox = null;
        String tableType = this.getTableType(table);
        ContentsDataType dataType = ContentsDataType.fromName(tableType);
        if (dataType != null) {
            switch (dataType) {
                case FEATURES: {
                    boundingBox = this.getFeatureBoundingBox(projection, table, manual);
                    break;
                }
                case TILES: {
                    TileMatrixSet tileMatrixSet = null;
                    try {
                        tileMatrixSet = (TileMatrixSet)this.getTileMatrixSetDao().queryForId(table);
                    }
                    catch (SQLException e) {
                        throw new GeoPackageException("Failed to retrieve tile matrix set for table: " + table, e);
                    }
                    boundingBox = tileMatrixSet.getBoundingBox(projection);
                    break;
                }
            }
        }
        return boundingBox;
    }

    @Override
    public Projection getContentsProjection(String table) {
        Contents contents = this.getTableContents(table);
        if (contents == null) {
            throw new GeoPackageException("Failed to retrieve contents for table: " + table);
        }
        return contents.getProjection();
    }

    @Override
    public Projection getProjection(String table) {
        Projection projection = null;
        String tableType = this.getTableType(table);
        ContentsDataType dataType = ContentsDataType.fromName(tableType);
        if (dataType != null) {
            switch (dataType) {
                case FEATURES: {
                    GeometryColumns geometryColumns = null;
                    try {
                        geometryColumns = this.getGeometryColumnsDao().queryForTableName(table);
                    }
                    catch (SQLException e) {
                        throw new GeoPackageException("Failed to retrieve geometry columns for table: " + table, e);
                    }
                    projection = geometryColumns.getProjection();
                    break;
                }
                case TILES: {
                    TileMatrixSet tileMatrixSet = null;
                    try {
                        tileMatrixSet = (TileMatrixSet)this.getTileMatrixSetDao().queryForId(table);
                    }
                    catch (SQLException e) {
                        throw new GeoPackageException("Failed to retrieve tile matrix set for table: " + table, e);
                    }
                    projection = tileMatrixSet.getProjection();
                    break;
                }
            }
        }
        if (projection == null) {
            projection = this.getContentsProjection(table);
        }
        return projection;
    }

    @Override
    public SpatialReferenceSystemDao getSpatialReferenceSystemDao() {
        SpatialReferenceSystemDao dao = SpatialReferenceSystemDao.create(this);
        dao.setCrsWktExtension(new CrsWktExtension(this));
        return dao;
    }

    @Override
    public ContentsDao getContentsDao() {
        return ContentsDao.create(this);
    }

    @Override
    public GeometryColumnsDao getGeometryColumnsDao() {
        return GeometryColumnsDao.create(this);
    }

    @Override
    public boolean createGeometryColumnsTable() {
        this.verifyWritable();
        boolean created = false;
        GeometryColumnsDao dao = this.getGeometryColumnsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createGeometryColumns() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GeometryColumns.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createFeatureTable(FeatureTable table) {
        this.createUserTable(table);
    }

    @Override
    public FeatureTable createFeatureTable(FeatureTableMetadata metadata) {
        GeometryColumns geometryColumns = metadata.getGeometryColumns();
        if (geometryColumns == null) {
            throw new GeoPackageException("Geometry Columns are required to create a feature table");
        }
        SpatialReferenceSystem srs = geometryColumns.getSrs();
        if (srs == null) {
            srs = this.getSrs(geometryColumns.getSrsId());
            geometryColumns.setSrs(srs);
        }
        this.createGeometryColumnsTable();
        String tableName = metadata.getTableName();
        FeatureTable table = new FeatureTable(tableName, metadata.getColumnName(), metadata.buildColumns());
        this.createFeatureTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(tableName);
            contents.setDataTypeName(metadata.getDataType(), ContentsDataType.FEATURES);
            contents.setIdentifier(tableName);
            BoundingBox boundingBox = metadata.getBoundingBox();
            if (boundingBox != null) {
                contents.setMinX(boundingBox.getMinLongitude());
                contents.setMinY(boundingBox.getMinLatitude());
                contents.setMaxX(boundingBox.getMaxLongitude());
                contents.setMaxY(boundingBox.getMaxLatitude());
            }
            contents.setSrs(srs);
            this.getContentsDao().create(contents);
            table.setContents(contents);
            geometryColumns.setContents(contents);
            this.getGeometryColumnsDao().create(geometryColumns);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(tableName);
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(tableName);
            throw new GeoPackageException("Failed to create table and metadata: " + tableName, e);
        }
        return table;
    }

    @Override
    public TileMatrixSetDao getTileMatrixSetDao() {
        return TileMatrixSetDao.create(this);
    }

    @Override
    public boolean createTileMatrixSetTable() {
        this.verifyWritable();
        boolean created = false;
        TileMatrixSetDao dao = this.getTileMatrixSetDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTileMatrixSet() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileMatrixSet.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public TileMatrixDao getTileMatrixDao() {
        return TileMatrixDao.create(this);
    }

    @Override
    public boolean createTileMatrixTable() {
        this.verifyWritable();
        boolean created = false;
        TileMatrixDao dao = this.getTileMatrixDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createTileMatrix() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileMatrix.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void createTileTable(TileTable table) {
        this.createUserTable(table);
    }

    @Override
    public TileTable createTileTable(TileTableMetadata metadata) {
        SpatialReferenceSystem contentsSrs = this.getSrs(metadata.getContentsSrsId());
        SpatialReferenceSystem tileMatrixSetSrs = this.getSrs(metadata.getTileSrsId());
        this.createTileMatrixSetTable();
        this.createTileMatrixTable();
        String tableName = metadata.getTableName();
        List<TileColumn> columns = metadata.buildColumns();
        TileTable table = new TileTable(tableName, columns);
        this.createTileTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(tableName);
            contents.setDataTypeName(metadata.getDataType(), ContentsDataType.TILES);
            contents.setIdentifier(tableName);
            BoundingBox contentsBoundingBox = metadata.getContentsBoundingBox();
            contents.setMinX(contentsBoundingBox.getMinLongitude());
            contents.setMinY(contentsBoundingBox.getMinLatitude());
            contents.setMaxX(contentsBoundingBox.getMaxLongitude());
            contents.setMaxY(contentsBoundingBox.getMaxLatitude());
            contents.setSrs(contentsSrs);
            this.getContentsDao().create(contents);
            table.setContents(contents);
            TileMatrixSet tileMatrixSet = new TileMatrixSet();
            tileMatrixSet.setContents(contents);
            tileMatrixSet.setSrs(tileMatrixSetSrs);
            BoundingBox tileMatrixSetBoundingBox = metadata.getTileBoundingBox();
            tileMatrixSet.setMinX(tileMatrixSetBoundingBox.getMinLongitude());
            tileMatrixSet.setMinY(tileMatrixSetBoundingBox.getMinLatitude());
            tileMatrixSet.setMaxX(tileMatrixSetBoundingBox.getMaxLongitude());
            tileMatrixSet.setMaxY(tileMatrixSetBoundingBox.getMaxLatitude());
            this.getTileMatrixSetDao().create(tileMatrixSet);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(tableName);
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(tableName);
            throw new GeoPackageException("Failed to create table and metadata: " + tableName, e);
        }
        return table;
    }

    private SpatialReferenceSystem getSrs(long srsId) {
        SpatialReferenceSystem srs;
        try {
            srs = this.getSpatialReferenceSystemDao().queryForId(srsId);
        }
        catch (SQLException e1) {
            throw new GeoPackageException("Failed to retrieve Spatial Reference System. SRS ID: " + srsId);
        }
        if (srs == null) {
            throw new GeoPackageException("Spatial Reference System could not be found. SRS ID: " + srsId);
        }
        return srs;
    }

    @Override
    public void createAttributesTable(AttributesTable table) {
        this.createUserTable(table);
    }

    @Override
    public AttributesTable createAttributesTable(AttributesTableMetadata metadata) {
        String tableName = metadata.getTableName();
        AttributesTable table = new AttributesTable(tableName, metadata.buildColumns());
        Collection<Constraint> constraints = metadata.getConstraints();
        if (constraints != null) {
            table.addConstraints(constraints);
        }
        this.createAttributesTable(table);
        try {
            Contents contents = new Contents();
            contents.setTableName(tableName);
            contents.setDataTypeName(metadata.getDataType(), ContentsDataType.ATTRIBUTES);
            contents.setIdentifier(tableName);
            this.getContentsDao().create(contents);
            table.setContents(contents);
        }
        catch (RuntimeException e) {
            this.deleteTableQuietly(tableName);
            throw e;
        }
        catch (SQLException e) {
            this.deleteTableQuietly(tableName);
            throw new GeoPackageException("Failed to create table and metadata: " + tableName, e);
        }
        return table;
    }

    @Override
    public ExtensionsDao getExtensionsDao() {
        return ExtensionsDao.create(this);
    }

    @Override
    public boolean createExtensionsTable() {
        this.verifyWritable();
        boolean created = false;
        ExtensionsDao dao = this.getExtensionsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.tableCreator.createExtensions() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + Extensions.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    @Override
    public void deleteTable(String table) {
        this.verifyWritable();
        this.getExtensionManager().deleteTableExtensions(table);
        ContentsDao contentsDao = this.getContentsDao();
        contentsDao.deleteTable(table);
    }

    @Override
    public void deleteTableQuietly(String tableName) {
        this.verifyWritable();
        try {
            this.deleteTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public <D extends GeoPackageDao<T, ?>, T> D createDao(Class<T> type) {
        return GeoPackageDao.createDao(this.database, type);
    }

    @Override
    public void endTransaction() {
        this.endTransaction(true);
    }

    @Override
    public void failTransaction() {
        this.endTransaction(false);
    }

    @Override
    public void endAndBeginTransaction() {
        this.endTransaction();
        this.beginTransaction();
    }

    @Override
    public <T> T callInTransaction(Callable<T> callable) throws SQLException {
        return (T)TransactionManager.callInTransaction((ConnectionSource)this.database.getConnectionSource(), callable);
    }

    @Override
    public boolean enableForeignKeys() {
        return this.database.enableForeignKeys();
    }

    @Override
    public boolean foreignKeys() {
        return this.database.foreignKeys();
    }

    @Override
    public boolean foreignKeys(boolean on) {
        return this.database.foreignKeys(on);
    }

    @Override
    public void verifyWritable() {
        if (!this.writable) {
            throw new GeoPackageException("GeoPackage file is not writable. Name: " + this.name + (this.path != null ? ", Path: " + this.path : ""));
        }
    }

    @Override
    public void dropTable(String table) {
        this.tableCreator.dropTable(table);
    }

    @Override
    public void dropView(String view) {
        this.tableCreator.dropView(view);
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        if (this.getTableDataType(tableName) != null) {
            this.copyTable(tableName, newTableName);
            this.deleteTable(tableName);
        } else {
            AlterTable.renameTable(this.database, tableName, newTableName);
        }
    }

    @Override
    public void copyTable(String tableName, String newTableName) {
        this.copyTable(tableName, newTableName, true, true);
    }

    @Override
    public void copyTableNoExtensions(String tableName, String newTableName) {
        this.copyTable(tableName, newTableName, true, false);
    }

    @Override
    public void copyTableAsEmpty(String tableName, String newTableName) {
        this.copyTable(tableName, newTableName, false, false);
    }

    protected void copyTable(String tableName, String newTableName, boolean transferContent, boolean extensions) {
        block7: {
            block6: {
                ContentsDataType dataType = this.getTableDataType(tableName);
                if (dataType == null) break block6;
                switch (dataType) {
                    case ATTRIBUTES: {
                        this.copyAttributeTable(tableName, newTableName, transferContent);
                        break block7;
                    }
                    case FEATURES: {
                        this.copyFeatureTable(tableName, newTableName, transferContent);
                        break block7;
                    }
                    case TILES: {
                        this.copyTileTable(tableName, newTableName, transferContent);
                        break block7;
                    }
                    default: {
                        throw new GeoPackageException("Unsupported data type: " + (Object)((Object)dataType));
                    }
                }
            }
            this.copyUserTable(tableName, newTableName, transferContent, false);
        }
        if (extensions) {
            this.getExtensionManager().copyTableExtensions(tableName, newTableName);
        }
    }

    protected void copyAttributeTable(String tableName, String newTableName, boolean transferContent) {
        this.copyUserTable(tableName, newTableName, transferContent);
    }

    protected void copyFeatureTable(String tableName, String newTableName, boolean transferContent) {
        GeometryColumnsDao geometryColumnsDao = this.getGeometryColumnsDao();
        GeometryColumns geometryColumns = null;
        try {
            geometryColumns = geometryColumnsDao.queryForTableName(tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table geometry columns: " + tableName, e);
        }
        if (geometryColumns == null) {
            throw new GeoPackageException("No geometry columns for table: " + tableName);
        }
        Contents contents = this.copyUserTable(tableName, newTableName, transferContent);
        geometryColumns.setContents(contents);
        try {
            geometryColumnsDao.create(geometryColumns);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create geometry columns for feature table: " + newTableName, e);
        }
    }

    protected void copyTileTable(String tableName, String newTableName, boolean transferContent) {
        TileMatrixSetDao tileMatrixSetDao = this.getTileMatrixSetDao();
        TileMatrixSet tileMatrixSet = null;
        try {
            tileMatrixSet = (TileMatrixSet)tileMatrixSetDao.queryForId(tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table tile matrix set: " + tableName, e);
        }
        if (tileMatrixSet == null) {
            throw new GeoPackageException("No tile matrix set for table: " + tableName);
        }
        TileMatrixDao tileMatrixDao = this.getTileMatrixDao();
        List tileMatrixes = null;
        try {
            tileMatrixes = tileMatrixDao.queryForEq("table_name", tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve table tile matrixes: " + tableName, e);
        }
        Contents contents = this.copyUserTable(tableName, newTableName, transferContent);
        tileMatrixSet.setContents(contents);
        try {
            tileMatrixSetDao.create(tileMatrixSet);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create tile matrix set for tile table: " + newTableName, e);
        }
        for (TileMatrix tileMatrix : tileMatrixes) {
            tileMatrix.setContents(contents);
            try {
                tileMatrixDao.create(tileMatrix);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create tile matrix for tile table: " + newTableName, e);
            }
        }
    }

    protected Contents copyUserTable(String tableName, String newTableName, boolean transferContent) {
        return this.copyUserTable(tableName, newTableName, transferContent, true);
    }

    protected Contents copyUserTable(String tableName, String newTableName, boolean transferContent, boolean validateContents) {
        AlterTable.copyTable(this.database, tableName, newTableName, transferContent);
        Contents contents = this.copyContents(tableName, newTableName);
        if (contents == null && validateContents) {
            throw new GeoPackageException("No table contents found for table: " + tableName);
        }
        return contents;
    }

    protected Contents copyContents(String tableName, String newTableName) {
        Contents contents = this.getTableContents(tableName);
        if (contents != null) {
            contents.setTableName(newTableName);
            contents.setIdentifier(newTableName);
            try {
                this.getContentsDao().create(contents);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to create contents for table: " + newTableName + ", copied from table: " + tableName, e);
            }
        }
        return contents;
    }

    @Override
    public void vacuum() {
        CoreSQLUtils.vacuum(this.database);
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return new ExtensionManager(this);
    }

    @Override
    public void createUserTable(UserTable<? extends UserColumn> table) {
        this.verifyWritable();
        this.tableCreator.createTable(table);
    }
}

