/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.metadata;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.metadata.Metadata;
import mil.nga.geopackage.extension.metadata.MetadataDao;
import mil.nga.geopackage.extension.metadata.reference.MetadataReference;
import mil.nga.geopackage.extension.metadata.reference.MetadataReferenceDao;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;

public class MetadataExtension
extends BaseExtension {
    public static final String NAME = "metadata";
    public static final String EXTENSION_NAME = "gpkg_metadata";
    public static final String DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "metadata");

    public MetadataExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    public List<Extensions> getOrCreate() {
        ArrayList<Extensions> extensions = new ArrayList<Extensions>();
        extensions.add(this.getOrCreate(EXTENSION_NAME, EXTENSION_NAME, null, DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkg_metadata_reference", null, DEFINITION, ExtensionScopeType.READ_WRITE));
        return extensions;
    }

    public boolean has() {
        boolean exists = this.has(EXTENSION_NAME);
        return exists;
    }

    public void removeExtension() {
        if (this.geoPackage.isTable("gpkg_metadata_reference")) {
            this.geoPackage.dropTable("gpkg_metadata_reference");
        }
        if (this.geoPackage.isTable(EXTENSION_NAME)) {
            this.geoPackage.dropTable(EXTENSION_NAME);
        }
        try {
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Metadata extension. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public MetadataDao getMetadataDao() {
        return MetadataExtension.getMetadataDao(this.geoPackage);
    }

    public static MetadataDao getMetadataDao(GeoPackageCore geoPackage) {
        return MetadataDao.create(geoPackage);
    }

    public static MetadataDao getMetadataDao(GeoPackageCoreConnection db) {
        return MetadataDao.create(db);
    }

    public boolean createMetadataTable() {
        this.verifyWritable();
        boolean created = false;
        MetadataDao dao = this.getMetadataDao();
        try {
            if (!dao.isTableExists()) {
                boolean bl = created = this.geoPackage.getTableCreator().createMetadata() > 0;
                if (created) {
                    MetadataExtension metadataExtension = new MetadataExtension(this.geoPackage);
                    metadataExtension.getOrCreate();
                }
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + Metadata.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    public MetadataReferenceDao getMetadataReferenceDao() {
        return MetadataExtension.getMetadataReferenceDao(this.geoPackage);
    }

    public static MetadataReferenceDao getMetadataReferenceDao(GeoPackageCore geoPackage) {
        return MetadataReferenceDao.create(geoPackage);
    }

    public static MetadataReferenceDao getMetadataReferenceDao(GeoPackageCoreConnection db) {
        return MetadataReferenceDao.create(db);
    }

    public boolean createMetadataReferenceTable() {
        this.verifyWritable();
        boolean created = false;
        MetadataReferenceDao dao = this.getMetadataReferenceDao();
        try {
            if (!dao.isTableExists()) {
                created = this.geoPackage.getTableCreator().createMetadataReference() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + MetadataReference.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }
}

