/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.schema;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.schema.columns.DataColumns;
import mil.nga.geopackage.extension.schema.columns.DataColumnsDao;
import mil.nga.geopackage.extension.schema.constraints.DataColumnConstraints;
import mil.nga.geopackage.extension.schema.constraints.DataColumnConstraintsDao;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;

public class SchemaExtension
extends BaseExtension {
    public static final String NAME = "schema";
    public static final String EXTENSION_NAME = "gpkg_schema";
    public static final String DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "schema");

    public SchemaExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    public List<Extensions> getOrCreate() {
        ArrayList<Extensions> extensions = new ArrayList<Extensions>();
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkg_data_columns", null, DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkg_data_column_constraints", null, DEFINITION, ExtensionScopeType.READ_WRITE));
        return extensions;
    }

    public boolean has() {
        boolean exists = this.has(EXTENSION_NAME);
        return exists;
    }

    public void removeExtension() {
        if (this.geoPackage.isTable("gpkg_data_columns")) {
            this.geoPackage.dropTable("gpkg_data_columns");
        }
        if (this.geoPackage.isTable("gpkg_data_column_constraints")) {
            this.geoPackage.dropTable("gpkg_data_column_constraints");
        }
        try {
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Schema extension. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public DataColumnsDao getDataColumnsDao() {
        return SchemaExtension.getDataColumnsDao(this.geoPackage);
    }

    public static DataColumnsDao getDataColumnsDao(GeoPackageCore geoPackage) {
        return DataColumnsDao.create(geoPackage);
    }

    public static DataColumnsDao getDataColumnsDao(GeoPackageCoreConnection db) {
        return DataColumnsDao.create(db);
    }

    public boolean createDataColumnsTable() {
        this.verifyWritable();
        boolean created = false;
        DataColumnsDao dao = this.getDataColumnsDao();
        try {
            if (!dao.isTableExists()) {
                created = this.geoPackage.getTableCreator().createDataColumns() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + DataColumns.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    public DataColumnConstraintsDao getDataColumnConstraintsDao() {
        return SchemaExtension.getDataColumnConstraintsDao(this.geoPackage);
    }

    public static DataColumnConstraintsDao getDataColumnConstraintsDao(GeoPackageCore geoPackage) {
        return DataColumnConstraintsDao.create(geoPackage);
    }

    public static DataColumnConstraintsDao getDataColumnConstraintsDao(GeoPackageCoreConnection db) {
        return DataColumnConstraintsDao.create(db);
    }

    public boolean createDataColumnConstraintsTable() {
        this.verifyWritable();
        boolean created = false;
        DataColumnConstraintsDao dao = this.getDataColumnConstraintsDao();
        try {
            if (!dao.isTableExists()) {
                boolean bl = created = this.geoPackage.getTableCreator().createDataColumnConstraints() > 0;
                if (created) {
                    SchemaExtension schemaExtension = new SchemaExtension(this.geoPackage);
                    schemaExtension.getOrCreate();
                }
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + DataColumnConstraints.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }
}

