/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.DateConverter;
import mil.nga.geopackage.features.FeatureCoreGenerator;
import mil.nga.geopackage.io.GeoPackageIOUtils;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;
import mil.nga.oapi.features.json.Collection;
import mil.nga.oapi.features.json.Crs;
import mil.nga.oapi.features.json.FeatureCollection;
import mil.nga.oapi.features.json.FeaturesConverter;
import mil.nga.oapi.features.json.Link;
import mil.nga.sf.geojson.Feature;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionFactory;
import mil.nga.sf.proj.Projections;

public abstract class OAPIFeatureCoreGenerator
extends FeatureCoreGenerator {
    private static final Logger LOGGER = Logger.getLogger(OAPIFeatureCoreGenerator.class.getName());
    protected static final Pattern LIMIT_PATTERN = Pattern.compile("limit=\\d+");
    protected static final Projection OGC_CRS84 = ProjectionFactory.getProjection((String)"OGC", (String)"CRS84");
    protected static final String OGC_VERSION = "1.3";
    protected static final String EPSG_VERSION = "0";
    protected static final Projections DEFAULT_PROJECTIONS = new Projections();
    protected final String server;
    protected final String id;
    protected Integer limit = null;
    protected String time = null;
    protected String period = null;
    protected Integer totalLimit = null;
    protected int downloadAttempts = GeoPackageProperties.getIntegerProperty(PropertyConstants.FEATURE_GENERATOR, "downloadAttempts");

    public OAPIFeatureCoreGenerator(GeoPackageCore geoPackage, String tableName, String server, String id) {
        super(geoPackage, tableName);
        this.server = server;
        this.id = id;
    }

    public String getServer() {
        return this.server;
    }

    public String getId() {
        return this.id;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public void setTime(Date time) {
        if (time != null) {
            DateConverter dateConverter = DateConverter.dateConverter("yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.time = dateConverter.stringValue(time);
        } else {
            this.time = null;
        }
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public void setPeriod(Date period) {
        if (period != null) {
            DateConverter dateConverter = DateConverter.dateConverter("yyyy-MM-dd'T'HH:mm:ss'Z'");
            this.period = dateConverter.stringValue(period);
        } else {
            this.period = null;
        }
    }

    public Integer getTotalLimit() {
        return this.totalLimit;
    }

    public void setTotalLimit(Integer totalLimit) {
        this.totalLimit = totalLimit;
    }

    public int getDownloadAttempts() {
        return this.downloadAttempts;
    }

    public void setDownloadAttempts(int downloadAttempts) {
        this.downloadAttempts = downloadAttempts;
    }

    @Override
    protected Projection getSrsProjection() {
        Projection srsProjection = null;
        srsProjection = OGC_CRS84.equals((Object)this.projection) ? EPSG_WGS84 : super.getSrsProjection();
        return srsProjection;
    }

    protected void createFeature(Feature feature) throws SQLException {
        this.createFeature(feature.getSimpleGeometry(), feature.getProperties());
    }

    @Override
    public int generateFeatures() throws SQLException {
        String url = this.buildCollectionRequestUrl();
        Collection collection = this.collectionRequest(url);
        Projections projections = this.getProjections(collection);
        if (this.projection != null && !projections.hasProjection(this.projection)) {
            LOGGER.log(Level.WARNING, "The projection is not advertised by the server. Authority: " + this.projection.getAuthority() + ", Code: " + this.projection.getCode());
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        urlBuilder.append("/items");
        boolean params = false;
        if (this.time != null) {
            if (params) {
                urlBuilder.append("&");
            } else {
                urlBuilder.append("?");
                params = true;
            }
            urlBuilder.append("time=");
            urlBuilder.append(this.time);
            if (this.period != null) {
                urlBuilder.append("/");
                urlBuilder.append(this.period);
            }
        }
        if (this.boundingBox != null) {
            if (params) {
                urlBuilder.append("&");
            } else {
                urlBuilder.append("?");
                params = true;
            }
            urlBuilder.append("bbox=");
            urlBuilder.append(this.boundingBox.getMinLongitude());
            urlBuilder.append(",");
            urlBuilder.append(this.boundingBox.getMinLatitude());
            urlBuilder.append(",");
            urlBuilder.append(this.boundingBox.getMaxLongitude());
            urlBuilder.append(",");
            urlBuilder.append(this.boundingBox.getMaxLatitude());
            if (this.requestProjection(this.boundingBoxProjection)) {
                urlBuilder.append("&bbox-crs=");
                urlBuilder.append(this.getCrs(this.boundingBoxProjection).toString());
            }
        }
        if (this.requestProjection(this.projection)) {
            if (params) {
                urlBuilder.append("&");
            } else {
                urlBuilder.append("?");
                params = true;
            }
            urlBuilder.append("crs=");
            urlBuilder.append(this.getCrs(this.projection).toString());
        }
        String urlValue = urlBuilder.toString();
        int count = this.generateFeatures(urlValue, 0);
        if (this.progress != null && !this.progress.isActive() && this.progress.cleanupOnCancel()) {
            this.geoPackage.deleteTableQuietly(this.tableName);
            count = 0;
        }
        return count;
    }

    protected String buildCollectionRequestUrl() {
        StringBuilder urlBuilder = new StringBuilder(this.server);
        if (!this.server.endsWith("/")) {
            urlBuilder.append("/");
        }
        urlBuilder.append("collections/");
        urlBuilder.append(this.id);
        return urlBuilder.toString();
    }

    public Projections getProjections() {
        return this.getProjections(this.buildCollectionRequestUrl());
    }

    public Projections getProjections(String url) {
        return this.getProjections(this.collectionRequest(url));
    }

    public Projections getProjections(Collection collection) {
        Projections projections = new Projections();
        if (collection != null) {
            for (String crs : collection.getCrs()) {
                Crs crsValue = new Crs(crs);
                if (!crsValue.isValid()) continue;
                this.addProjection(projections, crsValue.getAuthority(), crsValue.getCode());
            }
        }
        if (projections.isEmpty()) {
            projections = DEFAULT_PROJECTIONS;
        } else if (projections.hasProjection(OGC_CRS84)) {
            projections.addProjection(EPSG_WGS84);
        }
        return projections;
    }

    public boolean requestProjection(Projection projection) {
        return projection != null && !this.isDefaultProjection(projection);
    }

    public boolean isDefaultProjection(Projection projection) {
        return DEFAULT_PROJECTIONS.hasProjection(projection);
    }

    public Collection collectionRequest() {
        return this.collectionRequest(this.buildCollectionRequestUrl());
    }

    protected Collection collectionRequest(String url) {
        Collection collection = null;
        String collectionValue = null;
        try {
            collectionValue = this.urlRequest(url);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to request the collection. url: " + url, e);
        }
        if (collectionValue != null) {
            try {
                collection = FeaturesConverter.toCollection((String)collectionValue);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to translate collection. url: " + url, e);
            }
        }
        return collection;
    }

    public int generateFeatures(String urlString, int currentCount) throws SQLException {
        StringBuilder urlBuilder = new StringBuilder(urlString);
        int paramIndex = urlString.lastIndexOf("?");
        boolean params = paramIndex >= 0 && paramIndex + 1 < urlString.length();
        Integer requestLimit = this.limit;
        if (this.totalLimit != null && this.totalLimit - currentCount < (requestLimit != null ? requestLimit : 10)) {
            requestLimit = this.totalLimit - currentCount;
        }
        if (requestLimit != null) {
            Matcher matcher = LIMIT_PATTERN.matcher(urlBuilder.toString());
            if (matcher.find()) {
                urlBuilder = new StringBuilder(matcher.replaceFirst("limit=" + requestLimit));
            } else {
                if (params) {
                    urlBuilder.append("&");
                } else {
                    urlBuilder.append("?");
                    params = true;
                }
                urlBuilder.append("limit=");
                urlBuilder.append(requestLimit);
            }
        }
        String features = null;
        if (this.isActive()) {
            features = this.urlRequest(urlBuilder.toString());
        }
        if (features != null && this.isActive()) {
            List nextLinks;
            FeatureCollection featureCollection = FeaturesConverter.toFeatureCollection((String)features);
            if (currentCount == 0 && this.progress != null) {
                Integer max = this.totalLimit;
                Integer numberMatched = featureCollection.getNumberMatched();
                if (numberMatched != null) {
                    max = max == null ? numberMatched : Integer.valueOf(Math.min(max, numberMatched));
                }
                if (max != null) {
                    this.progress.setMax(max);
                }
            }
            this.createFeatures(featureCollection);
            Integer numberReturned = featureCollection.getNumberReturned();
            if (numberReturned != null) {
                currentCount += numberReturned.intValue();
            }
            if ((nextLinks = (List)featureCollection.getRelationLinks().get("next")) != null) {
                for (Link nextLink : nextLinks) {
                    if (this.totalLimit != null && this.totalLimit <= currentCount) break;
                    currentCount = this.generateFeatures(nextLink.getHref(), currentCount);
                }
            }
        }
        return currentCount;
    }

    protected String urlRequest(String urlValue) {
        URL url;
        String response = null;
        try {
            url = new URL(urlValue);
        }
        catch (MalformedURLException e) {
            throw new GeoPackageException("Failed request. URL: " + urlValue, e);
        }
        int attempt = 1;
        while (true) {
            try {
                response = this.urlRequest(urlValue, url);
            }
            catch (Exception e) {
                if (attempt < this.downloadAttempts) {
                    LOGGER.log(Level.WARNING, "Failed to download features after attempt " + attempt + " of " + this.downloadAttempts + ". URL: " + urlValue, e);
                    ++attempt;
                    continue;
                }
                throw new GeoPackageException("Failed to download features after " + this.downloadAttempts + " attempts. URL: " + urlValue, e);
            }
            break;
        }
        return response;
    }

    protected String urlRequest(String urlValue, URL url) {
        String response = null;
        HttpURLConnection connection = null;
        try {
            LOGGER.log(Level.INFO, urlValue);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Accept", "application/json,application/geo+json");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 301 || responseCode == 302 || responseCode == 303) {
                String redirect = connection.getHeaderField("Location");
                connection.disconnect();
                url = new URL(redirect);
                connection = (HttpURLConnection)url.openConnection();
                connection.connect();
            }
            if (connection.getResponseCode() != 200) {
                throw new GeoPackageException("Failed request. URL: " + urlValue + ", Response Code: " + connection.getResponseCode() + ", Response Message: " + connection.getResponseMessage());
            }
            InputStream responseStream = connection.getInputStream();
            response = GeoPackageIOUtils.streamString(responseStream);
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed request. URL: " + urlValue, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    protected FeatureCollection createFeatures(String features) throws SQLException {
        FeatureCollection featureCollection = FeaturesConverter.toFeatureCollection((String)features);
        this.createFeatures(featureCollection);
        return featureCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int createFeatures(FeatureCollection featureCollection) {
        int count = 0;
        this.geoPackage.beginTransaction();
        try {
            for (Feature feature : featureCollection.getFeatureCollection().getFeatures()) {
                if (!this.isActive()) {
                    break;
                }
                try {
                    this.createFeature(feature);
                    ++count;
                    if (this.progress != null) {
                        this.progress.addProgress(1);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to create feature: " + feature.getId(), e);
                }
                if (count <= 0 || count % this.transactionLimit != 0) continue;
                this.geoPackage.commit();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to create features", e);
            this.geoPackage.failTransaction();
        }
        finally {
            this.geoPackage.endTransaction();
        }
        Integer numberReturned = featureCollection.getNumberReturned();
        if (numberReturned != null && numberReturned != count) {
            LOGGER.log(Level.WARNING, "Feature Collection number returned does not match number of features created. Number Returned: " + numberReturned + ", Created: " + count);
        }
        featureCollection.setNumberReturned(Integer.valueOf(count));
        return count;
    }

    protected Crs getCrs(Projection projection) {
        String version = null;
        switch (projection.getAuthority()) {
            case "OGC": {
                version = OGC_VERSION;
                break;
            }
            default: {
                version = EPSG_VERSION;
            }
        }
        return new Crs(projection.getAuthority(), version, projection.getCode());
    }

    static {
        DEFAULT_PROJECTIONS.addProjection(OGC_CRS84);
        DEFAULT_PROJECTIONS.addProjection(EPSG_WGS84);
    }
}

