/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.table.ColumnConstraints;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.ConstraintType;
import mil.nga.geopackage.db.table.RawConstraint;
import mil.nga.geopackage.db.table.TableColumn;
import mil.nga.geopackage.user.UserTable;

public abstract class UserColumn
implements Comparable<UserColumn> {
    private static final Logger log = Logger.getLogger(UserColumn.class.getName());
    public static final int NO_INDEX = -1;
    private int index;
    private String name;
    private Long max;
    private boolean notNull;
    private Object defaultValue;
    private boolean primaryKey;
    private boolean autoincrement;
    private String type;
    private GeoPackageDataType dataType;
    private final List<Constraint> constraints = new ArrayList<Constraint>();

    protected UserColumn(int index, String name, GeoPackageDataType dataType, Long max, boolean notNull, Object defaultValue, boolean primaryKey, boolean autoincrement) {
        this(index, name, UserColumn.getTypeName(name, dataType), dataType, max, notNull, defaultValue, primaryKey, autoincrement);
    }

    protected UserColumn(int index, String name, String type, GeoPackageDataType dataType, Long max, boolean notNull, Object defaultValue, boolean primaryKey, boolean autoincrement) {
        this.index = index;
        this.name = name;
        this.max = max;
        this.notNull = notNull;
        this.defaultValue = defaultValue;
        this.primaryKey = primaryKey;
        this.autoincrement = autoincrement;
        this.type = type;
        this.dataType = dataType;
        UserColumn.validateDataType(name, dataType);
        this.validateMax();
        this.addDefaultConstraints();
    }

    protected UserColumn(TableColumn tableColumn) {
        this(tableColumn.getIndex(), tableColumn.getName(), tableColumn.getType(), tableColumn.getDataType(), tableColumn.getMax(), tableColumn.isNotNull() || tableColumn.isPrimarykey(), tableColumn.getDefaultValue(), tableColumn.isPrimarykey(), tableColumn.isPrimarykey() && UserTable.DEFAULT_AUTOINCREMENT);
    }

    protected UserColumn(UserColumn userColumn) {
        this.index = userColumn.index;
        this.name = userColumn.name;
        this.max = userColumn.max;
        this.notNull = userColumn.notNull;
        this.defaultValue = userColumn.defaultValue;
        this.primaryKey = userColumn.primaryKey;
        this.autoincrement = userColumn.autoincrement;
        this.type = userColumn.type;
        this.dataType = userColumn.dataType;
        for (Constraint constraint : userColumn.constraints) {
            this.addConstraint(constraint.copy());
        }
    }

    protected static String getTypeName(String name, GeoPackageDataType dataType) {
        UserColumn.validateDataType(name, dataType);
        return dataType.name();
    }

    protected static void validateDataType(String name, GeoPackageDataType dataType) {
        if (dataType == null) {
            log.log(Level.SEVERE, "Column is missing a data type: " + name);
        }
    }

    public abstract UserColumn copy();

    public boolean hasIndex() {
        return this.index > -1;
    }

    public void setIndex(int index) {
        if (this.hasIndex()) {
            if (index != this.index) {
                throw new GeoPackageException("User Column with a valid index may not be changed. Column Name: " + this.name + ", Index: " + this.index + ", Attempted Index: " + index);
            }
        } else {
            this.index = index;
        }
    }

    public void resetIndex() {
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNamed(String name) {
        return this.name.equals(name);
    }

    public boolean hasMax() {
        return this.max != null;
    }

    public void setMax(Long max) {
        this.max = max;
    }

    public Long getMax() {
        return this.max;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setAutoincrement(boolean autoincrement) {
        this.autoincrement = autoincrement;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setDataType(GeoPackageDataType dataType) {
        this.dataType = dataType;
    }

    public GeoPackageDataType getDataType() {
        return this.dataType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Constraint> clearConstraints() {
        ArrayList<Constraint> constraintsCopy = new ArrayList<Constraint>(this.constraints);
        this.constraints.clear();
        return constraintsCopy;
    }

    public void addDefaultConstraints() {
        if (this.isNotNull()) {
            this.addNotNullConstraint();
        }
        if (this.hasDefaultValue()) {
            this.addDefaultValueConstraint(this.getDefaultValue());
        }
        if (this.isPrimaryKey()) {
            this.addPrimaryKeyConstraint();
        }
        if (this.isAutoincrement()) {
            this.addAutoincrementConstraint();
        }
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraint(String constraint) {
        this.constraints.add(new RawConstraint(constraint));
    }

    public void addConstraints(Collection<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            this.addConstraint(constraint);
        }
    }

    public void addConstraints(ColumnConstraints constraints) {
        this.addConstraints(constraints.getConstraints());
    }

    public void addNotNullConstraint() {
        this.setNotNull(true);
        this.addConstraint("NOT NULL");
    }

    public void addDefaultValueConstraint(Object defaultValue) {
        this.setDefaultValue(defaultValue);
        this.addConstraint("DEFAULT " + CoreSQLUtils.columnDefaultValue(this));
    }

    public void addPrimaryKeyConstraint() {
        this.setPrimaryKey(true);
        this.addConstraint("PRIMARY KEY");
    }

    public void addAutoincrementConstraint() {
        this.setAutoincrement(true);
        this.addConstraint("AUTOINCREMENT");
    }

    public void addUniqueConstraint() {
        this.addConstraint("UNIQUE");
    }

    public String buildConstraintSql(Constraint constraint) {
        String sql = null;
        if (UserTable.DEFAULT_PK_NOT_NULL || !this.isPrimaryKey() || constraint.getType() != ConstraintType.NOT_NULL) {
            sql = constraint.buildSql();
        }
        return sql;
    }

    @Override
    public int compareTo(UserColumn another) {
        return this.index - another.index;
    }

    private void validateMax() {
        if (this.max != null) {
            if (this.dataType == null) {
                log.log(Level.SEVERE, "Column max set on a column without a data type. column: " + this.name + ", max: " + this.max);
            } else if (this.dataType != GeoPackageDataType.TEXT && this.dataType != GeoPackageDataType.BLOB) {
                throw new GeoPackageException("Column max is only supported for " + GeoPackageDataType.TEXT.name() + " and " + GeoPackageDataType.BLOB.name() + " columns. column: " + this.name + ", max: " + this.max + ", type: " + this.dataType.name());
            }
        }
    }
}

