/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.coverage.CoverageDataAlgorithm;
import mil.nga.geopackage.extension.coverage.CoverageDataImage;
import mil.nga.geopackage.extension.coverage.CoverageDataRequest;
import mil.nga.geopackage.extension.coverage.CoverageDataResults;
import mil.nga.geopackage.extension.coverage.CoverageDataSourcePixel;
import mil.nga.geopackage.extension.coverage.GriddedCoverage;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDao;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDataType;
import mil.nga.geopackage.extension.coverage.GriddedCoverageEncodingType;
import mil.nga.geopackage.extension.coverage.GriddedTile;
import mil.nga.geopackage.extension.coverage.GriddedTileDao;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.tiles.user.TileTableMetadata;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionTransform;
import org.locationtech.proj4j.ProjCoordinate;

public abstract class CoverageDataCore<TImage extends CoverageDataImage>
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "gpkg";
    public static final String EXTENSION_NAME_NO_AUTHOR = "2d_gridded_coverage";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("gpkg", "2d_gridded_coverage");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "2d_gridded_coverage");
    public static final String GRIDDED_COVERAGE = "2d-gridded-coverage";
    private final TileMatrixSet tileMatrixSet;
    private GriddedCoverageDao griddedCoverageDao;
    private GriddedTileDao griddedTileDao;
    private GriddedCoverage griddedCoverage;
    protected Integer width;
    protected Integer height;
    protected final Projection requestProjection;
    protected final Projection coverageProjection;
    protected final BoundingBox coverageBoundingBox;
    protected final boolean sameProjection;
    protected boolean zoomIn = true;
    protected boolean zoomOut = true;
    protected boolean zoomInBeforeOut = true;
    protected CoverageDataAlgorithm algorithm = CoverageDataAlgorithm.NEAREST_NEIGHBOR;
    protected GriddedCoverageEncodingType encoding = GriddedCoverageEncodingType.CENTER;

    protected CoverageDataCore(GeoPackageCore geoPackage, TileMatrixSet tileMatrixSet, Integer width, Integer height, Projection requestProjection) {
        super(geoPackage);
        this.tileMatrixSet = tileMatrixSet;
        this.griddedCoverageDao = this.getGriddedCoverageDao();
        this.griddedTileDao = this.getGriddedTileDao();
        this.queryGriddedCoverage();
        this.width = width;
        this.height = height;
        this.requestProjection = requestProjection;
        this.coverageProjection = tileMatrixSet.getProjection();
        this.coverageBoundingBox = tileMatrixSet.getBoundingBox();
        this.sameProjection = requestProjection != null ? requestProjection.getUnit().name.equals(this.coverageProjection.getUnit().name) : true;
    }

    protected CoverageDataCore(GeoPackageCore geoPackage, TileMatrixSet tileMatrixSet) {
        this(geoPackage, tileMatrixSet, null, null, null);
    }

    public abstract Double getValue(GriddedTile var1, TImage var2, int var3, int var4);

    public abstract CoverageDataResults getValues(CoverageDataRequest var1, Integer var2, Integer var3);

    public abstract CoverageDataResults getValuesUnbounded(CoverageDataRequest var1);

    public TileMatrixSet getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Projection getRequestProjection() {
        return this.requestProjection;
    }

    public Projection getCoverageProjection() {
        return this.coverageProjection;
    }

    public BoundingBox getCoverageBoundingBox() {
        return this.coverageBoundingBox;
    }

    public boolean isSameProjection() {
        return this.sameProjection;
    }

    public boolean isZoomIn() {
        return this.zoomIn;
    }

    public void setZoomIn(boolean zoomIn) {
        this.zoomIn = zoomIn;
    }

    public boolean isZoomOut() {
        return this.zoomOut;
    }

    public void setZoomOut(boolean zoomOut) {
        this.zoomOut = zoomOut;
    }

    public boolean isZoomInBeforeOut() {
        return this.zoomInBeforeOut;
    }

    public void setZoomInBeforeOut(boolean zoomInBeforeOut) {
        this.zoomInBeforeOut = zoomInBeforeOut;
    }

    public CoverageDataAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(CoverageDataAlgorithm algorithm) {
        if (algorithm == null) {
            algorithm = CoverageDataAlgorithm.NEAREST_NEIGHBOR;
        }
        this.algorithm = algorithm;
    }

    public GriddedCoverageEncodingType getEncoding() {
        return this.encoding;
    }

    public void setEncoding(GriddedCoverageEncodingType encoding) {
        if (encoding == null) {
            encoding = GriddedCoverageEncodingType.CENTER;
        }
        this.encoding = encoding;
    }

    public List<Extensions> getOrCreate() {
        this.createGriddedCoverageTable();
        this.createGriddedTileTable();
        ArrayList<Extensions> extensionList = new ArrayList<Extensions>();
        Extensions coverage = this.getOrCreate(EXTENSION_NAME, "gpkg_2d_gridded_coverage_ancillary", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        Extensions tile = this.getOrCreate(EXTENSION_NAME, "gpkg_2d_gridded_tile_ancillary", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        Extensions table = this.getOrCreate(EXTENSION_NAME, this.tileMatrixSet.getTableName(), "tile_data", EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        extensionList.add(coverage);
        extensionList.add(tile);
        extensionList.add(table);
        return extensionList;
    }

    public boolean has() {
        boolean exists = this.has(EXTENSION_NAME, this.tileMatrixSet.getTableName(), "tile_data");
        return exists;
    }

    public GriddedCoverageDao getGriddedCoverageDao() {
        if (this.griddedCoverageDao == null) {
            this.griddedCoverageDao = GriddedCoverageDao.create(this.geoPackage);
        }
        return this.griddedCoverageDao;
    }

    public static GriddedCoverageDao getGriddedCoverageDao(GeoPackageCore geoPackage) {
        return GriddedCoverageDao.create(geoPackage);
    }

    public static GriddedCoverageDao getGriddedCoverageDao(GeoPackageCoreConnection db) {
        return GriddedCoverageDao.create(db);
    }

    public boolean createGriddedCoverageTable() {
        this.verifyWritable();
        boolean created = false;
        try {
            if (!this.griddedCoverageDao.isTableExists()) {
                created = this.geoPackage.getTableCreator().createGriddedCoverage() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GriddedCoverage.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    public GriddedTileDao getGriddedTileDao() {
        if (this.griddedTileDao == null) {
            this.griddedTileDao = CoverageDataCore.getGriddedTileDao(this.geoPackage);
        }
        return this.griddedTileDao;
    }

    public static GriddedTileDao getGriddedTileDao(GeoPackageCore geoPackage) {
        return GriddedTileDao.create(geoPackage);
    }

    public static GriddedTileDao getGriddedTileDao(GeoPackageCoreConnection db) {
        return GriddedTileDao.create(db);
    }

    public boolean createGriddedTileTable() {
        this.verifyWritable();
        boolean created = false;
        try {
            if (!this.griddedTileDao.isTableExists()) {
                created = this.geoPackage.getTableCreator().createGriddedTile() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + GriddedTile.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    public GriddedCoverage getGriddedCoverage() {
        return this.griddedCoverage;
    }

    public GriddedCoverage queryGriddedCoverage() {
        try {
            if (this.griddedCoverageDao.isTableExists()) {
                this.griddedCoverage = this.griddedCoverageDao.query(this.tileMatrixSet);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get Gridded Coverage for table name: " + this.tileMatrixSet.getTableName(), e);
        }
        return this.griddedCoverage;
    }

    public List<GriddedTile> getGriddedTile() {
        List<GriddedTile> griddedTile = null;
        try {
            if (this.griddedTileDao.isTableExists()) {
                griddedTile = this.griddedTileDao.query(this.tileMatrixSet.getTableName());
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get Gridded Tile for table name: " + this.tileMatrixSet.getTableName(), e);
        }
        return griddedTile;
    }

    public GriddedTile getGriddedTile(long tileId) {
        GriddedTile griddedTile = null;
        try {
            if (this.griddedTileDao.isTableExists()) {
                griddedTile = this.griddedTileDao.query(this.tileMatrixSet.getTableName(), tileId);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get Gridded Tile for table name: " + this.tileMatrixSet.getTableName() + ", tile id: " + tileId, e);
        }
        return griddedTile;
    }

    public Double getDataNull() {
        Double dataNull = null;
        if (this.griddedCoverage != null) {
            dataNull = this.griddedCoverage.getDataNull();
        }
        return dataNull;
    }

    public boolean isDataNull(double value) {
        Double dataNull = this.getDataNull();
        boolean isDataNull = dataNull != null && dataNull == value;
        return isDataNull;
    }

    public static List<String> getTables(GeoPackageCore geoPackage) {
        return geoPackage.getTables(GRIDDED_COVERAGE);
    }

    protected Double[][] reprojectCoverageData(Double[][] values, int requestedCoverageWidth, int requestedCoverageHeight, BoundingBox requestBoundingBox, ProjectionTransform transformRequestToCoverage, BoundingBox coverageBoundingBox) {
        double requestedWidthUnitsPerPixel = (requestBoundingBox.getMaxLongitude() - requestBoundingBox.getMinLongitude()) / (double)requestedCoverageWidth;
        double requestedHeightUnitsPerPixel = (requestBoundingBox.getMaxLatitude() - requestBoundingBox.getMinLatitude()) / (double)requestedCoverageHeight;
        double tilesDistanceWidth = coverageBoundingBox.getMaxLongitude() - coverageBoundingBox.getMinLongitude();
        double tilesDistanceHeight = coverageBoundingBox.getMaxLatitude() - coverageBoundingBox.getMinLatitude();
        int width = values[0].length;
        int height = values.length;
        Double[][] projectedValues = new Double[requestedCoverageHeight][requestedCoverageWidth];
        for (int y = 0; y < requestedCoverageHeight; ++y) {
            for (int x = 0; x < requestedCoverageWidth; ++x) {
                Double coverageData;
                double longitude = requestBoundingBox.getMinLongitude() + (double)x * requestedWidthUnitsPerPixel;
                double latitude = requestBoundingBox.getMaxLatitude() - (double)y * requestedHeightUnitsPerPixel;
                ProjCoordinate fromCoord = new ProjCoordinate(longitude, latitude);
                ProjCoordinate toCoord = transformRequestToCoverage.transform(fromCoord);
                double projectedLongitude = toCoord.x;
                double projectedLatitude = toCoord.y;
                int xPixel = (int)Math.round((projectedLongitude - coverageBoundingBox.getMinLongitude()) / tilesDistanceWidth * (double)width);
                int yPixel = (int)Math.round((coverageBoundingBox.getMaxLatitude() - projectedLatitude) / tilesDistanceHeight * (double)height);
                xPixel = Math.max(0, xPixel);
                xPixel = Math.min(width - 1, xPixel);
                yPixel = Math.max(0, yPixel);
                yPixel = Math.min(height - 1, yPixel);
                projectedValues[y][x] = coverageData = values[yPixel][xPixel];
            }
        }
        return projectedValues;
    }

    protected Double[][] formatUnboundedResults(TileMatrix tileMatrix, Map<Long, Map<Long, Double[][]>> rowsMap, int tileCount, long minRow, long maxRow, long minColumn, long maxColumn) {
        Double[][] values = null;
        if (!rowsMap.isEmpty()) {
            if (tileCount == 1) {
                values = rowsMap.get(minRow).get(minColumn);
            } else {
                Double[][] topLeft = rowsMap.get(minRow).get(minColumn);
                Double[][] bottomRight = rowsMap.get(maxRow).get(maxColumn);
                int firstWidth = topLeft[0].length;
                int firstHeight = topLeft.length;
                int width = firstWidth;
                int height = firstHeight;
                if (minColumn < maxColumn) {
                    width += bottomRight[0].length;
                    long middleColumns = maxColumn - minColumn - 1L;
                    if (middleColumns > 0L) {
                        width = (int)((long)width + middleColumns * tileMatrix.getTileWidth());
                    }
                }
                if (minRow < maxRow) {
                    height += bottomRight.length;
                    long middleRows = maxRow - minRow - 1L;
                    if (middleRows > 0L) {
                        height = (int)((long)height + middleRows * tileMatrix.getTileHeight());
                    }
                }
                values = new Double[height][width];
                for (Map.Entry<Long, Map<Long, Double[][]>> rows : rowsMap.entrySet()) {
                    long row = rows.getKey();
                    int baseRow = 0;
                    if (minRow < row) {
                        baseRow = firstHeight + (int)((row - minRow - 1L) * tileMatrix.getTileHeight());
                    }
                    Map<Long, Double[][]> columnsMap = rows.getValue();
                    for (Map.Entry<Long, Double[][]> columns : columnsMap.entrySet()) {
                        long column = columns.getKey();
                        int baseColumn = 0;
                        if (minColumn < column) {
                            baseColumn = firstWidth + (int)((column - minColumn - 1L) * tileMatrix.getTileWidth());
                        }
                        Double[][] localValues = columns.getValue();
                        for (int localRow = 0; localRow < localValues.length; ++localRow) {
                            int globalRow = baseRow + localRow;
                            System.arraycopy(localValues[localRow], 0, values[globalRow], baseColumn, localValues[localRow].length);
                        }
                    }
                }
            }
        }
        return values;
    }

    protected float getXSource(int x, float destLeft, float srcLeft, float widthRatio) {
        float dest = this.getXEncodedLocation(x, this.encoding);
        float source = this.getSource(dest, destLeft, srcLeft, widthRatio);
        return source;
    }

    protected float getYSource(int y, float destTop, float srcTop, float heightRatio) {
        float dest = this.getYEncodedLocation(y, this.encoding);
        float source = this.getSource(dest, destTop, srcTop, heightRatio);
        return source;
    }

    private float getSource(float dest, float destMin, float srcMin, float ratio) {
        float destDistance = dest - destMin;
        float srcDistance = destDistance * ratio;
        float ySource = srcMin + srcDistance;
        return ySource;
    }

    private float getXEncodedLocation(float x, GriddedCoverageEncodingType encodingType) {
        float xLocation = x;
        switch (encodingType) {
            case CENTER: 
            case AREA: {
                xLocation += 0.5f;
                break;
            }
            case CORNER: {
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported Encoding Type: " + (Object)((Object)encodingType));
            }
        }
        return xLocation;
    }

    private float getYEncodedLocation(float y, GriddedCoverageEncodingType encodingType) {
        float yLocation = y;
        switch (encodingType) {
            case CENTER: 
            case AREA: {
                yLocation += 0.5f;
                break;
            }
            case CORNER: {
                yLocation += 1.0f;
                break;
            }
            default: {
                throw new GeoPackageException("Unsupported Encoding Type: " + (Object)((Object)encodingType));
            }
        }
        return yLocation;
    }

    protected List<int[]> getNearestNeighbors(float xSource, float ySource) {
        float yDistance;
        int secondY;
        int firstY;
        float xDistance;
        int secondX;
        int firstX;
        ArrayList<int[]> results = new ArrayList<int[]>();
        CoverageDataSourcePixel xPixel = this.getXSourceMinAndMax(xSource);
        CoverageDataSourcePixel yPixel = this.getYSourceMinAndMax(ySource);
        if ((double)xPixel.getOffset() > 0.5) {
            firstX = xPixel.getMax();
            secondX = xPixel.getMin();
            xDistance = 1.0f - xPixel.getOffset();
        } else {
            firstX = xPixel.getMin();
            secondX = xPixel.getMax();
            xDistance = xPixel.getOffset();
        }
        if ((double)yPixel.getOffset() > 0.5) {
            firstY = yPixel.getMax();
            secondY = yPixel.getMin();
            yDistance = 1.0f - yPixel.getOffset();
        } else {
            firstY = yPixel.getMin();
            secondY = yPixel.getMax();
            yDistance = yPixel.getOffset();
        }
        results.add(new int[]{firstX, firstY});
        if (xDistance <= yDistance) {
            results.add(new int[]{secondX, firstY});
            results.add(new int[]{firstX, secondY});
        } else {
            results.add(new int[]{firstX, secondY});
            results.add(new int[]{secondX, firstY});
        }
        results.add(new int[]{secondX, secondY});
        if (xPixel.getOffset() == 0.0f) {
            results.add(new int[]{xPixel.getMin() - 1, yPixel.getMin()});
            results.add(new int[]{xPixel.getMin() - 1, yPixel.getMax()});
        }
        if (yPixel.getOffset() == 0.0f) {
            results.add(new int[]{xPixel.getMin(), yPixel.getMin() - 1});
            results.add(new int[]{xPixel.getMax(), yPixel.getMin() - 1});
        }
        if (xPixel.getOffset() == 0.0f && yPixel.getOffset() == 0.0f) {
            results.add(new int[]{xPixel.getMin() - 1, yPixel.getMin() - 1});
        }
        return results;
    }

    protected CoverageDataSourcePixel getXSourceMinAndMax(float source) {
        int floor = (int)Math.floor(source);
        float valueLocation = this.getXEncodedLocation(floor, this.griddedCoverage.getGridCellEncodingType());
        CoverageDataSourcePixel pixel = this.getSourceMinAndMax(source, floor, valueLocation);
        return pixel;
    }

    protected CoverageDataSourcePixel getYSourceMinAndMax(float source) {
        int floor = (int)Math.floor(source);
        float valueLocation = this.getYEncodedLocation(floor, this.griddedCoverage.getGridCellEncodingType());
        CoverageDataSourcePixel pixel = this.getSourceMinAndMax(source, floor, valueLocation);
        return pixel;
    }

    private CoverageDataSourcePixel getSourceMinAndMax(float source, int sourceFloor, float valueLocation) {
        float offset;
        int min = sourceFloor;
        int max = sourceFloor;
        if (source < valueLocation) {
            --min;
            offset = 1.0f - (valueLocation - source);
        } else {
            ++max;
            offset = source - valueLocation;
        }
        return new CoverageDataSourcePixel(source, min, max, offset);
    }

    protected Double getBilinearInterpolationValue(CoverageDataSourcePixel sourcePixelX, CoverageDataSourcePixel sourcePixelY, Double[][] values) {
        return this.getBilinearInterpolationValue(sourcePixelX.getOffset(), sourcePixelY.getOffset(), sourcePixelX.getMin(), sourcePixelX.getMax(), sourcePixelY.getMin(), sourcePixelY.getMax(), values);
    }

    protected Double getBilinearInterpolationValue(float offsetX, float offsetY, float minX, float maxX, float minY, float maxY, Double[][] values) {
        Double value = null;
        if (values != null) {
            value = this.getBilinearInterpolationValue(offsetX, offsetY, minX, maxX, minY, maxY, values[0][0], values[0][1], values[1][0], values[1][1]);
        }
        return value;
    }

    protected Double getBilinearInterpolationValue(float offsetX, float offsetY, float minX, float maxX, float minY, float maxY, Double topLeft, Double topRight, Double bottomLeft, Double bottomRight) {
        Double value = null;
        if (!(topLeft == null || topRight == null && minX != maxX || bottomLeft == null && minY != maxY || bottomRight == null && (minX != maxX || minY != maxY))) {
            double result;
            Double bottomRow;
            double topRow;
            float diffX = maxX - minX;
            if (diffX == 0.0f) {
                topRow = topLeft;
                bottomRow = bottomLeft;
            } else {
                float diffLeft = offsetX;
                float diffRight = diffX - offsetX;
                topRow = (double)(diffRight / diffX) * topLeft + (double)(diffLeft / diffX) * topRight;
                bottomRow = (double)(diffRight / diffX) * bottomLeft + (double)(diffLeft / diffX) * bottomRight;
            }
            float diffY = maxY - minY;
            if (diffY == 0.0f) {
                result = topRow;
            } else {
                float diffTop = offsetY;
                float diffBottom = diffY - offsetY;
                result = (double)(diffBottom / diffY) * topRow + (double)(diffTop / diffY) * bottomRow;
            }
            value = result;
        }
        return value;
    }

    protected Double getBicubicInterpolationValue(Double[][] values, CoverageDataSourcePixel sourcePixelX, CoverageDataSourcePixel sourcePixelY) {
        return this.getBicubicInterpolationValue(values, sourcePixelX.getOffset(), sourcePixelY.getOffset());
    }

    protected Double getBicubicInterpolationValue(Double[][] values, float offsetX, float offsetY) {
        Double value = null;
        Double[] rowValues = new Double[4];
        for (int y = 0; y < 4; ++y) {
            Double rowValue = this.getCubicInterpolationValue(values[y][0], values[y][1], values[y][2], values[y][3], offsetX);
            if (rowValue == null) {
                rowValues = null;
                break;
            }
            rowValues[y] = rowValue;
        }
        if (rowValues != null) {
            value = this.getCubicInterpolationValue(rowValues, offsetY);
        }
        return value;
    }

    protected Double getCubicInterpolationValue(Double[] values, double offset) {
        Double value = null;
        if (values != null) {
            value = this.getCubicInterpolationValue(values[0], values[1], values[2], values[3], offset);
        }
        return value;
    }

    protected Double getCubicInterpolationValue(Double value0, Double value1, Double value2, Double value3, double offset) {
        Double value = null;
        if (value0 != null && value1 != null && value2 != null && value3 != null) {
            double coefficient0 = 2.0 * value1;
            double coefficient1 = value2 - value0;
            double coefficient2 = 2.0 * value0 - 5.0 * value1 + 4.0 * value2 - value3;
            double coefficient3 = -value0.doubleValue() + 3.0 * value1 - 3.0 * value2 + value3;
            value = (coefficient3 * offset * offset * offset + coefficient2 * offset * offset + coefficient1 * offset + coefficient0) / 2.0;
        }
        return value;
    }

    protected BoundingBox padBoundingBox(TileMatrix tileMatrix, BoundingBox boundingBox, int overlap) {
        double lonPixelPadding = tileMatrix.getPixelXSize() * (double)overlap;
        double latPixelPadding = tileMatrix.getPixelYSize() * (double)overlap;
        BoundingBox paddedBoundingBox = new BoundingBox(boundingBox.getMinLongitude() - lonPixelPadding, boundingBox.getMinLatitude() - latPixelPadding, boundingBox.getMaxLongitude() + lonPixelPadding, boundingBox.getMaxLatitude() + latPixelPadding);
        return paddedBoundingBox;
    }

    public short getPixelValue(short[] pixelValues, int width, int x, int y) {
        return pixelValues[y * width + x];
    }

    public int getUnsignedPixelValue(short[] pixelValues, int width, int x, int y) {
        short pixelValue = this.getPixelValue(pixelValues, width, x, y);
        int unsignedPixelValue = this.getUnsignedPixelValue(pixelValue);
        return unsignedPixelValue;
    }

    public int getUnsignedPixelValue(int[] unsignedPixelValues, int width, int x, int y) {
        return unsignedPixelValues[y * width + x];
    }

    public int getUnsignedPixelValue(short pixelValue) {
        return pixelValue & 0xFFFF;
    }

    public short getPixelValue(int unsignedPixelValue) {
        return (short)unsignedPixelValue;
    }

    public int[] getUnsignedPixelValues(short[] pixelValues) {
        int[] unsignedValues = new int[pixelValues.length];
        for (int i = 0; i < pixelValues.length; ++i) {
            unsignedValues[i] = this.getUnsignedPixelValue(pixelValues[i]);
        }
        return unsignedValues;
    }

    public Double getValue(GriddedTile griddedTile, short pixelValue) {
        int unsignedPixelValue = this.getUnsignedPixelValue(pixelValue);
        Double value = this.getValue(griddedTile, unsignedPixelValue);
        return value;
    }

    public Double getValue(GriddedTile griddedTile, int unsignedPixelValue) {
        Double value = null;
        if (!this.isDataNull(unsignedPixelValue)) {
            value = this.pixelValueToValue(griddedTile, new Double(unsignedPixelValue));
        }
        return value;
    }

    private Double pixelValueToValue(GriddedTile griddedTile, Double pixelValue) {
        Double value = pixelValue;
        if (this.griddedCoverage != null && this.griddedCoverage.getDataType() == GriddedCoverageDataType.INTEGER) {
            if (griddedTile != null) {
                value = value * griddedTile.getScale();
                value = value + griddedTile.getOffset();
            }
            value = value * this.griddedCoverage.getScale();
            value = value + this.griddedCoverage.getOffset();
        }
        return value;
    }

    public Double[] getValues(GriddedTile griddedTile, short[] pixelValues) {
        Double[] values = new Double[pixelValues.length];
        for (int i = 0; i < pixelValues.length; ++i) {
            values[i] = this.getValue(griddedTile, pixelValues[i]);
        }
        return values;
    }

    public Double[] getValues(GriddedTile griddedTile, int[] unsignedPixelValues) {
        Double[] values = new Double[unsignedPixelValues.length];
        for (int i = 0; i < unsignedPixelValues.length; ++i) {
            values[i] = this.getValue(griddedTile, unsignedPixelValues[i]);
        }
        return values;
    }

    public static TileTable createTileTable(GeoPackageCore geoPackage, TileTableMetadata metadata) {
        metadata.setDataType(GRIDDED_COVERAGE);
        return geoPackage.createTileTable(metadata);
    }

    public int getUnsignedPixelValue(GriddedTile griddedTile, Double value) {
        int unsignedPixelValue = 0;
        if (value == null) {
            if (this.griddedCoverage != null) {
                unsignedPixelValue = this.griddedCoverage.getDataNull().intValue();
            }
        } else {
            double pixelValue = this.valueToPixelValue(griddedTile, value);
            unsignedPixelValue = (int)Math.round(pixelValue);
        }
        return unsignedPixelValue;
    }

    private double valueToPixelValue(GriddedTile griddedTile, double value) {
        double pixelValue = value;
        if (this.griddedCoverage != null && this.griddedCoverage.getDataType() == GriddedCoverageDataType.INTEGER) {
            pixelValue -= this.griddedCoverage.getOffset();
            pixelValue /= this.griddedCoverage.getScale();
            if (griddedTile != null) {
                pixelValue -= griddedTile.getOffset();
                pixelValue /= griddedTile.getScale();
            }
        }
        return pixelValue;
    }

    public short getPixelValue(GriddedTile griddedTile, Double value) {
        int unsignedPixelValue = this.getUnsignedPixelValue(griddedTile, value);
        short pixelValue = this.getPixelValue(unsignedPixelValue);
        return pixelValue;
    }

    public float getPixelValue(float[] pixelValues, int width, int x, int y) {
        return pixelValues[y * width + x];
    }

    public Double getValue(GriddedTile griddedTile, float pixelValue) {
        Double value = null;
        if (!this.isDataNull(pixelValue)) {
            value = this.pixelValueToValue(griddedTile, new Double(pixelValue));
        }
        return value;
    }

    public Double[] getValues(GriddedTile griddedTile, float[] pixelValues) {
        Double[] values = new Double[pixelValues.length];
        for (int i = 0; i < pixelValues.length; ++i) {
            values[i] = this.getValue(griddedTile, pixelValues[i]);
        }
        return values;
    }

    public float getFloatPixelValue(GriddedTile griddedTile, Double value) {
        double pixel = 0.0;
        if (value == null) {
            if (this.griddedCoverage != null) {
                pixel = this.griddedCoverage.getDataNull();
            }
        } else {
            pixel = this.valueToPixelValue(griddedTile, value);
        }
        float pixelValue = (float)pixel;
        return pixelValue;
    }

    public Double getValue(double latitude, double longitude) {
        CoverageDataRequest request = new CoverageDataRequest(latitude, longitude);
        CoverageDataResults values = this.getValues(request, (Integer)1, (Integer)1);
        Double value = null;
        if (values != null) {
            value = values.getValues()[0][0];
        }
        return value;
    }

    public CoverageDataResults getValues(BoundingBox requestBoundingBox) {
        CoverageDataRequest request = new CoverageDataRequest(requestBoundingBox);
        CoverageDataResults values = this.getValues(request);
        return values;
    }

    public CoverageDataResults getValues(BoundingBox requestBoundingBox, Integer width, Integer height) {
        CoverageDataRequest request = new CoverageDataRequest(requestBoundingBox);
        CoverageDataResults values = this.getValues(request, width, height);
        return values;
    }

    public CoverageDataResults getValues(CoverageDataRequest request) {
        CoverageDataResults values = this.getValues(request, this.width, this.height);
        return values;
    }

    public CoverageDataResults getValuesUnbounded(BoundingBox requestBoundingBox) {
        CoverageDataRequest request = new CoverageDataRequest(requestBoundingBox);
        return this.getValuesUnbounded(request);
    }

    protected Double getBilinearInterpolationValue(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int y, int x, float widthRatio, float heightRatio, float destTop, float destLeft, float srcTop, float srcLeft) {
        float xSource = this.getXSource(x, destLeft, srcLeft, widthRatio);
        float ySource = this.getYSource(y, destTop, srcTop, heightRatio);
        CoverageDataSourcePixel sourcePixelX = this.getXSourceMinAndMax(xSource);
        CoverageDataSourcePixel sourcePixelY = this.getYSourceMinAndMax(ySource);
        Double[][] values = new Double[2][2];
        this.populateValues(griddedTile, image, leftLastColumns, topLeftRows, topRows, sourcePixelX, sourcePixelY, values);
        Double value = null;
        if (values != null) {
            value = this.getBilinearInterpolationValue(sourcePixelX, sourcePixelY, values);
        }
        return value;
    }

    protected Double getBicubicInterpolationValue(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int y, int x, float widthRatio, float heightRatio, float destTop, float destLeft, float srcTop, float srcLeft) {
        float xSource = this.getXSource(x, destLeft, srcLeft, widthRatio);
        float ySource = this.getYSource(y, destTop, srcTop, heightRatio);
        CoverageDataSourcePixel sourcePixelX = this.getXSourceMinAndMax(xSource);
        sourcePixelX.setMin(sourcePixelX.getMin() - 1);
        sourcePixelX.setMax(sourcePixelX.getMax() + 1);
        CoverageDataSourcePixel sourcePixelY = this.getYSourceMinAndMax(ySource);
        sourcePixelY.setMin(sourcePixelY.getMin() - 1);
        sourcePixelY.setMax(sourcePixelY.getMax() + 1);
        Double[][] values = new Double[4][4];
        this.populateValues(griddedTile, image, leftLastColumns, topLeftRows, topRows, sourcePixelX, sourcePixelY, values);
        Double value = null;
        if (values != null) {
            value = this.getBicubicInterpolationValue(values, sourcePixelX, sourcePixelY);
        }
        return value;
    }

    private void populateValues(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, CoverageDataSourcePixel pixelX, CoverageDataSourcePixel pixelY, Double[][] values) {
        this.populateValues(griddedTile, image, leftLastColumns, topLeftRows, topRows, pixelX.getMin(), pixelX.getMax(), pixelY.getMin(), pixelY.getMax(), values);
    }

    private void populateValues(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int minX, int maxX, int minY, int maxY, Double[][] values) {
        block0: for (int yLocation = maxY; values != null && yLocation >= minY; --yLocation) {
            for (int xLocation = maxX; xLocation >= minX; --xLocation) {
                Double value = this.getValueOverBorders(griddedTile, image, leftLastColumns, topLeftRows, topRows, xLocation, yLocation);
                if (value == null) {
                    values = null;
                    continue block0;
                }
                values[yLocation - minY][xLocation - minX] = value;
            }
        }
    }

    protected Double getNearestNeighborValue(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int y, int x, float widthRatio, float heightRatio, float destTop, float destLeft, float srcTop, float srcLeft) {
        int[] nearestNeighbor;
        float xSource = this.getXSource(x, destLeft, srcLeft, widthRatio);
        float ySource = this.getYSource(y, destTop, srcTop, heightRatio);
        List<int[]> nearestNeighbors = this.getNearestNeighbors(xSource, ySource);
        Double value = null;
        Iterator<int[]> iterator = nearestNeighbors.iterator();
        while (iterator.hasNext() && (value = this.getValueOverBorders(griddedTile, image, leftLastColumns, topLeftRows, topRows, (nearestNeighbor = iterator.next())[0], nearestNeighbor[1])) == null) {
        }
        return value;
    }

    private Double getValueOverBorders(GriddedTile griddedTile, TImage image, Double[][] leftLastColumns, Double[][] topLeftRows, Double[][] topRows, int x, int y) {
        Double value = null;
        if (x < image.getWidth() && y < image.getHeight()) {
            int column;
            int row;
            if (x >= 0 && y >= 0) {
                value = this.getValue(griddedTile, image, x, y);
            } else if (x < 0 && y < 0) {
                int column2;
                int row2;
                if (topLeftRows != null && (row2 = -1 * y - 1) < topLeftRows.length && (column2 = x + topLeftRows[row2].length) >= 0) {
                    value = topLeftRows[row2][column2];
                }
            } else if (x < 0) {
                int row3;
                int column3;
                if (leftLastColumns != null && (column3 = -1 * x - 1) < leftLastColumns.length && (row3 = y) < leftLastColumns[column3].length) {
                    value = leftLastColumns[column3][row3];
                }
            } else if (topRows != null && (row = -1 * y - 1) < topRows.length && (column = x) < topRows[row].length) {
                value = topRows[row][column];
            }
        }
        return value;
    }
}

