/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.TableColumnKey;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.features.user.FeatureColumn;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.features.user.FeatureTableMetadata;
import mil.nga.geopackage.features.user.FeatureTableReader;
import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.geopackage.io.GeoPackageProgress;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.srs.SpatialReferenceSystemDao;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryType;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionFactory;
import mil.nga.sf.proj.Projections;

public abstract class FeatureCoreGenerator {
    private static final Logger LOGGER = Logger.getLogger(FeatureCoreGenerator.class.getName());
    protected static final Projection EPSG_WGS84 = ProjectionFactory.getProjection((long)4326L);
    protected final GeoPackageCore geoPackage;
    protected final String tableName;
    protected BoundingBox boundingBox;
    protected Projection boundingBoxProjection;
    protected Projection projection;
    protected int transactionLimit = 1000;
    protected GeoPackageProgress progress;
    protected GeometryColumns geometryColumns;
    protected Map<String, FeatureColumn> columns = new HashMap<String, FeatureColumn>();
    protected SpatialReferenceSystem srs;

    public FeatureCoreGenerator(GeoPackageCore geoPackage, String tableName) {
        geoPackage.verifyWritable();
        this.geoPackage = geoPackage;
        this.tableName = tableName;
        this.setProjection(null);
    }

    public GeoPackageCore getGeoPackage() {
        return this.geoPackage;
    }

    public String getTableName() {
        return this.tableName;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public Projection getBoundingBoxProjection() {
        return this.boundingBoxProjection;
    }

    public void setBoundingBoxProjection(Projection boundingBoxProjection) {
        this.boundingBoxProjection = boundingBoxProjection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public int getTransactionLimit() {
        return this.transactionLimit;
    }

    public void setTransactionLimit(int transactionLimit) {
        this.transactionLimit = transactionLimit;
    }

    public GeoPackageProgress getProgress() {
        return this.progress;
    }

    public void setProgress(GeoPackageProgress progress) {
        this.progress = progress;
    }

    public boolean isActive() {
        return this.progress == null || this.progress.isActive();
    }

    public GeometryColumns getGeometryColumns() {
        return this.geometryColumns;
    }

    public Map<String, FeatureColumn> getColumns() {
        return this.columns;
    }

    public SpatialReferenceSystem getSrs() {
        return this.srs;
    }

    public abstract int generateFeatures() throws SQLException;

    protected abstract void addColumn(FeatureColumn var1);

    protected void initializeTable() {
    }

    protected abstract void saveFeature(Geometry var1, Map<String, Object> var2);

    protected void createFeature(Geometry geometry, Map<String, Object> properties) throws SQLException {
        if (this.srs == null) {
            this.createSrs();
        }
        if (this.geometryColumns == null) {
            this.createTable(properties);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            String column = property.getKey();
            Object value = this.getValue(column, property.getValue());
            values.put(column, value);
        }
        this.saveFeature(geometry, values);
    }

    public void createSrs() throws SQLException {
        SpatialReferenceSystemDao srsDao = this.geoPackage.getSpatialReferenceSystemDao();
        Projection srsProjection = this.getSrsProjection();
        this.srs = srsDao.getOrCreate(srsProjection);
    }

    protected Projection getSrsProjection() {
        Projection srsProjection = this.projection;
        if (srsProjection == null) {
            srsProjection = EPSG_WGS84;
        }
        return srsProjection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTable(Map<String, Object> properties) throws SQLException {
        boolean inTransaction;
        GeometryColumnsDao geometryColumnsDao = this.geoPackage.getGeometryColumnsDao();
        if (geometryColumnsDao.isTableExists()) {
            this.geometryColumns = geometryColumnsDao.queryForTableName(this.tableName);
        }
        if (inTransaction = this.geoPackage.inTransaction()) {
            this.geoPackage.endTransaction();
        }
        try {
            if (this.geometryColumns == null) {
                ArrayList<FeatureColumn> featureColumns = new ArrayList<FeatureColumn>();
                for (Map.Entry<String, Object> property : properties.entrySet()) {
                    String column = property.getKey();
                    FeatureColumn featureColumn = this.createColumn(column, property.getValue());
                    featureColumns.add(featureColumn);
                    this.columns.put(column, featureColumn);
                }
                this.geometryColumns = new GeometryColumns();
                this.geometryColumns.setId(new TableColumnKey(this.tableName, "geometry"));
                this.geometryColumns.setGeometryType(GeometryType.GEOMETRY);
                this.geometryColumns.setZ((byte)0);
                this.geometryColumns.setM((byte)0);
                this.geometryColumns.setSrs(this.srs);
                this.geoPackage.createFeatureTable(FeatureTableMetadata.create(this.geometryColumns, this.tableName + "_id", featureColumns, this.boundingBox));
            } else {
                FeatureTableReader tableReader = new FeatureTableReader(this.geometryColumns);
                FeatureTable featureTable = (FeatureTable)tableReader.readTable(this.geoPackage.getDatabase());
                for (FeatureColumn featureColumn : featureTable.getColumns()) {
                    this.columns.put(featureColumn.getName(), featureColumn);
                }
            }
            this.initializeTable();
        }
        finally {
            if (inTransaction) {
                this.geoPackage.beginTransaction();
            }
        }
    }

    protected Object getValue(String column, Object value) {
        FeatureColumn featureColumn = this.getColumn(column, value);
        Object columnValue = FeatureCoreGenerator.getValue(value, featureColumn.getDataType());
        return columnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureColumn getColumn(String column, Object value) {
        FeatureColumn featureColumn = this.columns.get(column);
        if (featureColumn == null) {
            boolean inTransaction = this.geoPackage.inTransaction();
            if (inTransaction) {
                this.geoPackage.endTransaction();
            }
            try {
                featureColumn = this.createColumn(column, value);
                this.addColumn(featureColumn);
                this.columns.put(column, featureColumn);
            }
            finally {
                if (inTransaction) {
                    this.geoPackage.beginTransaction();
                }
            }
        }
        return featureColumn;
    }

    protected FeatureColumn createColumn(String name, Object value) {
        GeoPackageDataType type = FeatureCoreGenerator.getType(value);
        return FeatureColumn.createColumn(name, type);
    }

    protected GeoPackageGeometryData createGeometryData(Geometry geometry) {
        return GeoPackageGeometryData.create(this.srs.getSrsId(), geometry);
    }

    public static GeoPackageDataType getType(Object value) {
        GeoPackageDataType type = null;
        if (value instanceof String) {
            type = GeoPackageDataType.TEXT;
        } else if (value instanceof Boolean) {
            type = GeoPackageDataType.BOOLEAN;
        } else if (value instanceof Byte) {
            type = GeoPackageDataType.TINYINT;
        } else if (value instanceof Short) {
            type = GeoPackageDataType.SMALLINT;
        } else if (value instanceof Integer) {
            type = GeoPackageDataType.MEDIUMINT;
        } else if (value instanceof Long) {
            type = GeoPackageDataType.INT;
        } else if (value instanceof Float) {
            type = GeoPackageDataType.FLOAT;
        } else if (value instanceof Double) {
            type = GeoPackageDataType.DOUBLE;
        } else if (value instanceof byte[]) {
            type = GeoPackageDataType.BLOB;
        }
        if (type == null) {
            type = GeoPackageDataType.TEXT;
        }
        return type;
    }

    public static Object getValue(Object value, GeoPackageDataType type) {
        if (value != null && type != null) {
            switch (type) {
                case TEXT: 
                case DATE: 
                case DATETIME: {
                    value = value.toString();
                    break;
                }
                case BOOLEAN: {
                    value = (Boolean)value;
                    break;
                }
                case TINYINT: {
                    value = (Byte)value;
                    break;
                }
                case SMALLINT: {
                    value = (Short)value;
                    break;
                }
                case MEDIUMINT: {
                    value = (Integer)value;
                    break;
                }
                case INT: 
                case INTEGER: {
                    value = (Long)value;
                    break;
                }
                case FLOAT: {
                    value = (Float)value;
                    break;
                }
                case DOUBLE: 
                case REAL: {
                    value = (Double)value;
                    break;
                }
                case BLOB: {
                    value = (byte[])value;
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported Data Type " + (Object)((Object)type));
                }
            }
        }
        return value;
    }

    protected void addProjection(Projections projections, String authority, String code) {
        Projection projection = this.createProjection(authority, code);
        if (projection != null) {
            projections.addProjection(projection);
        }
    }

    protected Projection createProjection(String authority, String code) {
        Projection projection = null;
        try {
            projection = ProjectionFactory.getProjection((String)authority, (String)code);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to create projection. Authority: " + authority + ", Code: " + code);
        }
        return projection;
    }
}

