/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.srs;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.ForeignCollection;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDao;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSetDao;
import mil.nga.sf.proj.Projection;

public class SpatialReferenceSystemDao
extends GeoPackageDao<SpatialReferenceSystem, Long> {
    private ContentsDao contentsDao;
    private GeometryColumnsDao geometryColumnsDao;
    private TileMatrixSetDao tileMatrixSetDao;
    private CrsWktExtension crsWktExtension;

    public static SpatialReferenceSystemDao create(GeoPackageCore geoPackage) {
        return SpatialReferenceSystemDao.create(geoPackage.getDatabase());
    }

    public static SpatialReferenceSystemDao create(GeoPackageCoreConnection db) {
        return (SpatialReferenceSystemDao)((Object)GeoPackageDao.createDao(db, SpatialReferenceSystem.class));
    }

    public SpatialReferenceSystemDao(ConnectionSource connectionSource, Class<SpatialReferenceSystem> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public void setCrsWktExtension(CrsWktExtension crsWktExtension) {
        this.crsWktExtension = crsWktExtension;
    }

    public boolean hasDefinition_12_063() {
        return this.crsWktExtension != null && this.crsWktExtension.has();
    }

    public SpatialReferenceSystem createWgs84() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty(PropertyConstants.WGS_84, "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty(PropertyConstants.WGS_84, "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty(PropertyConstants.WGS_84, "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty(PropertyConstants.WGS_84, "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty(PropertyConstants.WGS_84, "definition"));
        srs.setDescription(GeoPackageProperties.getProperty(PropertyConstants.WGS_84, "description"));
        this.create(srs);
        if (this.hasDefinition_12_063()) {
            srs.setDefinition_12_063(GeoPackageProperties.getProperty(PropertyConstants.WGS_84, "definition_12_063"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_063());
        }
        return srs;
    }

    public SpatialReferenceSystem createUndefinedCartesian() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_CARTESIAN, "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_CARTESIAN, "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_CARTESIAN, "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_CARTESIAN, "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_CARTESIAN, "definition"));
        srs.setDescription(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_CARTESIAN, "description"));
        this.create(srs);
        if (this.hasDefinition_12_063()) {
            srs.setDefinition_12_063(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_CARTESIAN, "definition_12_063"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_063());
        }
        return srs;
    }

    public SpatialReferenceSystem createUndefinedGeographic() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "definition"));
        srs.setDescription(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "description"));
        this.create(srs);
        if (this.hasDefinition_12_063()) {
            srs.setDefinition_12_063(GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "definition_12_063"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_063());
        }
        return srs;
    }

    public SpatialReferenceSystem createWebMercator() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty(PropertyConstants.WEB_MERCATOR, "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty(PropertyConstants.WEB_MERCATOR, "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty(PropertyConstants.WEB_MERCATOR, "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty(PropertyConstants.WEB_MERCATOR, "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty(PropertyConstants.WEB_MERCATOR, "definition"));
        srs.setDescription(GeoPackageProperties.getProperty(PropertyConstants.WEB_MERCATOR, "description"));
        this.create(srs);
        if (this.hasDefinition_12_063()) {
            srs.setDefinition_12_063(GeoPackageProperties.getProperty(PropertyConstants.WEB_MERCATOR, "definition_12_063"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_063());
        }
        return srs;
    }

    public SpatialReferenceSystem createWgs84Geographical3D() throws SQLException {
        SpatialReferenceSystem srs = new SpatialReferenceSystem();
        srs.setSrsName(GeoPackageProperties.getProperty(PropertyConstants.WGS_84_3D, "srs_name"));
        srs.setSrsId(GeoPackageProperties.getIntegerProperty(PropertyConstants.WGS_84_3D, "srs_id"));
        srs.setOrganization(GeoPackageProperties.getProperty(PropertyConstants.WGS_84_3D, "organization"));
        srs.setOrganizationCoordsysId(GeoPackageProperties.getIntegerProperty(PropertyConstants.WGS_84_3D, "organization_coordsys_id"));
        srs.setDefinition(GeoPackageProperties.getProperty(PropertyConstants.WGS_84_3D, "definition"));
        srs.setDescription(GeoPackageProperties.getProperty(PropertyConstants.WGS_84_3D, "description"));
        this.create(srs);
        if (this.hasDefinition_12_063()) {
            srs.setDefinition_12_063(GeoPackageProperties.getProperty(PropertyConstants.WGS_84_3D, "definition_12_063"));
            this.crsWktExtension.updateDefinition(srs.getSrsId(), srs.getDefinition_12_063());
        }
        return srs;
    }

    public String getDefinition_12_063(long srsId) {
        String definition = null;
        if (this.hasDefinition_12_063()) {
            definition = this.crsWktExtension.getDefinition(srsId);
        }
        return definition;
    }

    public void setDefinition_12_063(SpatialReferenceSystem srs) {
        String definition;
        if (srs != null && (definition = this.getDefinition_12_063(srs.getSrsId())) != null) {
            srs.setDefinition_12_063(definition);
        }
    }

    public void setDefinition_12_063(Collection<SpatialReferenceSystem> srsList) {
        for (SpatialReferenceSystem srs : srsList) {
            this.setDefinition_12_063(srs);
        }
    }

    public void updateDefinition_12_063(long srsId, String definition) {
        if (this.hasDefinition_12_063()) {
            this.crsWktExtension.updateDefinition(srsId, definition);
        }
    }

    public void updateDefinition_12_063(SpatialReferenceSystem srs) {
        String definition;
        if (srs != null && (definition = srs.getDefinition_12_063()) != null) {
            this.updateDefinition_12_063(srs.getSrsId(), definition);
        }
    }

    public SpatialReferenceSystem queryForId(Long id) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.queryForId((Object)id);
        this.setDefinition_12_063(srs);
        return srs;
    }

    public SpatialReferenceSystem queryForFirst(PreparedQuery<SpatialReferenceSystem> preparedQuery) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.queryForFirst(preparedQuery);
        this.setDefinition_12_063(srs);
        return srs;
    }

    public List<SpatialReferenceSystem> queryForAll() throws SQLException {
        List srsList = super.queryForAll();
        this.setDefinition_12_063(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForEq(String fieldName, Object value) throws SQLException {
        List srsList = super.queryForEq(fieldName, value);
        this.setDefinition_12_063(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> query(PreparedQuery<SpatialReferenceSystem> preparedQuery) throws SQLException {
        List srsList = super.query(preparedQuery);
        this.setDefinition_12_063(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForMatching(SpatialReferenceSystem matchObj) throws SQLException {
        List srsList = super.queryForMatching((Object)matchObj);
        this.setDefinition_12_063(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForMatchingArgs(SpatialReferenceSystem matchObj) throws SQLException {
        List srsList = super.queryForMatchingArgs((Object)matchObj);
        this.setDefinition_12_063(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForFieldValues(Map<String, Object> fieldValues) throws SQLException {
        List srsList = super.queryForFieldValues(fieldValues);
        this.setDefinition_12_063(srsList);
        return srsList;
    }

    public List<SpatialReferenceSystem> queryForFieldValuesArgs(Map<String, Object> fieldValues) throws SQLException {
        List srsList = super.queryForFieldValuesArgs(fieldValues);
        this.setDefinition_12_063(srsList);
        return srsList;
    }

    public SpatialReferenceSystem queryForSameId(SpatialReferenceSystem data) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.queryForSameId((Object)data);
        this.setDefinition_12_063(srs);
        return srs;
    }

    public int create(SpatialReferenceSystem srs) throws SQLException {
        int result = super.create((Object)srs);
        this.updateDefinition_12_063(srs);
        return result;
    }

    public SpatialReferenceSystem createIfNotExists(SpatialReferenceSystem data) throws SQLException {
        SpatialReferenceSystem srs = (SpatialReferenceSystem)super.createIfNotExists((Object)data);
        this.updateDefinition_12_063(srs);
        return srs;
    }

    public Dao.CreateOrUpdateStatus createOrUpdate(SpatialReferenceSystem data) throws SQLException {
        Dao.CreateOrUpdateStatus status = super.createOrUpdate((Object)data);
        this.updateDefinition_12_063(data);
        return status;
    }

    public int update(SpatialReferenceSystem data) throws SQLException {
        int result = super.update((Object)data);
        this.updateDefinition_12_063(data);
        return result;
    }

    public SpatialReferenceSystem getOrCreateFromEpsg(long epsg) throws SQLException {
        return this.getOrCreateCode("EPSG", epsg);
    }

    public SpatialReferenceSystem getOrCreateCode(String organization, long coordsysId) throws SQLException {
        SpatialReferenceSystem srs = this.queryForOrganizationCoordsysId(organization, coordsysId);
        srs = this.createIfNeeded(srs, organization, coordsysId);
        return srs;
    }

    public SpatialReferenceSystem getOrCreate(Projection projection) throws SQLException {
        return this.getOrCreateCode(projection.getAuthority(), Long.parseLong(projection.getCode()));
    }

    public SpatialReferenceSystem queryForOrganizationCoordsysId(String organization, long organizationCoordsysId) throws SQLException {
        SpatialReferenceSystem srs = null;
        QueryBuilder qb = this.queryBuilder();
        qb.where().like("organization", (Object)organization);
        qb.where().eq("organization_coordsys_id", (Object)organizationCoordsysId);
        PreparedQuery preparedQuery = qb.prepare();
        List<SpatialReferenceSystem> results = this.query((PreparedQuery<SpatialReferenceSystem>)preparedQuery);
        if (!results.isEmpty()) {
            if (results.size() > 1) {
                throw new SQLException("More than one " + SpatialReferenceSystem.class.getSimpleName() + " returned for Organization: " + organization + ", Organization Coordsys Id: " + organizationCoordsysId);
            }
            srs = results.get(0);
        }
        return srs;
    }

    public SpatialReferenceSystem query(Projection projection) throws SQLException {
        return this.queryForOrganizationCoordsysId(projection.getAuthority(), Long.parseLong(projection.getCode()));
    }

    private SpatialReferenceSystem createIfNeeded(SpatialReferenceSystem srs, String organization, long id) throws SQLException {
        block11: {
            block9: {
                block12: {
                    block10: {
                        if (srs != null) break block9;
                        if (!organization.equalsIgnoreCase("EPSG")) break block10;
                        switch ((int)id) {
                            case 4326: {
                                srs = this.createWgs84();
                                break block11;
                            }
                            case 3857: {
                                srs = this.createWebMercator();
                                break block11;
                            }
                            case 4979: {
                                srs = this.createWgs84Geographical3D();
                                break block11;
                            }
                            default: {
                                throw new GeoPackageException("Spatial Reference System not supported for metadata creation. Organization: " + organization + ", id: " + id);
                            }
                        }
                    }
                    if (!organization.equalsIgnoreCase("NONE")) break block12;
                    switch ((int)id) {
                        case -1: {
                            srs = this.createUndefinedCartesian();
                            break block11;
                        }
                        case 0: {
                            srs = this.createUndefinedGeographic();
                            break block11;
                        }
                        default: {
                            throw new GeoPackageException("Spatial Reference System not supported for metadata creation. Organization: " + organization + ", id: " + id);
                        }
                    }
                }
                throw new GeoPackageException("Spatial Reference System not supported for metadata creation. Organization: " + organization + ", id: " + id);
            }
            this.setDefinition_12_063(srs);
        }
        return srs;
    }

    public int deleteCascade(SpatialReferenceSystem srs) throws SQLException {
        int count = 0;
        if (srs != null) {
            ForeignCollection<TileMatrixSet> tileMatrixSetCollection;
            TileMatrixSetDao tileMatrixSetDao;
            ForeignCollection<GeometryColumns> geometryColumnsCollection;
            GeometryColumnsDao geometryColumnsDao;
            ForeignCollection<Contents> contentsCollection = srs.getContents();
            if (!contentsCollection.isEmpty()) {
                ContentsDao dao = this.getContentsDao();
                dao.deleteCascade((Collection<Contents>)contentsCollection);
            }
            if ((geometryColumnsDao = this.getGeometryColumnsDao()).isTableExists() && !(geometryColumnsCollection = srs.getGeometryColumns()).isEmpty()) {
                geometryColumnsDao.delete((Collection)geometryColumnsCollection);
            }
            if ((tileMatrixSetDao = this.getTileMatrixSetDao()).isTableExists() && !(tileMatrixSetCollection = srs.getTileMatrixSet()).isEmpty()) {
                tileMatrixSetDao.delete((Collection)tileMatrixSetCollection);
            }
            count = this.delete(srs);
        }
        return count;
    }

    public int deleteCascade(Collection<SpatialReferenceSystem> srsCollection) throws SQLException {
        int count = 0;
        if (srsCollection != null) {
            for (SpatialReferenceSystem srs : srsCollection) {
                count += this.deleteCascade(srs);
            }
        }
        return count;
    }

    public int deleteCascade(PreparedQuery<SpatialReferenceSystem> preparedDelete) throws SQLException {
        int count = 0;
        if (preparedDelete != null) {
            List<SpatialReferenceSystem> srsList = this.query(preparedDelete);
            count = this.deleteCascade(srsList);
        }
        return count;
    }

    public int deleteByIdCascade(Long id) throws SQLException {
        SpatialReferenceSystem srs;
        int count = 0;
        if (id != null && (srs = this.queryForId(id)) != null) {
            count = this.deleteCascade(srs);
        }
        return count;
    }

    public int deleteIdsCascade(Collection<Long> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (Long id : idCollection) {
                count += this.deleteByIdCascade(id);
            }
        }
        return count;
    }

    private ContentsDao getContentsDao() {
        if (this.contentsDao == null) {
            this.contentsDao = ContentsDao.create(this.db);
        }
        return this.contentsDao;
    }

    private GeometryColumnsDao getGeometryColumnsDao() {
        if (this.geometryColumnsDao == null) {
            this.geometryColumnsDao = GeometryColumnsDao.create(this.db);
        }
        return this.geometryColumnsDao;
    }

    private TileMatrixSetDao getTileMatrixSetDao() {
        if (this.tileMatrixSetDao == null) {
            this.tileMatrixSetDao = TileMatrixSetDao.create(this.db);
        }
        return this.tileMatrixSetDao;
    }
}

