/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.sf.Point;
import mil.nga.sf.proj.Projection;
import mil.nga.sf.proj.ProjectionConstants;
import mil.nga.sf.proj.ProjectionFactory;
import mil.nga.sf.proj.ProjectionTransform;

public class TileBoundingBoxUtils {
    private static Projection webMercator = ProjectionFactory.getProjection((long)3857L);

    public static BoundingBox overlap(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return boundingBox.overlap(boundingBox2);
    }

    public static BoundingBox overlap(BoundingBox boundingBox, BoundingBox boundingBox2, boolean allowEmpty) {
        return boundingBox.overlap(boundingBox2, allowEmpty);
    }

    public static BoundingBox overlap(BoundingBox boundingBox, BoundingBox boundingBox2, double maxLongitude) {
        return TileBoundingBoxUtils.overlap(boundingBox, boundingBox2, maxLongitude, false);
    }

    public static BoundingBox overlap(BoundingBox boundingBox, BoundingBox boundingBox2, double maxLongitude, boolean allowEmpty) {
        BoundingBox bbox2 = boundingBox2;
        double adjustment = 0.0;
        if (maxLongitude > 0.0) {
            if (boundingBox.getMinLongitude() > boundingBox2.getMaxLongitude()) {
                adjustment = maxLongitude * 2.0;
            } else if (boundingBox.getMaxLongitude() < boundingBox2.getMinLongitude()) {
                adjustment = maxLongitude * -2.0;
            }
        }
        if (adjustment != 0.0) {
            bbox2 = new BoundingBox(boundingBox2);
            bbox2.setMinLongitude(bbox2.getMinLongitude() + adjustment);
            bbox2.setMaxLongitude(bbox2.getMaxLongitude() + adjustment);
        }
        return TileBoundingBoxUtils.overlap(boundingBox, bbox2, allowEmpty);
    }

    public static boolean isPointInBoundingBox(Point point, BoundingBox boundingBox) {
        BoundingBox pointBoundingbox = new BoundingBox(point.getX(), point.getY(), point.getX(), point.getY());
        return boundingBox.intersects(pointBoundingbox, true);
    }

    public static boolean isPointInBoundingBox(Point point, BoundingBox boundingBox, double maxLongitude) {
        BoundingBox pointBoundingbox = new BoundingBox(point.getX(), point.getY(), point.getX(), point.getY());
        BoundingBox overlap = TileBoundingBoxUtils.overlap(boundingBox, pointBoundingbox, maxLongitude, true);
        return overlap != null;
    }

    public static BoundingBox union(BoundingBox boundingBox, BoundingBox boundingBox2) {
        return boundingBox.union(boundingBox2);
    }

    public static float getXPixel(long width, BoundingBox boundingBox, double longitude) {
        double boxWidth = boundingBox.getMaxLongitude() - boundingBox.getMinLongitude();
        double offset = longitude - boundingBox.getMinLongitude();
        double percentage = offset / boxWidth;
        float pixel = (float)(percentage * (double)width);
        return pixel;
    }

    public static double getLongitudeFromPixel(long width, BoundingBox boundingBox, float pixel) {
        return TileBoundingBoxUtils.getLongitudeFromPixel(width, boundingBox, boundingBox, pixel);
    }

    public static double getLongitudeFromPixel(long width, BoundingBox boundingBox, BoundingBox tileBoundingBox, float pixel) {
        double boxWidth = tileBoundingBox.getMaxLongitude() - tileBoundingBox.getMinLongitude();
        double percentage = pixel / (float)width;
        double offset = percentage * boxWidth;
        double longitude = offset + boundingBox.getMinLongitude();
        return longitude;
    }

    public static float getYPixel(long height, BoundingBox boundingBox, double latitude) {
        double boxHeight = boundingBox.getMaxLatitude() - boundingBox.getMinLatitude();
        double offset = boundingBox.getMaxLatitude() - latitude;
        double percentage = offset / boxHeight;
        float pixel = (float)(percentage * (double)height);
        return pixel;
    }

    public static double getLatitudeFromPixel(long height, BoundingBox boundingBox, float pixel) {
        return TileBoundingBoxUtils.getLatitudeFromPixel(height, boundingBox, boundingBox, pixel);
    }

    public static double getLatitudeFromPixel(long height, BoundingBox boundingBox, BoundingBox tileBoundingBox, float pixel) {
        double boxHeight = tileBoundingBox.getMaxLatitude() - tileBoundingBox.getMinLatitude();
        double percentage = pixel / (float)height;
        double offset = percentage * boxHeight;
        double latitude = boundingBox.getMaxLatitude() - offset;
        return latitude;
    }

    public static BoundingBox getBoundingBox(int x, int y, long zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileWidthDegrees = TileBoundingBoxUtils.tileWidthDegrees(tilesPerSide);
        double tileHeightDegrees = TileBoundingBoxUtils.tileHeightDegrees(tilesPerSide);
        double minLon = -180.0 + (double)x * tileWidthDegrees;
        double maxLon = minLon + tileWidthDegrees;
        double maxLat = 90.0 - (double)y * tileHeightDegrees;
        double minLat = maxLat - tileHeightDegrees;
        BoundingBox box = new BoundingBox(minLon, minLat, maxLon, maxLat);
        return box;
    }

    public static BoundingBox getWebMercatorBoundingBox(long x, long y, long zoom) {
        double tileSize = TileBoundingBoxUtils.tileSizeWithZoom(zoom);
        double minLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)x * tileSize;
        double maxLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)(x + 1L) * tileSize;
        double minLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)(y + 1L) * tileSize;
        double maxLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)y * tileSize;
        BoundingBox box = new BoundingBox(minLon, minLat, maxLon, maxLat);
        return box;
    }

    public static BoundingBox getWebMercatorBoundingBox(TileGrid tileGrid, long zoom) {
        double tileSize = TileBoundingBoxUtils.tileSizeWithZoom(zoom);
        double minLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)tileGrid.getMinX() * tileSize;
        double maxLon = -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH + (double)(tileGrid.getMaxX() + 1L) * tileSize;
        double minLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)(tileGrid.getMaxY() + 1L) * tileSize;
        double maxLat = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH - (double)tileGrid.getMinY() * tileSize;
        BoundingBox box = new BoundingBox(minLon, minLat, maxLon, maxLat);
        return box;
    }

    public static BoundingBox getProjectedBoundingBox(Long projectionEpsg, int x, int y, long zoom) {
        return TileBoundingBoxUtils.getProjectedBoundingBox("EPSG", projectionEpsg, x, y, zoom);
    }

    public static BoundingBox getProjectedBoundingBox(String authority, Long code, int x, int y, long zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(x, y, zoom);
        if (code != null) {
            ProjectionTransform transform = webMercator.getTransformation(authority, code.longValue());
            boundingBox = boundingBox.transform(transform);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Projection projection, long x, long y, long zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(x, y, zoom);
        if (projection != null) {
            ProjectionTransform transform = webMercator.getTransformation(projection);
            boundingBox = boundingBox.transform(transform);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Long projectionEpsg, TileGrid tileGrid, long zoom) {
        return TileBoundingBoxUtils.getProjectedBoundingBox("EPSG", projectionEpsg, tileGrid, zoom);
    }

    public static BoundingBox getProjectedBoundingBox(String authority, Long code, TileGrid tileGrid, long zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(tileGrid, zoom);
        if (code != null) {
            ProjectionTransform transform = webMercator.getTransformation(authority, code.longValue());
            boundingBox = boundingBox.transform(transform);
        }
        return boundingBox;
    }

    public static BoundingBox getProjectedBoundingBox(Projection projection, TileGrid tileGrid, long zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox(tileGrid, zoom);
        if (projection != null) {
            ProjectionTransform transform = webMercator.getTransformation(projection);
            boundingBox = boundingBox.transform(transform);
        }
        return boundingBox;
    }

    public static TileGrid getTileGridFromWGS84(Point point, long zoom) {
        Projection projection = ProjectionFactory.getProjection((long)4326L);
        return TileBoundingBoxUtils.getTileGrid(point, zoom, projection);
    }

    public static TileGrid getTileGrid(Point point, long zoom, Projection projection) {
        ProjectionTransform toWebMercator = projection.getTransformation(3857L);
        Point webMercatorPoint = toWebMercator.transform(point);
        BoundingBox boundingBox = new BoundingBox(webMercatorPoint.getX(), webMercatorPoint.getY(), webMercatorPoint.getX(), webMercatorPoint.getY());
        return TileBoundingBoxUtils.getTileGrid(boundingBox, zoom);
    }

    public static TileGrid getTileGrid(BoundingBox webMercatorBoundingBox, long zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        int minX = (int)((webMercatorBoundingBox.getMinLongitude() + ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) / tileSize);
        double tempMaxX = (webMercatorBoundingBox.getMaxLongitude() + ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) / tileSize;
        int maxX = (int)(tempMaxX - ProjectionConstants.WEB_MERCATOR_PRECISION);
        maxX = Math.min(maxX, tilesPerSide - 1);
        int minY = (int)((webMercatorBoundingBox.getMaxLatitude() - ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) * -1.0 / tileSize);
        double tempMaxY = (webMercatorBoundingBox.getMinLatitude() - ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH) * -1.0 / tileSize;
        int maxY = (int)(tempMaxY - ProjectionConstants.WEB_MERCATOR_PRECISION);
        maxY = Math.min(maxY, tilesPerSide - 1);
        TileGrid grid = new TileGrid(minX, minY, maxX, maxY);
        return grid;
    }

    public static BoundingBox toWebMercator(BoundingBox boundingBox) {
        double minLatitude = Math.max(boundingBox.getMinLatitude(), -85.05112877980659);
        double maxLatitude = Math.min(boundingBox.getMaxLatitude(), 85.0511287798066);
        Point lowerLeftPoint = new Point(false, false, boundingBox.getMinLongitude(), minLatitude);
        Point upperRightPoint = new Point(false, false, boundingBox.getMaxLongitude(), maxLatitude);
        ProjectionTransform toWebMercator = ProjectionFactory.getProjection((long)4326L).getTransformation(3857L);
        lowerLeftPoint = toWebMercator.transform(lowerLeftPoint);
        upperRightPoint = toWebMercator.transform(upperRightPoint);
        BoundingBox mercatorBox = new BoundingBox(lowerLeftPoint.getX(), lowerLeftPoint.getY(), upperRightPoint.getX(), upperRightPoint.getY());
        return mercatorBox;
    }

    public static double tileSize(int tilesPerSide) {
        return 2.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH / (double)tilesPerSide;
    }

    public static double zoomLevelOfTileSize(double tileSize) {
        double tilesPerSide = 2.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH / tileSize;
        double zoom = Math.log(tilesPerSide) / Math.log(2.0);
        return zoom;
    }

    public static double tileWidthDegrees(int tilesPerSide) {
        return 360.0 / (double)tilesPerSide;
    }

    public static double tileHeightDegrees(int tilesPerSide) {
        return 180.0 / (double)tilesPerSide;
    }

    public static int tilesPerSide(long zoom) {
        return (int)Math.pow(2.0, zoom);
    }

    public static double tileSizeWithZoom(long zoom) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        double tileSize = TileBoundingBoxUtils.tileSize(tilesPerSide);
        return tileSize;
    }

    public static double toleranceDistance(long zoom, int pixels) {
        double tileSize = TileBoundingBoxUtils.tileSizeWithZoom(zoom);
        double tolerance = tileSize / (double)pixels;
        return tolerance;
    }

    public static double toleranceDistance(long zoom, int pixelWidth, int pixelHeight) {
        return TileBoundingBoxUtils.toleranceDistance(zoom, Math.max(pixelWidth, pixelHeight));
    }

    public static int getYAsOppositeTileFormat(long zoom, int y) {
        int tilesPerSide = TileBoundingBoxUtils.tilesPerSide(zoom);
        int oppositeY = tilesPerSide - y - 1;
        return oppositeY;
    }

    public static int zoomFromTilesPerSide(int tilesPerSide) {
        return (int)(Math.log(tilesPerSide) / Math.log(2.0));
    }

    public static TileGrid getTileGrid(BoundingBox totalBox, long matrixWidth, long matrixHeight, BoundingBox boundingBox) {
        long minColumn = TileBoundingBoxUtils.getTileColumn(totalBox, matrixWidth, boundingBox.getMinLongitude());
        long maxColumn = TileBoundingBoxUtils.getTileColumn(totalBox, matrixWidth, boundingBox.getMaxLongitude());
        if (minColumn < matrixWidth && maxColumn >= 0L) {
            if (minColumn < 0L) {
                minColumn = 0L;
            }
            if (maxColumn >= matrixWidth) {
                maxColumn = matrixWidth - 1L;
            }
        }
        long maxRow = TileBoundingBoxUtils.getTileRow(totalBox, matrixHeight, boundingBox.getMinLatitude());
        long minRow = TileBoundingBoxUtils.getTileRow(totalBox, matrixHeight, boundingBox.getMaxLatitude());
        if (minRow < matrixHeight && maxRow >= 0L) {
            if (minRow < 0L) {
                minRow = 0L;
            }
            if (maxRow >= matrixHeight) {
                maxRow = matrixHeight - 1L;
            }
        }
        TileGrid tileGrid = new TileGrid(minColumn, minRow, maxColumn, maxRow);
        return tileGrid;
    }

    public static long getTileColumn(BoundingBox totalBox, long matrixWidth, double longitude) {
        long tileId;
        double minX = totalBox.getMinLongitude();
        double maxX = totalBox.getMaxLongitude();
        if (longitude < minX) {
            tileId = -1L;
        } else if (longitude >= maxX) {
            tileId = matrixWidth;
        } else {
            double matrixWidthMeters = totalBox.getMaxLongitude() - totalBox.getMinLongitude();
            double tileWidth = matrixWidthMeters / (double)matrixWidth;
            tileId = (long)((longitude - minX) / tileWidth);
        }
        return tileId;
    }

    public static long getTileRow(BoundingBox totalBox, long matrixHeight, double latitude) {
        long tileId;
        double minY = totalBox.getMinLatitude();
        double maxY = totalBox.getMaxLatitude();
        if (latitude <= minY) {
            tileId = matrixHeight;
        } else if (latitude > maxY) {
            tileId = -1L;
        } else {
            double matrixHeightMeters = totalBox.getMaxLatitude() - totalBox.getMinLatitude();
            double tileHeight = matrixHeightMeters / (double)matrixHeight;
            tileId = (long)((maxY - latitude) / tileHeight);
        }
        return tileId;
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, TileMatrix tileMatrix, long tileColumn, long tileRow) {
        return TileBoundingBoxUtils.getBoundingBox(totalBox, tileMatrix.getMatrixWidth(), tileMatrix.getMatrixHeight(), tileColumn, tileRow);
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, long tileMatrixWidth, long tileMatrixHeight, long tileColumn, long tileRow) {
        TileGrid tileGrid = new TileGrid(tileColumn, tileRow, tileColumn, tileRow);
        return TileBoundingBoxUtils.getBoundingBox(totalBox, tileMatrixWidth, tileMatrixHeight, tileGrid);
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, TileMatrix tileMatrix, TileGrid tileGrid) {
        return TileBoundingBoxUtils.getBoundingBox(totalBox, tileMatrix.getMatrixWidth(), tileMatrix.getMatrixHeight(), tileGrid);
    }

    public static BoundingBox getBoundingBox(BoundingBox totalBox, long tileMatrixWidth, long tileMatrixHeight, TileGrid tileGrid) {
        double matrixMinX = totalBox.getMinLongitude();
        double matrixMaxX = totalBox.getMaxLongitude();
        double matrixWidth = matrixMaxX - matrixMinX;
        double tileWidth = matrixWidth / (double)tileMatrixWidth;
        double minLon = matrixMinX + tileWidth * (double)tileGrid.getMinX();
        double maxLon = matrixMinX + tileWidth * (double)(tileGrid.getMaxX() + 1L);
        double matrixMinY = totalBox.getMinLatitude();
        double matrixMaxY = totalBox.getMaxLatitude();
        double matrixHeight = matrixMaxY - matrixMinY;
        double tileHeight = matrixHeight / (double)tileMatrixHeight;
        double maxLat = matrixMaxY - tileHeight * (double)tileGrid.getMinY();
        double minLat = matrixMaxY - tileHeight * (double)(tileGrid.getMaxY() + 1L);
        BoundingBox boundingBox = new BoundingBox(minLon, minLat, maxLon, maxLat);
        return boundingBox;
    }

    public static int getZoomLevel(BoundingBox webMercatorBoundingBox) {
        double worldLength = ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH * 2.0;
        double longitudeDistance = webMercatorBoundingBox.getMaxLongitude() - webMercatorBoundingBox.getMinLongitude();
        double latitudeDistance = webMercatorBoundingBox.getMaxLatitude() - webMercatorBoundingBox.getMinLatitude();
        if (longitudeDistance <= 0.0) {
            longitudeDistance = Double.MIN_VALUE;
        }
        if (latitudeDistance <= 0.0) {
            latitudeDistance = Double.MIN_VALUE;
        }
        int widthTiles = (int)(worldLength / longitudeDistance);
        int heightTiles = (int)(worldLength / latitudeDistance);
        int tilesPerSide = Math.min(widthTiles, heightTiles);
        tilesPerSide = Math.max(tilesPerSide, 1);
        int zoom = TileBoundingBoxUtils.zoomFromTilesPerSide(tilesPerSide);
        return zoom;
    }

    public static double getPixelXSize(BoundingBox webMercatorBoundingBox, long matrixWidth, int tileWidth) {
        double pixelXSize = (webMercatorBoundingBox.getMaxLongitude() - webMercatorBoundingBox.getMinLongitude()) / (double)matrixWidth / (double)tileWidth;
        return pixelXSize;
    }

    public static double getPixelYSize(BoundingBox webMercatorBoundingBox, long matrixHeight, int tileHeight) {
        double pixelYSize = (webMercatorBoundingBox.getMaxLatitude() - webMercatorBoundingBox.getMinLatitude()) / (double)matrixHeight / (double)tileHeight;
        return pixelYSize;
    }

    public static BoundingBox boundWebMercatorBoundingBox(BoundingBox boundingBox) {
        BoundingBox bounded = new BoundingBox(boundingBox);
        bounded.setMinLongitude(Math.max(bounded.getMinLongitude(), -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH));
        bounded.setMaxLongitude(Math.min(bounded.getMaxLongitude(), ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH));
        bounded.setMinLatitude(Math.max(bounded.getMinLatitude(), -1.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH));
        bounded.setMaxLatitude(Math.min(bounded.getMaxLatitude(), ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH));
        return bounded;
    }

    public static BoundingBox boundWgs84BoundingBoxWithWebMercatorLimits(BoundingBox boundingBox) {
        return TileBoundingBoxUtils.boundDegreesBoundingBoxWithWebMercatorLimits(boundingBox);
    }

    public static BoundingBox boundDegreesBoundingBoxWithWebMercatorLimits(BoundingBox boundingBox) {
        BoundingBox bounded = new BoundingBox(boundingBox);
        if (bounded.getMinLatitude() < -85.05112877980659) {
            bounded.setMinLatitude(-85.05112877980659);
        }
        if (bounded.getMaxLatitude() < -85.05112877980659) {
            bounded.setMaxLatitude(-85.05112877980659);
        }
        if (bounded.getMaxLatitude() > 85.0511287798066) {
            bounded.setMaxLatitude(85.0511287798066);
        }
        if (bounded.getMinLatitude() > 85.0511287798066) {
            bounded.setMinLatitude(85.0511287798066);
        }
        return bounded;
    }

    public static TileGrid getTileGridWGS84(BoundingBox boundingBox, long zoom) {
        int tilesPerLat = TileBoundingBoxUtils.tilesPerWGS84LatSide(zoom);
        int tilesPerLon = TileBoundingBoxUtils.tilesPerWGS84LonSide(zoom);
        double tileSizeLat = TileBoundingBoxUtils.tileSizeLatPerWGS84Side(tilesPerLat);
        double tileSizeLon = TileBoundingBoxUtils.tileSizeLonPerWGS84Side(tilesPerLon);
        int minX = (int)((boundingBox.getMinLongitude() + ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH) / tileSizeLon);
        double tempMaxX = (boundingBox.getMaxLongitude() + ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH) / tileSizeLon;
        int maxX = (int)tempMaxX;
        if (tempMaxX % 1.0 == 0.0) {
            --maxX;
        }
        maxX = Math.min(maxX, tilesPerLon - 1);
        int minY = (int)((boundingBox.getMaxLatitude() - ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT) * -1.0 / tileSizeLat);
        double tempMaxY = (boundingBox.getMinLatitude() - ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT) * -1.0 / tileSizeLat;
        int maxY = (int)tempMaxY;
        if (tempMaxY % 1.0 == 0.0) {
            --maxY;
        }
        maxY = Math.min(maxY, tilesPerLat - 1);
        TileGrid grid = new TileGrid(minX, minY, maxX, maxY);
        return grid;
    }

    public static BoundingBox getWGS84BoundingBox(TileGrid tileGrid, long zoom) {
        int tilesPerLat = TileBoundingBoxUtils.tilesPerWGS84LatSide(zoom);
        int tilesPerLon = TileBoundingBoxUtils.tilesPerWGS84LonSide(zoom);
        double tileSizeLat = TileBoundingBoxUtils.tileSizeLatPerWGS84Side(tilesPerLat);
        double tileSizeLon = TileBoundingBoxUtils.tileSizeLonPerWGS84Side(tilesPerLon);
        double minLon = -1.0 * ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH + (double)tileGrid.getMinX() * tileSizeLon;
        double maxLon = -1.0 * ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH + (double)(tileGrid.getMaxX() + 1L) * tileSizeLon;
        double minLat = ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT - (double)(tileGrid.getMaxY() + 1L) * tileSizeLat;
        double maxLat = ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT - (double)tileGrid.getMinY() * tileSizeLat;
        BoundingBox box = new BoundingBox(minLon, minLat, maxLon, maxLat);
        return box;
    }

    public static int tilesPerWGS84LatSide(long zoom) {
        return TileBoundingBoxUtils.tilesPerSide(zoom);
    }

    public static int tilesPerWGS84LonSide(long zoom) {
        return 2 * TileBoundingBoxUtils.tilesPerSide(zoom);
    }

    public static double tileSizeLatPerWGS84Side(int tilesPerLat) {
        return 2.0 * ProjectionConstants.WGS84_HALF_WORLD_LAT_HEIGHT / (double)tilesPerLat;
    }

    public static double tileSizeLonPerWGS84Side(int tilesPerLon) {
        return 2.0 * ProjectionConstants.WGS84_HALF_WORLD_LON_WIDTH / (double)tilesPerLon;
    }

    public static TileGrid tileGridZoom(TileGrid tileGrid, long fromZoom, long toZoom) {
        TileGrid newTileGrid = null;
        long zoomChange = toZoom - fromZoom;
        if (zoomChange > 0L) {
            newTileGrid = TileBoundingBoxUtils.tileGridZoomIncrease(tileGrid, zoomChange);
        } else if (zoomChange < 0L) {
            zoomChange = Math.abs(zoomChange);
            newTileGrid = TileBoundingBoxUtils.tileGridZoomDecrease(tileGrid, zoomChange);
        } else {
            newTileGrid = tileGrid;
        }
        return newTileGrid;
    }

    public static TileGrid tileGridZoomIncrease(TileGrid tileGrid, long zoomLevels) {
        long minX = TileBoundingBoxUtils.tileGridMinZoomIncrease(tileGrid.getMinX(), zoomLevels);
        long maxX = TileBoundingBoxUtils.tileGridMaxZoomIncrease(tileGrid.getMaxX(), zoomLevels);
        long minY = TileBoundingBoxUtils.tileGridMinZoomIncrease(tileGrid.getMinY(), zoomLevels);
        long maxY = TileBoundingBoxUtils.tileGridMaxZoomIncrease(tileGrid.getMaxY(), zoomLevels);
        TileGrid newTileGrid = new TileGrid(minX, minY, maxX, maxY);
        return newTileGrid;
    }

    public static TileGrid tileGridZoomDecrease(TileGrid tileGrid, long zoomLevels) {
        long minX = TileBoundingBoxUtils.tileGridMinZoomDecrease(tileGrid.getMinX(), zoomLevels);
        long maxX = TileBoundingBoxUtils.tileGridMaxZoomDecrease(tileGrid.getMaxX(), zoomLevels);
        long minY = TileBoundingBoxUtils.tileGridMinZoomDecrease(tileGrid.getMinY(), zoomLevels);
        long maxY = TileBoundingBoxUtils.tileGridMaxZoomDecrease(tileGrid.getMaxY(), zoomLevels);
        TileGrid newTileGrid = new TileGrid(minX, minY, maxX, maxY);
        return newTileGrid;
    }

    public static long tileGridMinZoomIncrease(long min, long zoomLevels) {
        return min * (long)Math.pow(2.0, zoomLevels);
    }

    public static long tileGridMaxZoomIncrease(long max, long zoomLevels) {
        return (max + 1L) * (long)Math.pow(2.0, zoomLevels) - 1L;
    }

    public static long tileGridMinZoomDecrease(long min, long zoomLevels) {
        return (long)Math.floor((double)min / Math.pow(2.0, zoomLevels));
    }

    public static long tileGridMaxZoomDecrease(long max, long zoomLevels) {
        return (long)Math.ceil((double)(max + 1L) / Math.pow(2.0, zoomLevels) - 1.0);
    }
}

