/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.reproject;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.reproject.PlatteCarreOptimize;
import mil.nga.geopackage.tiles.reproject.WebMercatorOptimize;
import mil.nga.sf.proj.Projection;

public abstract class TileReprojectionOptimize {
    private boolean world;

    public static TileReprojectionOptimize webMercator() {
        return WebMercatorOptimize.create();
    }

    public static TileReprojectionOptimize platteCarre() {
        return PlatteCarreOptimize.create();
    }

    public static TileReprojectionOptimize webMercatorWorld() {
        return WebMercatorOptimize.createWorld();
    }

    public static TileReprojectionOptimize platteCarreWorld() {
        return PlatteCarreOptimize.createWorld();
    }

    public TileReprojectionOptimize() {
        this(false);
    }

    public TileReprojectionOptimize(boolean world) {
        this.world = world;
    }

    public boolean isWorld() {
        return this.world;
    }

    public void setWorld(boolean world) {
        this.world = world;
    }

    public abstract Projection getProjection();

    public abstract TileGrid getTileGrid();

    public abstract BoundingBox getBoundingBox();

    public abstract TileGrid getTileGrid(BoundingBox var1, long var2);

    public abstract BoundingBox getBoundingBox(TileGrid var1, long var2);
}

