/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.user;

import java.util.Arrays;
import java.util.List;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.sf.proj.ProjectionConstants;
import mil.nga.sf.proj.ProjectionFactory;
import org.locationtech.proj4j.units.Units;

public class TileDaoUtils {
    public static void adjustTileMatrixLengths(TileMatrixSet tileMatrixSet, List<TileMatrix> tileMatrices) {
        double tileMatrixWidth = tileMatrixSet.getMaxX() - tileMatrixSet.getMinX();
        double tileMatrixHeight = tileMatrixSet.getMaxY() - tileMatrixSet.getMinY();
        for (TileMatrix tileMatrix : tileMatrices) {
            int tempMatrixWidth = (int)(tileMatrixWidth / (tileMatrix.getPixelXSize() * (double)tileMatrix.getTileWidth()));
            int tempMatrixHeight = (int)(tileMatrixHeight / (tileMatrix.getPixelYSize() * (double)tileMatrix.getTileHeight()));
            if ((long)tempMatrixWidth > tileMatrix.getMatrixWidth()) {
                tileMatrix.setMatrixWidth(tempMatrixWidth);
            }
            if ((long)tempMatrixHeight <= tileMatrix.getMatrixHeight()) continue;
            tileMatrix.setMatrixHeight(tempMatrixHeight);
        }
    }

    public static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, length, true);
    }

    public static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double width, double height) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, width, height, true);
    }

    public static Long getClosestZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, length, false);
    }

    public static Long getClosestZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double width, double height) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, width, height, false);
    }

    private static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length, boolean lengthChecks) {
        return TileDaoUtils.getZoomLevel(widths, heights, tileMatrices, length, length, lengthChecks);
    }

    private static Long getZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double width, double height, boolean lengthChecks) {
        int heightIndex;
        Long zoomLevel = null;
        int widthIndex = Arrays.binarySearch(widths, width);
        if (widthIndex < 0) {
            widthIndex = (widthIndex + 1) * -1;
        }
        if ((heightIndex = Arrays.binarySearch(heights, height)) < 0) {
            heightIndex = (heightIndex + 1) * -1;
        }
        if (widthIndex == 0) {
            if (lengthChecks && width < TileDaoUtils.getMinLength(widths)) {
                widthIndex = -1;
            }
        } else if (widthIndex == widths.length) {
            widthIndex = lengthChecks && width >= TileDaoUtils.getMaxLength(widths) ? -1 : --widthIndex;
        } else if (TileDaoUtils.closerToZoomIn(widths, width, widthIndex)) {
            --widthIndex;
        }
        if (heightIndex == 0) {
            if (lengthChecks && height < TileDaoUtils.getMinLength(heights)) {
                heightIndex = -1;
            }
        } else if (heightIndex == heights.length) {
            heightIndex = lengthChecks && height >= TileDaoUtils.getMaxLength(heights) ? -1 : --heightIndex;
        } else if (TileDaoUtils.closerToZoomIn(heights, height, heightIndex)) {
            --heightIndex;
        }
        if (widthIndex >= 0 || heightIndex >= 0) {
            int index = widthIndex < 0 ? heightIndex : (heightIndex < 0 ? widthIndex : Math.min(widthIndex, heightIndex));
            TileMatrix tileMatrix = TileDaoUtils.getTileMatrixAtLengthIndex(tileMatrices, index);
            zoomLevel = tileMatrix.getZoomLevel();
        }
        return zoomLevel;
    }

    private static boolean closerToZoomIn(double[] lengths, double length, int lengthIndex) {
        double zoomOutDistance;
        double zoomInDistance = Math.log(length / lengths[lengthIndex - 1]) / Math.log(2.0);
        boolean zoomIn = zoomInDistance < (zoomOutDistance = Math.log(length / lengths[lengthIndex]) / Math.log(0.5));
        return zoomIn;
    }

    private static TileMatrix getTileMatrixAtLengthIndex(List<TileMatrix> tileMatrices, int index) {
        return tileMatrices.get(tileMatrices.size() - index - 1);
    }

    public static Long getApproximateZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double length) {
        return TileDaoUtils.getApproximateZoomLevel(widths, heights, tileMatrices, length, length);
    }

    public static Long getApproximateZoomLevel(double[] widths, double[] heights, List<TileMatrix> tileMatrices, double width, double height) {
        Long widthZoomLevel = TileDaoUtils.getApproximateZoomLevel(widths, tileMatrices, width);
        Long heightZoomLevel = TileDaoUtils.getApproximateZoomLevel(heights, tileMatrices, height);
        Long expectedZoomLevel = widthZoomLevel == null ? heightZoomLevel : (heightZoomLevel == null ? widthZoomLevel : Long.valueOf(Math.max(widthZoomLevel, heightZoomLevel)));
        return expectedZoomLevel;
    }

    private static Long getApproximateZoomLevel(double[] lengths, List<TileMatrix> tileMatrices, double length) {
        Long lengthZoomLevel = null;
        double minLength = lengths[0];
        double maxLength = lengths[lengths.length - 1];
        if (length < minLength) {
            double levelsIn = Math.log(length / minLength) / Math.log(0.5);
            long zoomAbove = (long)Math.floor(levelsIn);
            long zoomBelow = (long)Math.ceil(levelsIn);
            double lengthAbove = minLength * Math.pow(0.5, zoomAbove);
            double lengthBelow = minLength * Math.pow(0.5, zoomBelow);
            lengthZoomLevel = tileMatrices.get(tileMatrices.size() - 1).getZoomLevel();
            lengthZoomLevel = lengthAbove - length <= length - lengthBelow ? Long.valueOf(lengthZoomLevel + zoomAbove) : Long.valueOf(lengthZoomLevel + zoomBelow);
        } else if (length > maxLength) {
            double levelsOut = Math.log(length / maxLength) / Math.log(2.0);
            long zoomAbove = (long)Math.ceil(levelsOut);
            long zoomBelow = (long)Math.floor(levelsOut);
            double lengthAbove = maxLength * Math.pow(2.0, zoomAbove);
            double lengthBelow = maxLength * Math.pow(2.0, zoomBelow);
            lengthZoomLevel = tileMatrices.get(0).getZoomLevel();
            lengthZoomLevel = length - lengthBelow <= lengthAbove - length ? Long.valueOf(lengthZoomLevel - zoomBelow) : Long.valueOf(lengthZoomLevel - zoomAbove);
        } else {
            int lengthIndex = Arrays.binarySearch(lengths, length);
            if (lengthIndex < 0) {
                lengthIndex = (lengthIndex + 1) * -1;
            }
            double zoomDistance = Math.log(length / lengths[lengthIndex]) / Math.log(0.5);
            long zoomLevelAbove = TileDaoUtils.getTileMatrixAtLengthIndex(tileMatrices, lengthIndex).getZoomLevel();
            lengthZoomLevel = zoomLevelAbove += Math.round(zoomDistance);
        }
        return lengthZoomLevel;
    }

    public static double getMaxLength(double[] widths, double[] heights) {
        double maxWidth = TileDaoUtils.getMaxLength(widths);
        double maxHeight = TileDaoUtils.getMaxLength(heights);
        double maxLength = Math.min(maxWidth, maxHeight);
        return maxLength;
    }

    public static double getMinLength(double[] widths, double[] heights) {
        double minWidth = TileDaoUtils.getMinLength(widths);
        double minHeight = TileDaoUtils.getMinLength(heights);
        double minLength = Math.max(minWidth, minHeight);
        return minLength;
    }

    private static double getMaxLength(double[] lengths) {
        return lengths[lengths.length - 1] / 0.51;
    }

    private static double getMinLength(double[] lengths) {
        return lengths[0] * 0.51;
    }

    public static long[] getMapZoomRange(TileMatrixSet tileMatrixSet, List<TileMatrix> tileMatrices) {
        long min = TileDaoUtils.getMapMinZoom(tileMatrixSet, tileMatrices);
        long max = TileDaoUtils.getMapMaxZoom(tileMatrixSet, tileMatrices);
        return new long[]{min, max};
    }

    public static long getMapMinZoom(TileMatrixSet tileMatrixSet, List<TileMatrix> tileMatrices) {
        return TileDaoUtils.getMapZoom(tileMatrixSet, tileMatrices.get(0));
    }

    public static long getMapMaxZoom(TileMatrixSet tileMatrixSet, List<TileMatrix> tileMatrices) {
        return TileDaoUtils.getMapZoom(tileMatrixSet, tileMatrices.get(tileMatrices.size() - 1));
    }

    public static long getMapZoom(TileMatrixSet tileMatrixSet, TileMatrix tileMatrix) {
        BoundingBox boundingBox = tileMatrixSet.getBoundingBox(ProjectionFactory.getProjection((long)3857L));
        long zoom = TileDaoUtils.getMapZoom(boundingBox.getMinLongitude(), boundingBox.getMaxLongitude(), tileMatrix.getMatrixWidth());
        if (!tileMatrixSet.getProjection().isUnit(Units.DEGREES)) {
            zoom = Math.min(zoom, TileDaoUtils.getMapZoom(boundingBox.getMinLatitude(), boundingBox.getMaxLatitude(), tileMatrix.getMatrixHeight()));
        }
        return zoom;
    }

    private static long getMapZoom(double min, double max, double matrixLength) {
        return Math.round(Math.log(2.0 * ProjectionConstants.WEB_MERCATOR_HALF_WORLD_WIDTH / ((max - min) / matrixLength)) / Math.log(2.0));
    }
}

