/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.MappedColumn;
import mil.nga.geopackage.db.TableMapping;
import mil.nga.geopackage.db.master.SQLiteMaster;
import mil.nga.geopackage.db.master.SQLiteMasterColumn;
import mil.nga.geopackage.db.master.SQLiteMasterQuery;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;

public class CoreSQLUtils {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");

    public static String quoteWrap(String name) {
        String quoteName = null;
        if (name != null) {
            quoteName = name.startsWith("\"") && name.endsWith("\"") ? name : "\"" + name + "\"";
        }
        return quoteName;
    }

    public static String[] quoteWrap(String[] names) {
        String[] quoteNames = null;
        if (names != null) {
            quoteNames = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                quoteNames[i] = CoreSQLUtils.quoteWrap(names[i]);
            }
        }
        return quoteNames;
    }

    public static String quoteUnwrap(String name) {
        String unquotedName = null;
        if (name != null) {
            unquotedName = name.startsWith("\"") && name.endsWith("\"") ? name.substring(1, name.length() - 1) : name;
        }
        return unquotedName;
    }

    public static String[] buildColumnsAs(String[] columns, String[] columnsAs) {
        String[] columnsWithAs = null;
        if (columnsAs != null) {
            columnsWithAs = new String[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                String columnsAsValue = columnsAs[i];
                String columnWithAs = null;
                columnWithAs = columnsAsValue != null ? columnsAsValue + " AS " + column : column;
                columnsWithAs[i] = columnWithAs;
            }
        } else {
            columnsWithAs = columns;
        }
        return columnsWithAs;
    }

    public static <TColumn extends UserColumn> String createTableSQL(UserTable<TColumn> table) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ").append(CoreSQLUtils.quoteWrap(table.getTableName())).append(" (");
        List<TColumn> columns = table.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            UserColumn column = (UserColumn)columns.get(i);
            if (i > 0) {
                sql.append(",");
            }
            sql.append("\n  ");
            sql.append(CoreSQLUtils.columnSQL(column));
        }
        for (Constraint constraint : table.getConstraints().all()) {
            sql.append(",\n  ");
            sql.append(constraint.buildSql());
        }
        sql.append("\n);");
        return sql.toString();
    }

    public static String columnSQL(UserColumn column) {
        return CoreSQLUtils.quoteWrap(column.getName()) + " " + CoreSQLUtils.columnDefinition(column);
    }

    public static String columnDefinition(UserColumn column) {
        StringBuilder sql = new StringBuilder();
        sql.append(column.getType());
        if (column.hasMax()) {
            sql.append("(").append(column.getMax()).append(")");
        }
        for (Constraint constraint : column.getConstraints().all()) {
            String constraintSql = column.buildConstraintSql(constraint);
            if (constraintSql == null) continue;
            sql.append(" ");
            sql.append(constraintSql);
        }
        return sql.toString();
    }

    public static String columnDefaultValue(UserColumn column) {
        return CoreSQLUtils.columnDefaultValue(column.getDefaultValue(), column.getDataType());
    }

    public static String columnDefaultValue(Object defaultValue, GeoPackageDataType dataType) {
        String value = null;
        if (defaultValue != null) {
            if (dataType != null) {
                switch (dataType) {
                    case BOOLEAN: {
                        Boolean booleanValue = null;
                        if (defaultValue instanceof Boolean) {
                            booleanValue = (Boolean)defaultValue;
                        } else if (defaultValue instanceof String) {
                            String stringBooleanValue;
                            switch (stringBooleanValue = (String)defaultValue) {
                                case "0": {
                                    booleanValue = false;
                                    break;
                                }
                                case "1": {
                                    booleanValue = true;
                                    break;
                                }
                                default: {
                                    booleanValue = Boolean.valueOf(stringBooleanValue);
                                }
                            }
                        }
                        if (booleanValue == null) break;
                        if (booleanValue.booleanValue()) {
                            value = "1";
                            break;
                        }
                        value = "0";
                        break;
                    }
                    case TEXT: {
                        value = defaultValue.toString();
                        if (value.startsWith("'") && value.endsWith("'")) break;
                        value = "'" + value + "'";
                        break;
                    }
                }
            }
            if (value == null) {
                value = defaultValue.toString();
            }
        }
        return value;
    }

    public static void addColumn(GeoPackageCoreConnection db, String tableName, UserColumn column) {
        AlterTable.addColumn(db, tableName, column.getName(), CoreSQLUtils.columnDefinition(column));
    }

    public static boolean foreignKeys(GeoPackageCoreConnection db) {
        Boolean foreignKeys = (Boolean)db.querySingleTypedResult("PRAGMA foreign_keys", null, GeoPackageDataType.BOOLEAN);
        return foreignKeys != null && foreignKeys != false;
    }

    public static boolean foreignKeys(GeoPackageCoreConnection db, boolean on) {
        boolean foreignKeys = CoreSQLUtils.foreignKeys(db);
        if (foreignKeys != on) {
            String sql = CoreSQLUtils.foreignKeysSQL(on);
            db.execSQL(sql);
        }
        return foreignKeys;
    }

    public static String foreignKeysSQL(boolean on) {
        return "PRAGMA foreign_keys = " + on;
    }

    public static List<List<Object>> foreignKeyCheck(GeoPackageCoreConnection db) {
        String sql = CoreSQLUtils.foreignKeyCheckSQL();
        return db.queryResults(sql, null);
    }

    public static List<List<Object>> foreignKeyCheck(GeoPackageCoreConnection db, String tableName) {
        String sql = CoreSQLUtils.foreignKeyCheckSQL(tableName);
        return db.queryResults(sql, null);
    }

    public static String foreignKeyCheckSQL() {
        return CoreSQLUtils.foreignKeyCheckSQL(null);
    }

    public static String foreignKeyCheckSQL(String tableName) {
        return "PRAGMA foreign_key_check" + (tableName != null ? "(" + CoreSQLUtils.quoteWrap(tableName) + ")" : "");
    }

    public static String integrityCheckSQL() {
        return "PRAGMA integrity_check";
    }

    public static String quickCheckSQL() {
        return "PRAGMA quick_check";
    }

    public static void dropTable(GeoPackageCoreConnection db, String tableName) {
        String sql = CoreSQLUtils.dropTableSQL(tableName);
        db.execSQL(sql);
    }

    public static String dropTableSQL(String tableName) {
        return "DROP TABLE IF EXISTS " + CoreSQLUtils.quoteWrap(tableName);
    }

    public static void dropView(GeoPackageCoreConnection db, String viewName) {
        String sql = CoreSQLUtils.dropViewSQL(viewName);
        db.execSQL(sql);
    }

    public static String dropViewSQL(String viewName) {
        return "DROP VIEW IF EXISTS " + CoreSQLUtils.quoteWrap(viewName);
    }

    public static void transferTableContent(GeoPackageCoreConnection db, TableMapping tableMapping) {
        String sql = CoreSQLUtils.transferTableContentSQL(tableMapping);
        db.execSQL(sql);
    }

    public static String transferTableContentSQL(TableMapping tableMapping) {
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(CoreSQLUtils.quoteWrap(tableMapping.getToTable()));
        insert.append(" (");
        StringBuilder selectColumns = new StringBuilder();
        StringBuilder where = new StringBuilder();
        if (tableMapping.hasWhere()) {
            where.append(tableMapping.getWhere());
        }
        for (Map.Entry<String, MappedColumn> columnEntry : tableMapping.getColumns()) {
            String toColumn = columnEntry.getKey();
            MappedColumn column = columnEntry.getValue();
            if (selectColumns.length() > 0) {
                insert.append(", ");
                selectColumns.append(", ");
            }
            insert.append(CoreSQLUtils.quoteWrap(toColumn));
            if (column.hasConstantValue()) {
                selectColumns.append(column.getConstantValueAsString());
            } else {
                if (column.hasDefaultValue()) {
                    selectColumns.append("ifnull(");
                }
                selectColumns.append(CoreSQLUtils.quoteWrap(column.getFromColumn()));
                if (column.hasDefaultValue()) {
                    selectColumns.append(",");
                    selectColumns.append(column.getDefaultValueAsString());
                    selectColumns.append(")");
                }
            }
            if (!column.hasWhereValue()) continue;
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(CoreSQLUtils.quoteWrap(column.getFromColumn()));
            where.append(" ");
            where.append(column.getWhereOperator());
            where.append(" ");
            where.append(column.getWhereValueAsString());
        }
        insert.append(") SELECT ");
        insert.append((CharSequence)selectColumns);
        insert.append(" FROM ");
        insert.append(CoreSQLUtils.quoteWrap(tableMapping.getFromTable()));
        if (where.length() > 0) {
            insert.append(" WHERE ");
            insert.append((CharSequence)where);
        }
        return insert.toString();
    }

    public static void transferTableContent(GeoPackageCoreConnection db, String tableName, String columnName, Object newColumnValue, Object currentColumnValue) {
        CoreSQLUtils.transferTableContent(db, tableName, columnName, newColumnValue, currentColumnValue, null);
    }

    public static void transferTableContent(GeoPackageCoreConnection db, String tableName, String columnName, Object newColumnValue, Object currentColumnValue, String idColumnName) {
        TableMapping tableMapping = new TableMapping(db, tableName);
        if (idColumnName != null) {
            tableMapping.removeColumn(idColumnName);
        }
        MappedColumn tileMatrixSetNameColumn = tableMapping.getColumn(columnName);
        tileMatrixSetNameColumn.setConstantValue(newColumnValue);
        tileMatrixSetNameColumn.setWhereValue(currentColumnValue);
        CoreSQLUtils.transferTableContent(db, tableMapping);
    }

    public static String tempTableName(GeoPackageCoreConnection db, String prefix, String baseName) {
        String name = prefix + "_" + baseName;
        int nameNumber = 0;
        while (db.tableOrViewExists(name)) {
            name = prefix + ++nameNumber + "_" + baseName;
        }
        return name;
    }

    public static String modifySQL(String name, String sql, TableMapping tableMapping) {
        return CoreSQLUtils.modifySQL(null, name, sql, tableMapping);
    }

    public static String modifySQL(GeoPackageCoreConnection db, String name, String sql, TableMapping tableMapping) {
        String updatedSql = sql;
        if (name != null && tableMapping.isNewTable()) {
            String updatedTable;
            String newName = CoreSQLUtils.createName(db, name, tableMapping.getFromTable(), tableMapping.getToTable());
            String updatedName = CoreSQLUtils.replaceName(updatedSql, name, newName);
            if (updatedName != null) {
                updatedSql = updatedName;
            }
            if ((updatedTable = CoreSQLUtils.replaceName(updatedSql, tableMapping.getFromTable(), tableMapping.getToTable())) != null) {
                updatedSql = updatedTable;
            }
        }
        updatedSql = CoreSQLUtils.modifySQL(updatedSql, tableMapping);
        return updatedSql;
    }

    public static String modifySQL(String sql, TableMapping tableMapping) {
        String updated;
        String updatedSql = sql;
        for (String string : tableMapping.getDroppedColumns()) {
            updated = CoreSQLUtils.replaceName(updatedSql, string, " ");
            if (updated == null) continue;
            updatedSql = null;
            break;
        }
        if (updatedSql != null) {
            for (MappedColumn mappedColumn : tableMapping.getMappedColumns()) {
                if (!mappedColumn.hasNewName() || (updated = CoreSQLUtils.replaceName(updatedSql, mappedColumn.getFromColumn(), mappedColumn.getToColumn())) == null) continue;
                updatedSql = updated;
            }
        }
        return updatedSql;
    }

    public static String replaceName(String sql, String name, String replacement) {
        String updatedSql = null;
        if (sql.contains(name)) {
            boolean updated = false;
            StringBuilder updatedSqlBuilder = new StringBuilder();
            String[] parts = sql.split(name);
            for (int i = 0; i <= parts.length; ++i) {
                if (i > 0) {
                    String before = "_";
                    String beforePart = parts[i - 1];
                    if (beforePart.isEmpty()) {
                        if (i == 1) {
                            before = " ";
                        }
                    } else {
                        before = beforePart.substring(beforePart.length() - 1);
                    }
                    String after = "_";
                    if (i < parts.length) {
                        String afterPart = parts[i];
                        if (!afterPart.isEmpty()) {
                            after = afterPart.substring(0, 1);
                        }
                    } else {
                        if (!sql.endsWith(name)) break;
                        after = " ";
                    }
                    if (before.matches("\\W") && after.matches("\\W")) {
                        updatedSqlBuilder.append(replacement);
                        updated = true;
                    } else {
                        updatedSqlBuilder.append(name);
                    }
                }
                if (i >= parts.length) continue;
                updatedSqlBuilder.append(parts[i]);
            }
            if (updated) {
                updatedSql = updatedSqlBuilder.toString();
            }
        }
        return updatedSql;
    }

    public static String createName(String name, String replace, String replacement) {
        return CoreSQLUtils.createName(null, name, replace, replacement);
    }

    public static String createName(GeoPackageCoreConnection db, String name, String replace, String replacement) {
        String newName = name.replaceAll("(?i)" + replace, replacement);
        if (newName.equals(name)) {
            String numberPart;
            String baseName = newName;
            int count = 1;
            int index = baseName.lastIndexOf("_");
            if (index >= 0 && index + 1 < baseName.length() && NUMBER_PATTERN.matcher(numberPart = baseName.substring(index + 1)).matches()) {
                baseName = baseName.substring(0, index);
                count = Integer.valueOf(numberPart);
            }
            newName = baseName + "_" + ++count;
            if (db != null) {
                while (SQLiteMaster.count(db, SQLiteMasterQuery.create(SQLiteMasterColumn.NAME, newName)) > 0) {
                    newName = baseName + "_" + ++count;
                }
            }
        }
        return newName;
    }

    public static void vacuum(GeoPackageCoreConnection db) {
        db.execSQL("VACUUM");
    }
}

