/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.reproject;

import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.reproject.TileReprojectionOptimize;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;

public class PlatteCarreOptimize
extends TileReprojectionOptimize {
    public static PlatteCarreOptimize create() {
        return new PlatteCarreOptimize();
    }

    public static PlatteCarreOptimize createWorld() {
        return new PlatteCarreOptimize(true);
    }

    public PlatteCarreOptimize() {
    }

    public PlatteCarreOptimize(boolean world) {
        super(world);
    }

    @Override
    public Projection getProjection() {
        return ProjectionFactory.getProjection((long)4326L);
    }

    @Override
    public TileGrid getTileGrid() {
        return new TileGrid(0L, 0L, 1L, 0L);
    }

    @Override
    public BoundingBox getBoundingBox() {
        return new BoundingBox();
    }

    @Override
    public TileGrid getTileGrid(BoundingBox boundingBox, long zoom) {
        return TileBoundingBoxUtils.getTileGridWGS84(boundingBox, (int)zoom);
    }

    @Override
    public BoundingBox getBoundingBox(TileGrid tileGrid, long zoom) {
        return TileBoundingBoxUtils.getWGS84BoundingBox(tileGrid, (int)zoom);
    }
}

