/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.geom;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.GeometryExtensions;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;
import mil.nga.proj.ProjectionTransform;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.GeometryTransform;
import mil.nga.sf.util.ByteReader;
import mil.nga.sf.util.ByteWriter;
import mil.nga.sf.util.GeometryEnvelopeBuilder;
import mil.nga.sf.util.filter.GeometryFilter;
import mil.nga.sf.util.filter.PointFiniteFilter;
import mil.nga.sf.wkb.GeometryReader;
import mil.nga.sf.wkb.GeometryWriter;

public class GeoPackageGeometryData {
    private static GeometryFilter geometryFilter = new PointFiniteFilter();
    private static int defaultSrsId = GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_CARTESIAN, "srs_id");
    private static ByteOrder defaultByteOrder = ByteOrder.BIG_ENDIAN;
    private byte[] bytes;
    private boolean extended = false;
    private boolean empty = true;
    private ByteOrder byteOrder = defaultByteOrder;
    private int srsId;
    private GeometryEnvelope envelope;
    private int wkbGeometryIndex;
    private Geometry geometry;

    public static GeometryFilter getGeometryFilter() {
        return geometryFilter;
    }

    public static void setGeometryFilter(GeometryFilter geometryFilter) {
        GeoPackageGeometryData.geometryFilter = geometryFilter;
    }

    public static int getDefaultSrsId() {
        return defaultSrsId;
    }

    public static void setDefaultSrsId(int defaultSrsId) {
        GeoPackageGeometryData.defaultSrsId = defaultSrsId;
    }

    public static ByteOrder getDefaultByteOrder() {
        return defaultByteOrder;
    }

    public static void setDefaultByteOrder(ByteOrder defaultByteOrder) {
        GeoPackageGeometryData.defaultByteOrder = defaultByteOrder;
    }

    public static GeoPackageGeometryData create() {
        return new GeoPackageGeometryData();
    }

    public static GeoPackageGeometryData create(Geometry geometry) {
        return new GeoPackageGeometryData(geometry);
    }

    public static GeoPackageGeometryData createAndBuildEnvelope(Geometry geometry) {
        return new GeoPackageGeometryData(geometry, true);
    }

    public static GeoPackageGeometryData create(long srsId) {
        return new GeoPackageGeometryData(srsId);
    }

    public static GeoPackageGeometryData create(long srsId, Geometry geometry) {
        return new GeoPackageGeometryData(srsId, geometry);
    }

    public static GeoPackageGeometryData createAndBuildEnvelope(long srsId, Geometry geometry) {
        return new GeoPackageGeometryData(srsId, geometry, true);
    }

    public static GeoPackageGeometryData createAndWrite(Geometry geometry) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.create(geometry));
    }

    public static GeoPackageGeometryData createBuildEnvelopeAndWrite(Geometry geometry) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createAndBuildEnvelope(geometry));
    }

    public static GeoPackageGeometryData createAndWrite(long srsId, Geometry geometry) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.create(srsId, geometry));
    }

    public static GeoPackageGeometryData createBuildEnvelopeAndWrite(long srsId, Geometry geometry) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createAndBuildEnvelope(srsId, geometry));
    }

    public static GeoPackageGeometryData create(byte[] bytes) {
        return new GeoPackageGeometryData(bytes);
    }

    public static GeoPackageGeometryData create(Geometry geometry, GeometryEnvelope envelope) {
        return new GeoPackageGeometryData(geometry, envelope);
    }

    public static GeoPackageGeometryData create(long srsId, Geometry geometry, GeometryEnvelope envelope) {
        return new GeoPackageGeometryData(srsId, geometry, envelope);
    }

    public static GeoPackageGeometryData create(GeoPackageGeometryData geometryData) {
        return new GeoPackageGeometryData(geometryData);
    }

    public static GeoPackageGeometryData createFromWkb(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createFromWkb(defaultSrsId, bytes);
    }

    public static GeoPackageGeometryData createFromWkbAndBuildEnvelope(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createFromWkbAndBuildEnvelope(defaultSrsId, bytes);
    }

    public static GeoPackageGeometryData createFromWkb(long srsId, byte[] bytes) throws IOException {
        return GeoPackageGeometryData.create(srsId, GeoPackageGeometryData.createGeometryFromWkb(bytes));
    }

    public static GeoPackageGeometryData createFromWkbAndBuildEnvelope(long srsId, byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createAndBuildEnvelope(srsId, GeoPackageGeometryData.createGeometryFromWkb(bytes));
    }

    public static GeoPackageGeometryData createFromWkbAndWrite(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWkb(bytes));
    }

    public static GeoPackageGeometryData createFromWkbBuildEnvelopeAndWrite(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWkbAndBuildEnvelope(bytes));
    }

    public static GeoPackageGeometryData createFromWkbAndWrite(long srsId, byte[] bytes) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWkb(srsId, bytes));
    }

    public static GeoPackageGeometryData createFromWkbBuildEnvelopeAndWrite(long srsId, byte[] bytes) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWkbAndBuildEnvelope(srsId, bytes));
    }

    public static Geometry createGeometryFromWkb(byte[] bytes) throws IOException {
        return GeometryReader.readGeometry((byte[])bytes, (GeometryFilter)geometryFilter);
    }

    public static GeoPackageGeometryData createFromWkt(String text) throws IOException {
        return GeoPackageGeometryData.createFromWkt(defaultSrsId, text);
    }

    public static GeoPackageGeometryData createFromWktAndBuildEnvelope(String text) throws IOException {
        return GeoPackageGeometryData.createFromWktAndBuildEnvelope(defaultSrsId, text);
    }

    public static GeoPackageGeometryData createFromWkt(long srsId, String text) throws IOException {
        return GeoPackageGeometryData.create(srsId, GeoPackageGeometryData.createGeometryFromWkt(text));
    }

    public static GeoPackageGeometryData createFromWktAndBuildEnvelope(long srsId, String text) throws IOException {
        return GeoPackageGeometryData.createAndBuildEnvelope(srsId, GeoPackageGeometryData.createGeometryFromWkt(text));
    }

    public static GeoPackageGeometryData createFromWktAndWrite(String text) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWkt(text));
    }

    public static GeoPackageGeometryData createFromWktBuildEnvelopeAndWrite(String text) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWktAndBuildEnvelope(text));
    }

    public static GeoPackageGeometryData createFromWktAndWrite(long srsId, String text) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWkt(srsId, text));
    }

    public static GeoPackageGeometryData createFromWktBuildEnvelopeAndWrite(long srsId, String text) throws IOException {
        return GeoPackageGeometryData.writeBytes(GeoPackageGeometryData.createFromWktAndBuildEnvelope(srsId, text));
    }

    public static Geometry createGeometryFromWkt(String text) throws IOException {
        return mil.nga.sf.wkt.GeometryReader.readGeometry((String)text, (GeometryFilter)geometryFilter);
    }

    public static byte[] bytes(Geometry geometry) throws IOException {
        return GeoPackageGeometryData.createAndWrite(geometry).getBytes();
    }

    public static byte[] bytesAndBuildEnvelope(Geometry geometry) throws IOException {
        return GeoPackageGeometryData.createBuildEnvelopeAndWrite(geometry).getBytes();
    }

    public static byte[] bytes(long srsId, Geometry geometry) throws IOException {
        return GeoPackageGeometryData.createAndWrite(srsId, geometry).getBytes();
    }

    public static byte[] bytesAndBuildEnvelope(long srsId, Geometry geometry) throws IOException {
        return GeoPackageGeometryData.createBuildEnvelopeAndWrite(srsId, geometry).getBytes();
    }

    public static byte[] bytesFromWkb(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createFromWkbAndWrite(bytes).getBytes();
    }

    public static byte[] bytesFromWkbAndBuildEnvelope(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createFromWkbBuildEnvelopeAndWrite(bytes).getBytes();
    }

    public static byte[] bytesFromWkb(long srsId, byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createFromWkbAndWrite(srsId, bytes).getBytes();
    }

    public static byte[] bytesFromWkbAndBuildEnvelope(long srsId, byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createFromWkbBuildEnvelopeAndWrite(srsId, bytes).getBytes();
    }

    public static byte[] bytesFromWkt(String text) throws IOException {
        return GeoPackageGeometryData.createFromWktAndWrite(text).getBytes();
    }

    public static byte[] bytesFromWktAndBuildEnvelope(String text) throws IOException {
        return GeoPackageGeometryData.createFromWktBuildEnvelopeAndWrite(text).getBytes();
    }

    public static byte[] bytesFromWkt(long srsId, String text) throws IOException {
        return GeoPackageGeometryData.createFromWktAndWrite(srsId, text).getBytes();
    }

    public static byte[] bytesFromWktAndBuildEnvelope(long srsId, String text) throws IOException {
        return GeoPackageGeometryData.createFromWktBuildEnvelopeAndWrite(srsId, text).getBytes();
    }

    public static byte[] wkb(GeoPackageGeometryData geometryData) throws IOException {
        if (geometryData.getBytes() == null) {
            geometryData.toBytes();
        }
        return geometryData.getWkb();
    }

    public static byte[] wkb(Geometry geometry) throws IOException {
        return GeoPackageGeometryData.createAndWrite(geometry).getWkb();
    }

    public static byte[] wkb(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.create(bytes).getWkb();
    }

    public static byte[] wkbFromWkt(String text) throws IOException {
        return GeoPackageGeometryData.createFromWktAndWrite(text).getWkb();
    }

    public static String wkt(GeoPackageGeometryData geometryData) throws IOException {
        return geometryData.getWkt();
    }

    public static String wkt(Geometry geometry) throws IOException {
        return GeoPackageGeometryData.create(geometry).getWkt();
    }

    public static String wkt(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.create(bytes).getWkt();
    }

    public static String wktFromWkb(byte[] bytes) throws IOException {
        return GeoPackageGeometryData.createFromWkb(bytes).getWkt();
    }

    public GeoPackageGeometryData() {
        this(defaultSrsId);
    }

    public GeoPackageGeometryData(Geometry geometry) {
        this(geometry, false);
    }

    public GeoPackageGeometryData(Geometry geometry, boolean buildEnvelope) {
        this();
        this.setGeometry(geometry);
        if (buildEnvelope) {
            this.buildEnvelope();
        }
    }

    public GeoPackageGeometryData(long srsId) {
        this.srsId = (int)srsId;
    }

    public GeoPackageGeometryData(long srsId, Geometry geometry) {
        this(srsId, geometry, false);
    }

    public GeoPackageGeometryData(long srsId, Geometry geometry, boolean buildEnvelope) {
        this(srsId);
        this.setGeometry(geometry);
        if (buildEnvelope) {
            this.buildEnvelope();
        }
    }

    public GeoPackageGeometryData(Geometry geometry, GeometryEnvelope envelope) {
        this();
        this.setGeometry(geometry);
        this.setEnvelope(envelope);
    }

    public GeoPackageGeometryData(long srsId, Geometry geometry, GeometryEnvelope envelope) {
        this(srsId);
        this.setGeometry(geometry);
        this.setEnvelope(envelope);
    }

    public GeoPackageGeometryData(GeoPackageGeometryData geometryData) {
        this.setSrsId(geometryData.getSrsId());
        Geometry geometry = geometryData.getGeometry();
        if (geometry != null) {
            geometry = geometry.copy();
        }
        this.setGeometry(geometry);
        GeometryEnvelope envelope = geometryData.getEnvelope();
        if (envelope != null) {
            envelope = envelope.copy();
        }
        this.setEnvelope(envelope);
        byte[] bytes = geometryData.getBytes();
        if (bytes != null) {
            bytes = Arrays.copyOf(bytes, bytes.length);
        }
        this.bytes = bytes;
        this.wkbGeometryIndex = geometryData.wkbGeometryIndex;
        this.setByteOrder(geometryData.getByteOrder());
    }

    public GeoPackageGeometryData(byte[] bytes) {
        this.fromBytes(bytes);
    }

    public void fromBytes(byte[] bytes) {
        this.bytes = bytes;
        ByteReader reader = new ByteReader(bytes);
        String magic = null;
        try {
            magic = reader.readString(2);
        }
        catch (IOException e) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry magic number character encoding: Expected: GP", e);
        }
        if (!magic.equals("GP")) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry magic number: " + magic + ", Expected: " + "GP");
        }
        try {
            byte version = reader.readByte();
            if (version != 0) {
                throw new GeoPackageException("Unexpected GeoPackage Geometry version: " + version + ", Expected: " + 0);
            }
            byte flags = reader.readByte();
            int envelopeIndicator = this.readFlags(flags);
            reader.setByteOrder(this.byteOrder);
            this.srsId = reader.readInt();
            this.envelope = this.readEnvelope(envelopeIndicator, reader);
        }
        catch (IOException e) {
            throw new GeoPackageException("Failed to read the GeoPackage geometry header", e);
        }
        this.wkbGeometryIndex = reader.getNextByte();
        if (!this.empty) {
            try {
                this.geometry = GeometryReader.readGeometry((ByteReader)reader, (GeometryFilter)geometryFilter);
            }
            catch (IOException e) {
                throw new GeoPackageException("Failed to read the WKB geometry", e);
            }
        }
        reader.close();
    }

    public byte[] toBytes() throws IOException {
        ByteWriter writer = new ByteWriter();
        writer.writeString("GP");
        writer.writeByte((byte)0);
        byte flags = this.buildFlagsByte();
        writer.writeByte(flags);
        writer.setByteOrder(this.byteOrder);
        writer.writeInt(this.srsId);
        this.writeEnvelope(writer);
        this.wkbGeometryIndex = writer.size();
        if (!this.empty) {
            GeometryWriter.writeGeometry((ByteWriter)writer, (Geometry)this.geometry);
        }
        this.bytes = writer.getBytes();
        writer.close();
        return this.bytes;
    }

    private int readFlags(byte flags) {
        int reserved7 = flags >> 7 & 1;
        int reserved6 = flags >> 6 & 1;
        if (reserved7 != 0 || reserved6 != 0) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry flags. Flag bit 7 and 6 should both be 0, 7=" + reserved7 + ", 6=" + reserved6);
        }
        int binaryType = flags >> 5 & 1;
        this.extended = binaryType == 1;
        int emptyValue = flags >> 4 & 1;
        this.empty = emptyValue == 1;
        int envelopeIndicator = flags >> 1 & 7;
        if (envelopeIndicator > 4) {
            throw new GeoPackageException("Unexpected GeoPackage Geometry flags. Envelope contents indicator must be between 0 and 4. Actual: " + envelopeIndicator);
        }
        int byteOrderValue = flags & 1;
        this.byteOrder = byteOrderValue == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        return envelopeIndicator;
    }

    private byte buildFlagsByte() {
        byte flag = 0;
        int binaryType = this.extended ? 1 : 0;
        flag = (byte)(flag + (binaryType << 5));
        int emptyValue = this.empty ? 1 : 0;
        flag = (byte)(flag + (emptyValue << 4));
        int envelopeIndicator = this.envelope == null ? 0 : GeoPackageGeometryData.getIndicator(this.envelope);
        flag = (byte)(flag + (envelopeIndicator << 1));
        int byteOrderValue = this.byteOrder == ByteOrder.BIG_ENDIAN ? 0 : 1;
        flag = (byte)(flag + byteOrderValue);
        return flag;
    }

    private GeometryEnvelope readEnvelope(int envelopeIndicator, ByteReader reader) throws IOException {
        GeometryEnvelope envelope = null;
        if (envelopeIndicator > 0) {
            double minX = reader.readDouble();
            double maxX = reader.readDouble();
            double minY = reader.readDouble();
            double maxY = reader.readDouble();
            boolean hasZ = false;
            Double minZ = null;
            Double maxZ = null;
            boolean hasM = false;
            Double minM = null;
            Double maxM = null;
            if (envelopeIndicator == 2 || envelopeIndicator == 4) {
                hasZ = true;
                minZ = reader.readDouble();
                maxZ = reader.readDouble();
            }
            if (envelopeIndicator == 3 || envelopeIndicator == 4) {
                hasM = true;
                minM = reader.readDouble();
                maxM = reader.readDouble();
            }
            envelope = new GeometryEnvelope(hasZ, hasM);
            envelope.setMinX(minX);
            envelope.setMaxX(maxX);
            envelope.setMinY(minY);
            envelope.setMaxY(maxY);
            if (hasZ) {
                envelope.setMinZ(minZ);
                envelope.setMaxZ(maxZ);
            }
            if (hasM) {
                envelope.setMinM(minM);
                envelope.setMaxM(maxM);
            }
        }
        return envelope;
    }

    private void writeEnvelope(ByteWriter writer) throws IOException {
        if (this.envelope != null) {
            writer.writeDouble(this.envelope.getMinX());
            writer.writeDouble(this.envelope.getMaxX());
            writer.writeDouble(this.envelope.getMinY());
            writer.writeDouble(this.envelope.getMaxY());
            if (this.envelope.hasZ()) {
                writer.writeDouble(this.envelope.getMinZ().doubleValue());
                writer.writeDouble(this.envelope.getMaxZ().doubleValue());
            }
            if (this.envelope.hasM()) {
                writer.writeDouble(this.envelope.getMinM().doubleValue());
                writer.writeDouble(this.envelope.getMaxM().doubleValue());
            }
        }
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getSrsId() {
        return this.srsId;
    }

    public GeometryEnvelope getEnvelope() {
        return this.envelope;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setSrsId(int srsId) {
        this.srsId = srsId;
    }

    public void setEnvelope(GeometryEnvelope envelope) {
        this.envelope = envelope;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
        boolean bl = this.empty = geometry == null;
        if (geometry != null) {
            this.extended = GeometryExtensions.isNonStandard(geometry.getGeometryType());
        }
    }

    public byte[] setGeometryToBytes(Geometry geometry) throws IOException {
        return this.setGeometryToBytes(geometry, false);
    }

    public byte[] setGeometryAndBuildEnvelopeToBytes(Geometry geometry) throws IOException {
        return this.setGeometryToBytes(geometry, true);
    }

    private byte[] setGeometryToBytes(Geometry geometry, boolean buildEnvelope) throws IOException {
        this.setGeometry(geometry);
        if (buildEnvelope) {
            this.buildEnvelope();
        }
        return this.toBytes();
    }

    public void setGeometryFromWkb(byte[] bytes) throws IOException {
        this.setGeometry(GeoPackageGeometryData.createGeometryFromWkb(bytes));
    }

    public void setGeometryFromWkt(String text) throws IOException {
        this.setGeometry(GeoPackageGeometryData.createGeometryFromWkt(text));
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getHeaderBytes() {
        byte[] headerBytes = null;
        if (this.bytes != null) {
            headerBytes = new byte[this.wkbGeometryIndex];
            System.arraycopy(this.bytes, 0, headerBytes, 0, this.wkbGeometryIndex);
        }
        return headerBytes;
    }

    public ByteBuffer getHeaderByteBuffer() {
        ByteBuffer buffer = null;
        if (this.bytes != null) {
            buffer = ByteBuffer.wrap(this.bytes, 0, this.wkbGeometryIndex).order(this.byteOrder);
        }
        return buffer;
    }

    public byte[] getWkb() {
        byte[] wkbBytes = null;
        if (this.bytes != null) {
            int wkbByteCount = this.bytes.length - this.wkbGeometryIndex;
            wkbBytes = new byte[wkbByteCount];
            System.arraycopy(this.bytes, this.wkbGeometryIndex, wkbBytes, 0, wkbByteCount);
        }
        return wkbBytes;
    }

    public ByteBuffer getWkbBuffer() {
        ByteBuffer buffer = null;
        if (this.bytes != null) {
            buffer = ByteBuffer.wrap(this.bytes, this.wkbGeometryIndex, this.bytes.length - this.wkbGeometryIndex).order(this.byteOrder);
        }
        return buffer;
    }

    public int getWkbGeometryIndex() {
        return this.wkbGeometryIndex;
    }

    public String getWkt() {
        String wkt = null;
        if (this.geometry != null) {
            try {
                wkt = mil.nga.sf.wkt.GeometryWriter.writeGeometry((Geometry)this.geometry);
            }
            catch (IOException e) {
                throw new GeoPackageException("Failed to write the geometry WKT", e);
            }
        }
        return wkt;
    }

    public GeometryEnvelope getOrBuildEnvelope() {
        GeometryEnvelope envelope = this.getEnvelope();
        if (envelope == null) {
            envelope = this.buildEnvelope();
        }
        return envelope;
    }

    public GeometryEnvelope buildEnvelope() {
        GeometryEnvelope envelope = null;
        Geometry geometry = this.getGeometry();
        if (geometry != null) {
            envelope = GeometryEnvelopeBuilder.buildEnvelope((Geometry)geometry);
        }
        this.setEnvelope(envelope);
        return envelope;
    }

    public static int getIndicator(GeometryEnvelope envelope) {
        int indicator = 1;
        if (envelope.hasZ()) {
            ++indicator;
        }
        if (envelope.hasM()) {
            indicator += 2;
        }
        return indicator;
    }

    public GeoPackageGeometryData transform(ProjectionTransform transform) {
        return this.transform(GeometryTransform.create((ProjectionTransform)transform));
    }

    public GeoPackageGeometryData transform(GeometryTransform transform) {
        GeoPackageGeometryData transformed = this;
        if (transform.isSameProjection()) {
            transformed = new GeoPackageGeometryData(transformed);
        } else {
            GeometryEnvelope envelope;
            Geometry geometry = this.getGeometry();
            if (geometry != null) {
                geometry = transform.transform(geometry);
            }
            if ((envelope = this.getEnvelope()) != null) {
                envelope = transform.transform(envelope);
            }
            transformed = new GeoPackageGeometryData((long)this.getSrsId(), geometry, envelope);
        }
        return transformed;
    }

    private static GeoPackageGeometryData writeBytes(GeoPackageGeometryData geometryData) throws IOException {
        geometryData.toBytes();
        return geometryData;
    }
}

