/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;

public class DateConverter {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT2 = "yyyy/MM/dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATETIME_FORMAT2 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String FUNCTION_DATE = "date";
    public static final String FUNCTION_TIME = "time";
    public static final String FUNCTION_DATETIME = "datetime";
    public static final String FUNCTION_JULIANDAY = "julianday";
    public static final String FUNCTION_STRFTIME = "strftime";
    private final List<SimpleDateFormat> formatters = new ArrayList<SimpleDateFormat>();

    public static DateConverter converter(GeoPackageDataType type) {
        DateConverter converter = null;
        switch (type) {
            case DATE: {
                converter = DateConverter.dateConverter();
                break;
            }
            case DATETIME: {
                converter = DateConverter.dateTimeConverter();
                break;
            }
            default: {
                throw new GeoPackageException("Not a date data type: " + type);
            }
        }
        return converter;
    }

    public static DateConverter dateConverter() {
        return new DateConverter(DATE_FORMAT, DATE_FORMAT2);
    }

    public static DateConverter dateTimeConverter() {
        return new DateConverter(DATETIME_FORMAT, DATETIME_FORMAT2);
    }

    public static DateConverter dateConverter(String ... formats) {
        return new DateConverter(formats);
    }

    private DateConverter(String ... formats) {
        for (String format : formats) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.formatters.add(sdf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue(Date date) {
        String value = null;
        if (date != null) {
            SimpleDateFormat sdf;
            SimpleDateFormat simpleDateFormat = sdf = this.formatters.get(0);
            synchronized (simpleDateFormat) {
                value = sdf.format(date);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date dateValue(String date) {
        Date value = null;
        if (date != null) {
            ParseException exception = null;
            for (SimpleDateFormat sdf : this.formatters) {
                try {
                    SimpleDateFormat simpleDateFormat = sdf;
                    synchronized (simpleDateFormat) {
                        value = sdf.parse(date);
                        break;
                    }
                }
                catch (ParseException e) {
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (value == null) {
                throw new GeoPackageException("Failed to parse date string: " + date, exception);
            }
        }
        return value;
    }

    public static boolean isFunction(String value) {
        boolean function = false;
        if (value != null) {
            function = (value = value.trim().toLowerCase()).startsWith(FUNCTION_DATE) || value.startsWith(FUNCTION_TIME) || value.startsWith(FUNCTION_DATETIME) || value.startsWith(FUNCTION_JULIANDAY) || value.startsWith(FUNCTION_STRFTIME);
        }
        return function;
    }
}

