/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.matrix;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrix.TileMatrixKey;

public class TileMatrixDao
extends GeoPackageDao<TileMatrix, TileMatrixKey> {
    public static TileMatrixDao create(GeoPackageCore geoPackage) {
        return TileMatrixDao.create(geoPackage.getDatabase());
    }

    public static TileMatrixDao create(GeoPackageCoreConnection db) {
        return (TileMatrixDao)((Object)GeoPackageDao.createDao(db, TileMatrix.class));
    }

    public TileMatrixDao(ConnectionSource connectionSource, Class<TileMatrix> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public TileMatrix queryForId(TileMatrixKey key) throws SQLException {
        TileMatrix tileMatrix = null;
        if (key != null) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("table_name", key.getTableName());
            fieldValues.put("zoom_level", key.getZoomLevel());
            List results = this.queryForFieldValues(fieldValues);
            if (!results.isEmpty()) {
                if (results.size() > 1) {
                    throw new SQLException("More than one TileMatrix returned for key. Table Name: " + key.getTableName() + ", Zoom Level: " + key.getZoomLevel());
                }
                tileMatrix = (TileMatrix)results.get(0);
            }
        }
        return tileMatrix;
    }

    public TileMatrixKey extractId(TileMatrix data) throws SQLException {
        return data.getId();
    }

    public boolean idExists(TileMatrixKey id) throws SQLException {
        return this.queryForId(id) != null;
    }

    public TileMatrix queryForSameId(TileMatrix data) throws SQLException {
        return this.queryForId(data.getId());
    }

    public int updateId(TileMatrix data, TileMatrixKey newId) throws SQLException {
        int count = 0;
        TileMatrix readData = this.queryForId(data.getId());
        if (readData != null && newId != null) {
            readData.setId(newId);
            count = this.update(readData);
        }
        return count;
    }

    public int delete(TileMatrix data) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("table_name", (Object)data.getTableName()).and().eq("zoom_level", (Object)data.getZoomLevel());
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public int deleteById(TileMatrixKey id) throws SQLException {
        TileMatrix tileMatrix;
        int count = 0;
        if (id != null && (tileMatrix = this.queryForId(id)) != null) {
            count = this.delete(tileMatrix);
        }
        return count;
    }

    public int deleteIds(Collection<TileMatrixKey> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (TileMatrixKey id : idCollection) {
                count += this.deleteById(id);
            }
        }
        return count;
    }

    public int deleteByTableName(String table) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("table_name", (Object)table);
        return this.delete(db.prepare());
    }

    public int update(TileMatrix tileMatrix) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("matrix_width", (Object)tileMatrix.getMatrixWidth());
        ub.updateColumnValue("matrix_height", (Object)tileMatrix.getMatrixHeight());
        ub.updateColumnValue("tile_width", (Object)tileMatrix.getTileWidth());
        ub.updateColumnValue("tile_height", (Object)tileMatrix.getTileHeight());
        ub.updateColumnValue("pixel_x_size", (Object)tileMatrix.getPixelXSize());
        ub.updateColumnValue("pixel_y_size", (Object)tileMatrix.getPixelYSize());
        ub.where().eq("table_name", (Object)tileMatrix.getTableName()).and().eq("zoom_level", (Object)tileMatrix.getZoomLevel());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }
}

