/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.user.ColumnValue;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserColumns;
import mil.nga.geopackage.user.UserTable;

public abstract class UserCoreRow<TColumn extends UserColumn, TTable extends UserTable<TColumn>> {
    protected final TTable table;
    protected final UserColumns<TColumn> columns;
    protected final int[] columnTypes;
    protected final Object[] values;

    protected UserCoreRow(TTable table, UserColumns<TColumn> columns, int[] columnTypes, Object[] values) {
        this.table = table;
        this.columns = columns;
        this.columnTypes = columnTypes;
        this.values = values;
    }

    protected UserCoreRow(TTable table) {
        this.table = table;
        this.columns = ((UserTable)table).getUserColumns();
        this.columnTypes = new int[((UserTable)table).columnCount()];
        this.values = new Object[((UserTable)table).columnCount()];
    }

    protected UserCoreRow(UserCoreRow<TColumn, TTable> userCoreRow) {
        this.table = userCoreRow.table;
        this.columns = userCoreRow.columns;
        this.columnTypes = userCoreRow.columnTypes;
        this.values = new Object[userCoreRow.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            Object value = userCoreRow.values[i];
            if (value == null) continue;
            TColumn column = userCoreRow.getColumn(i);
            this.values[i] = this.copyValue(column, value);
        }
    }

    protected Object copyValue(TColumn column, Object value) {
        Object copyValue = value;
        switch (((UserColumn)column).getDataType()) {
            case BLOB: {
                if (value instanceof byte[]) {
                    byte[] bytes = (byte[])value;
                    copyValue = Arrays.copyOf(bytes, bytes.length);
                    break;
                }
                throw new GeoPackageException("Unsupported copy value type. column: " + ((UserColumn)column).getName() + ", value type: " + value.getClass().getName() + ", data type: " + ((UserColumn)column).getDataType());
            }
            case DATE: 
            case DATETIME: {
                if (value instanceof Date) {
                    Date date = (Date)value;
                    copyValue = new Date(date.getTime());
                    break;
                }
                if (value instanceof String) break;
                throw new GeoPackageException("Unsupported copy value type. column: " + ((UserColumn)column).getName() + ", value type: " + value.getClass().getName() + ", data type: " + ((UserColumn)column).getDataType());
            }
        }
        return copyValue;
    }

    public int columnCount() {
        return this.columns.columnCount();
    }

    public Set<Map.Entry<String, ColumnValue>> getAsMap() {
        LinkedHashSet<Map.Entry<String, ColumnValue>> result = new LinkedHashSet<Map.Entry<String, ColumnValue>>();
        for (int inx = 0; inx < this.columnCount(); ++inx) {
            result.add(new AbstractMap.SimpleEntry<String, ColumnValue>(this.getColumnName(inx), new ColumnValue(this.getValue(inx))));
        }
        return result;
    }

    public String[] getColumnNames() {
        return this.columns.getColumnNames();
    }

    public String getColumnName(int index) {
        return this.columns.getColumnName(index);
    }

    public int getColumnIndex(String columnName) {
        return this.columns.getColumnIndex(columnName);
    }

    public Object getValue(int index) {
        return this.values[index];
    }

    public Object getValue(String columnName) {
        return this.values[this.columns.getColumnIndex(columnName)];
    }

    public String getValueString(int index) {
        String stringValue = null;
        Object value = this.getValue(index);
        if (value != null) {
            stringValue = value.toString();
        }
        return stringValue;
    }

    public String getValueString(String columnName) {
        return this.getValueString(this.columns.getColumnIndex(columnName));
    }

    public Object[] getValues() {
        return this.values;
    }

    public int[] getRowColumnTypes() {
        return this.columnTypes;
    }

    public int getRowColumnType(int index) {
        return this.columnTypes[index];
    }

    public int getRowColumnType(String columnName) {
        return this.columnTypes[this.columns.getColumnIndex(columnName)];
    }

    public TTable getTable() {
        return this.table;
    }

    public UserColumns<TColumn> getColumns() {
        return this.columns;
    }

    public TColumn getColumn(int index) {
        return this.columns.getColumn(index);
    }

    public TColumn getColumn(String columnName) {
        return this.columns.getColumn(columnName);
    }

    public boolean hasColumn(String columnName) {
        return this.columns.hasColumn(columnName);
    }

    public long getId() {
        int index = this.getPkColumnIndex();
        if (index < 0) {
            StringBuilder error = new StringBuilder("Id column does not exist in ");
            if (this.columns.isCustom()) {
                error.append("custom specified table columns. ");
            }
            error.append("table: " + this.columns.getTableName());
            if (this.columns.isCustom()) {
                error.append(", columns: " + this.columns.getColumnNames());
            }
            throw new GeoPackageException(error.toString());
        }
        Object objectValue = this.getValue(index);
        if (objectValue == null) {
            throw new GeoPackageException("Row Id was null. table: " + this.columns.getTableName() + ", index: " + index + ", name: " + ((UserColumn)this.getPkColumn()).getName());
        }
        if (!(objectValue instanceof Number)) {
            throw new GeoPackageException("Row Id was not a number. table: " + this.columns.getTableName() + ", index: " + index + ", name: " + ((UserColumn)this.getPkColumn()).getName() + ", value: " + objectValue);
        }
        long id = ((Number)objectValue).longValue();
        return id;
    }

    public boolean hasIdColumn() {
        return this.getPkColumnIndex() >= 0;
    }

    public boolean hasId() {
        boolean hasId = false;
        if (this.hasIdColumn()) {
            Object objectValue = this.getValue(this.getPkColumnIndex());
            hasId = objectValue != null && objectValue instanceof Number;
        }
        return hasId;
    }

    public int getPkColumnIndex() {
        return this.columns.getPkColumnIndex();
    }

    public TColumn getPkColumn() {
        return this.columns.getPkColumn();
    }

    public void setValue(int index, Object value) {
        if (index == this.columns.getPkColumnIndex() && !this.columns.isPkModifiable()) {
            throw new GeoPackageException("Can not update the primary key of the row. Table Name: " + ((UserTable)this.table).getTableName() + ", Index: " + index + ", Name: " + ((UserTable)this.table).getPkColumnName());
        }
        this.values[index] = value;
    }

    public void setValue(String columnName, Object value) {
        this.setValue(this.getColumnIndex(columnName), value);
    }

    public void setId(long id) {
        this.setId(id, this.columns.isPkModifiable());
    }

    void setId(long id, boolean pkModifiable) {
        int index = this.getPkColumnIndex();
        if (index >= 0) {
            if (!pkModifiable) {
                throw new GeoPackageException("Can not update the primary key of the row. Table Name: " + ((UserTable)this.table).getTableName() + ", Index: " + index + ", Name: " + ((UserColumn)((UserTable)this.table).getPkColumn()).getName());
            }
            this.values[index] = id;
        }
    }

    public void resetId() {
        this.values[this.getPkColumnIndex()] = null;
    }

    protected void validateValue(TColumn column, Object value, Class<?> ... valueTypes) {
        if (this.columns.isValueValidation()) {
            GeoPackageDataType dataType = ((UserColumn)column).getDataType();
            if (dataType == null) {
                throw new GeoPackageException("Column is missing a data type. Column: " + ((UserColumn)column).getName() + ", Value: " + value + ", Type: '" + ((UserColumn)column).getType() + "', Actual Type: " + valueTypes[0].getSimpleName());
            }
            Class<?> dataTypeClass = dataType.getClassType();
            boolean valid = false;
            for (Class<?> valueType : valueTypes) {
                if (!valueType.equals(dataTypeClass)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new GeoPackageException("Illegal value. Column: " + ((UserColumn)column).getName() + ", Value: " + value + ", Expected Type: " + dataTypeClass.getSimpleName() + ", Actual Type: " + valueTypes[0].getSimpleName());
            }
        }
    }
}

