/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension;

import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;

public class CrsWktExtension
extends BaseExtension {
    public static final String NAME = "crs_wkt";
    public static final String EXTENSION_NAME = "gpkg_crs_wkt";
    public static final String DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt");
    public static final String COLUMN_NAME = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt", "column_name");
    public static final String COLUMN_DEF = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "crs_wkt", "column_def");
    private GeoPackageCoreConnection connection = null;

    public CrsWktExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
        this.connection = geoPackage.getDatabase();
    }

    public Extensions getOrCreate() {
        Extensions extension = this.getOrCreate(EXTENSION_NAME, null, null, DEFINITION, ExtensionScopeType.READ_WRITE);
        if (!this.hasColumn()) {
            this.createColumn();
        }
        return extension;
    }

    public boolean has() {
        boolean exists = this.has(EXTENSION_NAME, null, null);
        if (exists) {
            exists = this.hasColumn();
        }
        return exists;
    }

    public void updateDefinition(long srsId, String definition) {
        this.connection.execSQL("UPDATE gpkg_spatial_ref_sys SET " + COLUMN_NAME + " = '" + definition + "' WHERE srs_id = " + srsId);
    }

    public String getDefinition(long srsId) {
        String definition = (String)this.connection.querySingleTypedResult("SELECT " + COLUMN_NAME + " FROM gpkg_spatial_ref_sys WHERE srs_id = ?", new String[]{String.valueOf(srsId)});
        return definition;
    }

    private void createColumn() {
        AlterTable.addColumn(this.connection, "gpkg_spatial_ref_sys", COLUMN_NAME, COLUMN_DEF);
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.WGS_84, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.WGS_84, "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_CARTESIAN, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_CARTESIAN, "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.UNDEFINED_GEOGRAPHIC, "definition_12_063"));
        this.updateDefinition(GeoPackageProperties.getIntegerProperty(PropertyConstants.WEB_MERCATOR, "srs_id"), GeoPackageProperties.getProperty(PropertyConstants.WEB_MERCATOR, "definition_12_063"));
    }

    private boolean hasColumn() {
        boolean exists = this.connection.columnExists("gpkg_spatial_ref_sys", COLUMN_NAME);
        return exists;
    }

    public void removeExtension() {
        try {
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete CRS WKT extension. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }
}

