/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.sql.SQLException;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.io.ResourceIOUtils;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.srs.SpatialReferenceSystemDao;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;

public class GeoPackageTableCreator {
    public static final String DIRECTORY = "directory";
    public static final String SPATIAL_REFERENCE_SYSTEM = "spatial_reference_system";
    public static final String CONTENTS = "contents";
    public static final String GEOMETRY_COLUMNS = "geometry_columns";
    public static final String TILE_MATRIX_SET = "tile_matrix_set";
    public static final String TILE_MATRIX = "tile_matrix";
    public static final String EXTENSIONS = "extensions";
    public static final String SCHEMA_PATH = "schema";
    public static final String DATA_COLUMNS = "data_columns";
    public static final String DATA_COLUMN_CONSTRAINTS = "data_column_constraints";
    public static final String METADATA_PATH = "metadata";
    public static final String METADATA = "metadata";
    public static final String METADATA_REFERENCE = "metadata_reference";
    public static final String GRIDDED_PATH = "gridded";
    public static final String GRIDDED_COVERAGE = "2d_gridded_coverage";
    public static final String GRIDDED_TILE = "2d_gridded_tile";
    public static final String RELATED_PATH = "related";
    public static final String EXTENDED_RELATIONS = "extended_relations";
    public static final String RTREE = "rtree";
    private final GeoPackageCoreConnection db;

    public static String getScript(String property) {
        return GeoPackageProperties.getProperty("sql", property);
    }

    public static List<String> readScript(String property) {
        return GeoPackageTableCreator.readSQLScript(GeoPackageTableCreator.getScript(property));
    }

    public static List<String> readScript(String pathProperty, String property) {
        return GeoPackageTableCreator.readSQLScript(pathProperty, GeoPackageTableCreator.getScript(property));
    }

    public static List<String> readSQLScript(String sqlScript) {
        return GeoPackageTableCreator.readSQLScript(null, sqlScript);
    }

    public static List<String> readSQLScript(String property, String sqlScript) {
        String base = "sql";
        if (property != null) {
            base = GeoPackageProperties.buildProperty(base, property);
        }
        String path = GeoPackageProperties.getProperty(base, DIRECTORY);
        List<String> statements = ResourceIOUtils.parseSQLStatements(path, sqlScript);
        return statements;
    }

    public GeoPackageTableCreator(GeoPackageCoreConnection db) {
        this.db = db;
    }

    public GeoPackageTableCreator(GeoPackageCore geoPackage) {
        this(geoPackage.getDatabase());
    }

    public int createSpatialReferenceSystem() {
        return this.execScript(SPATIAL_REFERENCE_SYSTEM);
    }

    public int createContents() {
        return this.execScript(CONTENTS);
    }

    public int createGeometryColumns() {
        return this.execScript(GEOMETRY_COLUMNS);
    }

    public int createTileMatrixSet() {
        return this.execScript(TILE_MATRIX_SET);
    }

    public int createTileMatrix() {
        return this.execScript(TILE_MATRIX);
    }

    public int createExtensions() {
        return this.execScript(EXTENSIONS);
    }

    public int createDataColumns() {
        return this.execScript(SCHEMA_PATH, DATA_COLUMNS);
    }

    public int createDataColumnConstraints() {
        return this.execScript(SCHEMA_PATH, DATA_COLUMN_CONSTRAINTS);
    }

    public int createMetadata() {
        return this.execScript("metadata", "metadata");
    }

    public int createMetadataReference() {
        return this.execScript("metadata", METADATA_REFERENCE);
    }

    public int createGriddedCoverage() {
        return this.execScript(GRIDDED_PATH, GRIDDED_COVERAGE);
    }

    public int createGriddedTile() {
        return this.execScript(GRIDDED_PATH, GRIDDED_TILE);
    }

    public int createExtendedRelations() {
        return this.execScript(RELATED_PATH, EXTENDED_RELATIONS);
    }

    public int execScript() {
        return this.execScript(null);
    }

    public int execScript(String property) {
        String propertyPath = this.getProperty();
        if (propertyPath == null) {
            propertyPath = property;
        } else if (property != null) {
            propertyPath = GeoPackageProperties.buildProperty(propertyPath, property);
        }
        String sqlScript = GeoPackageTableCreator.getScript(propertyPath);
        return this.execSQLScript(sqlScript);
    }

    public int execScript(String propertyPath, String property) {
        String sqlScript = GeoPackageTableCreator.getScript(property);
        return this.execSQLScript(propertyPath, sqlScript);
    }

    public int execSQLScript(String sqlScript) {
        return this.execSQLScript(this.getProperty(), sqlScript);
    }

    public int execSQLScript(String property, String sqlScript) {
        List<String> statements = GeoPackageTableCreator.readSQLScript(property, sqlScript);
        for (String statement : statements) {
            this.db.execSQL(statement);
        }
        return statements.size();
    }

    public String getProperty() {
        String property = this.getAuthor();
        String name = this.getName();
        if (name != null) {
            property = property == null ? name : GeoPackageProperties.buildProperty(property, name);
        }
        return property;
    }

    public String getAuthor() {
        return null;
    }

    public String getName() {
        return null;
    }

    public <TColumn extends UserColumn> void createTable(UserTable<TColumn> table) {
        if (this.db.tableOrViewExists(table.getTableName())) {
            throw new GeoPackageException("Table or view already exists and can not be created: " + table.getTableName());
        }
        String sql = CoreSQLUtils.createTableSQL(table);
        this.db.execSQL(sql);
    }

    public void createRequired() {
        this.createSpatialReferenceSystem();
        this.createContents();
        SpatialReferenceSystemDao dao = SpatialReferenceSystemDao.create(this.db);
        try {
            dao.createWgs84();
            dao.createUndefinedCartesian();
            dao.createUndefinedGeographic();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Error creating default required Spatial Reference Systems", e);
        }
    }

    public void dropTable(String table) {
        CoreSQLUtils.dropTable(this.db, table);
    }

    public void dropView(String view) {
        CoreSQLUtils.dropView(this.db, view);
    }
}

