/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

public enum DGIWGRequirement {
    GEOPACKAGE_BASE("GeoPackage Base definition", "geopackage/base"),
    GEOPACKAGE_OPTIONS("GeoPackage Options definition", "geopackage/options"),
    EXTENSIONS_MANDATORY("Mandatory Extensions", "extensions/mandatory"),
    EXTENSIONS_OPTIONAL("Optional Extensions", "extensions/optional"),
    EXTENSIONS_NOT_ALLOWED("Extensions Not Allowed", "extensions/not-allowed"),
    EXTENSIONS_CONDITIONAL("Conditional Extensions", "extensions/conditional"),
    CRS_RASTER_ALLOWED("Raster CRS Allowed", "crs/raster-allowed"),
    CRS_RASTER_TILE_MATRIX_SET("CRS Raster tile matrix set", "crs/raster-tile-matrix-set"),
    CRS_2D_VECTOR("Two-Dimensional Vector CRS", "crs/2d-vector"),
    CRS_3D_VECTOR("Three-Dimensional Vector CRS", "crs/3d-vector"),
    CRS_WKT("Well Known Text for CRS", "crs/wkt"),
    CRS_COMPOUND("Compound CRS Usage", "crs/compound"),
    CRS_COMPOUND_WKT("Compound CRS Well Known Text", "crs/compound-wkt"),
    METADATA_DMF("GeoPackage Metadata DMF", "metadata/dmf"),
    METADATA_GPKG("GeoPackage Metadata document", "metadata/gpkg"),
    METADATA_ROW("Complete Row GeoPackage Metadata", "metadata/row"),
    METADATA_USER("User Row GeoPackage Metadata", "metadata/user"),
    METADATA_PRODUCT("GeoPackage Product Metadata", "metadata/product"),
    METADATA_PRODUCT_PARTIAL("GeoPackage Product Partial Metadata", "metadata/product-partial"),
    VALIDITY_DATA_VALIDITY("GeoPackage Data Validity", "validity/data-validity"),
    TILE_SIZE_MATRIX("Tile Matrix Width Height", "tile/size-matrix"),
    TILE_SIZE_DATA("Tile Pyramid Width Height", "tile/size-data"),
    ZOOM_FACTOR("Zoom level factor", "zoom/factor"),
    ZOOM_MATRIX_SETS_MULTIPLE("Tile Matrix Set with Multiple Zoom Levels", "zoom/matrix-sets-multiple"),
    ZOOM_MATRIX_SETS_ONE("Tile Matrix Set with one Zoom Level", "zoom/matrix-sets-one"),
    BBOX_CRS("Tile Matrix Set CRS Bounding box", "bbox/crs"),
    METADATA_TILE("Tile layer Metadata", "metadata/tile"),
    METADATA_FEATURE("Feature layer Metadata", "metadata/feature");

    public static final String IDENTIFIER_PREFIX = "/req/";
    private final int number = this.ordinal() + 1;
    private final String name;
    private final String identifier;

    private DGIWGRequirement(String name, String identifier) {
        this.name = name;
        this.identifier = identifier;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getFullIdentifier() {
        return IDENTIFIER_PREFIX + this.identifier;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append("Number: ").append(this.number);
        toString.append(", Name: ").append(this.name);
        toString.append(", Identifier: ").append(this.getFullIdentifier());
        return toString.toString();
    }
}

