/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.util.Arrays;
import java.util.List;
import mil.nga.geopackage.dgiwg.DGIWGRequirement;
import mil.nga.geopackage.dgiwg.DGIWGValidationKey;

public class DGIWGValidationError {
    private String table = null;
    private String column = null;
    private String value = null;
    private String constraint = null;
    private DGIWGRequirement requirement = null;
    private List<DGIWGValidationKey> primaryKeys = null;

    public DGIWGValidationError(String table, String column, String value, String constraint, DGIWGRequirement requirement) {
        this(table, value, constraint, requirement);
        this.column = column;
    }

    public DGIWGValidationError(String table, String column, Number value, String constraint, DGIWGRequirement requirement) {
        this(table, column, value != null ? value.toString() : null, constraint, requirement);
    }

    public DGIWGValidationError(String table, String column, Number value, Number constraint, DGIWGRequirement requirement) {
        this(table, column, value, constraint != null ? constraint.toString() : null, requirement);
    }

    public DGIWGValidationError(String table, String value, String constraint, DGIWGRequirement requirement) {
        this(value, constraint, requirement);
        this.table = table;
    }

    public DGIWGValidationError(String value, String constraint, DGIWGRequirement requirement) {
        this(constraint, requirement);
        this.value = value;
    }

    public DGIWGValidationError(String constraint, DGIWGRequirement requirement) {
        this.constraint = constraint;
        this.requirement = requirement;
    }

    public DGIWGValidationError(String table, String value, String constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, null, value, constraint, requirement, primaryKeys);
    }

    public DGIWGValidationError(String table, String column, String value, String constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, column, value, constraint, requirement);
        if (primaryKeys != null && primaryKeys.length > 0 && primaryKeys[0] != null) {
            this.primaryKeys = Arrays.asList(primaryKeys);
        }
    }

    public DGIWGValidationError(String table, String column, Number value, String constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, column, value != null ? value.toString() : null, constraint, requirement, primaryKeys);
    }

    public DGIWGValidationError(String table, String column, Number value, Number constraint, DGIWGRequirement requirement, DGIWGValidationKey ... primaryKeys) {
        this(table, column, value, constraint != null ? constraint.toString() : null, requirement, primaryKeys);
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String getValue() {
        return this.value;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public DGIWGRequirement getRequirement() {
        return this.requirement;
    }

    public List<DGIWGValidationKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        if (this.table != null) {
            toString.append("Table: ").append(this.table);
        }
        if (this.column != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Column: ").append(this.column);
        }
        if (this.value != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Value: ").append(this.value);
        }
        if (this.primaryKeys != null) {
            for (DGIWGValidationKey key : this.primaryKeys) {
                if (key.getColumn().equalsIgnoreCase(this.column)) continue;
                if (toString.length() > 0) {
                    toString.append(", ");
                }
                toString.append(key);
            }
        }
        if (this.constraint != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Constraint: ").append(this.constraint);
        }
        if (this.requirement != null) {
            if (toString.length() > 0) {
                toString.append(", ");
            }
            toString.append("Requirement: [").append((Object)this.requirement).append("]");
        }
        return toString.toString();
    }
}

