/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import mil.nga.geopackage.db.DateConverter;
import mil.nga.geopackage.io.GeoPackageIOUtils;

public class GeoPackageFileName {
    public static final String DELIMITER_ELEMENTS = "_";
    public static final String DELIMITER_WORDS = "-";
    public static final String DELIMITER_SCALE = ":";
    public static final String VERSION_PREFIX = "v";
    public static final String DATE_FORMAT = "ddMMMyyyy";
    private String producer;
    private String dataProduct;
    private String geographicCoverageArea;
    private String zoomLevels;
    private Integer zoomLevel1;
    private Integer zoomLevel2;
    private String version;
    private Integer majorVersion;
    private Integer minorVersion;
    private String creationDateText;
    private Date creationDate;
    private List<String> additional;

    public GeoPackageFileName() {
    }

    public GeoPackageFileName(File file) {
        this(file.getName());
    }

    public GeoPackageFileName(String name) {
        name = GeoPackageIOUtils.getPathFileNameWithoutExtension(name);
        String[] elements = name.split(DELIMITER_ELEMENTS);
        block9: for (int i = 0; i < elements.length; ++i) {
            String value = elements[i];
            switch (i) {
                case 0: {
                    this.producer = this.delimitersToSpaces(value);
                    continue block9;
                }
                case 1: {
                    this.dataProduct = this.delimitersToSpaces(value);
                    continue block9;
                }
                case 2: {
                    this.geographicCoverageArea = this.delimitersToSpaces(value);
                    continue block9;
                }
                case 3: {
                    this.setZoomLevels(value);
                    continue block9;
                }
                case 4: {
                    this.setVersion(value);
                    continue block9;
                }
                case 5: {
                    this.setCreationDateText(value);
                    continue block9;
                }
                case 6: {
                    this.additional = new ArrayList<String>();
                }
                default: {
                    this.additional.add(this.delimitersToSpaces(value));
                }
            }
        }
    }

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getDataProduct() {
        return this.dataProduct;
    }

    public void setDataProduct(String dataProduct) {
        this.dataProduct = dataProduct;
    }

    public String getGeographicCoverageArea() {
        return this.geographicCoverageArea;
    }

    public void setGeographicCoverageArea(String geographicCoverageArea) {
        this.geographicCoverageArea = geographicCoverageArea;
    }

    public String getZoomLevels() {
        return this.zoomLevels;
    }

    public void setZoomLevels(String zoomLevels) {
        this.zoomLevels = zoomLevels;
        String[] parts = zoomLevels.split(":|-");
        if (parts.length == 2) {
            String zoom1 = parts[0];
            String zoom2 = parts[1];
            Integer zoomLevel1 = this.toInteger(zoom1);
            Integer zoomLevel2 = this.toInteger(zoom2);
            if (zoomLevel1 != null && zoomLevel2 != null) {
                this.zoomLevel1 = zoomLevel1;
                this.zoomLevel2 = zoomLevel2;
                String delimiter = DELIMITER_SCALE;
                if (zoomLevel1 >= 0 && zoomLevel2 <= 28) {
                    delimiter = DELIMITER_WORDS;
                }
                this.zoomLevels = zoomLevel1 + delimiter + zoomLevel2;
            } else {
                this.zoomLevels = this.delimitersToSpaces(zoomLevels);
            }
        } else {
            this.zoomLevels = this.delimitersToSpaces(zoomLevels);
        }
    }

    public Integer getZoomLevel1() {
        return this.zoomLevel1;
    }

    public boolean hasZoomLevel1() {
        return this.zoomLevel1 != null;
    }

    public Integer getZoomLevel2() {
        return this.zoomLevel2;
    }

    public boolean hasZoomLevel2() {
        return this.zoomLevel2 != null;
    }

    public void setZoomLevelRange(int minZoom, int maxZoom) {
        this.zoomLevel1 = minZoom;
        this.zoomLevel2 = maxZoom;
        this.zoomLevels = minZoom + DELIMITER_WORDS + maxZoom;
    }

    public void setZoomLevelScale(int mapUnits, int surfaceUnits) {
        this.zoomLevel1 = mapUnits;
        this.zoomLevel2 = surfaceUnits;
        this.zoomLevels = mapUnits + DELIMITER_SCALE + surfaceUnits;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        String[] parts = version.split("\\.|-");
        if (parts.length == 2) {
            String major = parts[0];
            if (major.startsWith(VERSION_PREFIX)) {
                major = major.substring(1);
            }
            String minor = parts[1];
            Integer majorVersion = this.toInteger(major);
            Integer minorVersion = this.toInteger(minor);
            if (majorVersion != null && minorVersion != null) {
                this.majorVersion = majorVersion;
                this.minorVersion = minorVersion;
                this.version = majorVersion + "." + minorVersion;
            } else {
                this.version = this.delimitersToSpaces(version);
            }
        } else {
            this.version = this.delimitersToSpaces(version);
        }
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public boolean hasMajorVersion() {
        return this.majorVersion != null;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public boolean hasMinorVersion() {
        return this.minorVersion != null;
    }

    public void setVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.version = majorVersion + "." + minorVersion;
    }

    public String getCreationDateText() {
        return this.creationDateText;
    }

    public void setCreationDateText(String creationDateText) {
        this.creationDateText = creationDateText;
        DateConverter converter = this.getDateConverter();
        this.creationDate = converter.dateValue(creationDateText);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        DateConverter converter = this.getDateConverter();
        this.creationDateText = converter.stringValue(creationDate);
        if (this.creationDateText != null) {
            this.creationDateText = this.creationDateText.toUpperCase();
        }
    }

    public List<String> getAdditional() {
        return this.additional;
    }

    public boolean hasAdditional() {
        return this.additional != null && this.additional.isEmpty();
    }

    public void setAdditional(List<String> additional) {
        this.additional = additional;
    }

    public void addAdditional(String additional) {
        if (this.additional == null) {
            this.additional = new ArrayList<String>();
        }
        this.additional.add(additional);
    }

    public boolean isInformative() {
        return this.producer != null && this.dataProduct != null && this.geographicCoverageArea != null && this.zoomLevels != null && this.version != null && this.creationDateText != null;
    }

    public String getName() {
        return this.toString();
    }

    public String getNameWithExtension() {
        return GeoPackageIOUtils.addFileExtension(this.getName(), "gpkg");
    }

    public File getFile() {
        return new File(this.getNameWithExtension());
    }

    public String delimitersToSpaces(String value) {
        return value.replaceAll(DELIMITER_WORDS, " ").trim();
    }

    private Integer toInteger(String value) {
        Integer integer = null;
        if (value != null) {
            Scanner scanner = new Scanner(value);
            if (scanner.hasNextInt()) {
                scanner.next();
                if (!scanner.hasNext()) {
                    integer = Integer.parseInt(value);
                }
            }
            scanner.close();
        }
        return integer;
    }

    private DateConverter getDateConverter() {
        DateConverter converter = new DateConverter(DATE_FORMAT, "yyyy-MM-dd", "yyyy/MM/dd");
        converter.setExpected(false);
        return converter;
    }

    private void addValue(StringBuilder builder, String value) {
        if (value != null) {
            this.addDelimiter(builder);
            builder.append(value.trim().replaceAll(" ", DELIMITER_WORDS));
        }
    }

    private void addDelimiter(StringBuilder builder) {
        if (builder.length() > 0) {
            builder.append(DELIMITER_ELEMENTS);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.addValue(builder, this.producer);
        this.addValue(builder, this.dataProduct);
        this.addValue(builder, this.geographicCoverageArea);
        if (this.zoomLevel1 != null) {
            this.addDelimiter(builder);
            builder.append(this.zoomLevel1);
            if (this.zoomLevel2 != null) {
                builder.append(DELIMITER_WORDS);
                builder.append(this.zoomLevel2);
            }
        } else {
            this.addValue(builder, this.zoomLevels);
        }
        if (this.majorVersion != null) {
            this.addDelimiter(builder);
            builder.append(VERSION_PREFIX);
            builder.append(this.majorVersion);
            if (this.minorVersion != null) {
                builder.append(DELIMITER_WORDS);
                builder.append(this.minorVersion);
            }
        } else {
            this.addValue(builder, this.version);
        }
        this.addValue(builder, this.creationDateText);
        if (this.additional != null) {
            for (String value : this.additional) {
                this.addValue(builder, value);
            }
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.toString().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoPackageFileName other = (GeoPackageFileName)obj;
        return this.toString().equals(other.toString());
    }
}

