/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.geom;

import mil.nga.geopackage.geom.GeoPackageGeometryData;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.sf.Geometry;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.GeometryTransform;
import mil.nga.sf.util.GeometryUtils;
import org.locationtech.proj4j.units.Units;

public class GeometryCrop {
    public static void crop(Projection projection, GeoPackageGeometryData geometryData) {
        GeometryEnvelope envelope = GeometryCrop.envelope(projection);
        GeometryCrop.crop(projection, geometryData, envelope);
    }

    public static void crop(Projection projection, GeoPackageGeometryData geometryData, GeometryEnvelope envelope) {
        if (geometryData != null && !geometryData.isEmpty()) {
            Geometry geometry = geometryData.getGeometry();
            Geometry bounded = GeometryCrop.crop(projection, geometry, envelope);
            geometryData.setGeometry(bounded);
        }
    }

    public static Geometry crop(Projection projection, Geometry geometry) {
        GeometryEnvelope envelope = GeometryCrop.envelope(projection);
        return GeometryCrop.crop(projection, geometry, envelope);
    }

    public static Geometry crop(Projection projection, Geometry geometry, GeometryEnvelope envelope) {
        GeometryTransform transform = null;
        if (!projection.isUnit(Units.METRES)) {
            transform = new GeometryTransform(projection, ProjectionFactory.getProjection((long)3857L));
            GeometryUtils.boundWGS84Transformable((Geometry)geometry);
            geometry = transform.transform(geometry);
            envelope = transform.transform(envelope);
        }
        Geometry cropped = GeometryUtils.crop((Geometry)geometry, (GeometryEnvelope)envelope);
        if (transform != null) {
            transform = transform.getInverseTransformation();
            cropped = transform.transform(cropped);
            GeometryUtils.minimizeWGS84((Geometry)cropped);
        }
        return cropped;
    }

    public static GeometryEnvelope envelope(Projection projection) {
        GeometryEnvelope envelope = null;
        envelope = projection.isUnit(Units.METRES) ? GeometryUtils.webMercatorEnvelope() : GeometryUtils.wgs84EnvelopeWithWebMercator();
        return envelope;
    }
}

