/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.contents;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;

public enum ContentsDataType {
    FEATURES,
    TILES,
    ATTRIBUTES;

    private static final Logger log;
    private static final Set<String> coreTypes;
    private static final Map<String, ContentsDataType> types;

    public String getName() {
        return this.toString();
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static ContentsDataType fromName(String name) {
        String lowerName;
        ContentsDataType dataType = null;
        if (name != null && (dataType = types.get(lowerName = name.toLowerCase())) == null && !types.containsKey(lowerName)) {
            String value = GeoPackageProperties.getProperty(false, PropertyConstants.CONTENTS_DATA_TYPE, name);
            if (value != null && (dataType = types.get(value.toLowerCase())) == null) {
                log.log(Level.WARNING, "Unsupported configured data type: " + value + ", for contents data type name: " + name);
            }
            types.put(lowerName, dataType);
        }
        return dataType;
    }

    public static boolean isType(String name) {
        return ContentsDataType.fromName(name) != null;
    }

    public static ContentsDataType fromCoreName(String name) {
        ContentsDataType dataType = null;
        if (ContentsDataType.isCoreType(name)) {
            dataType = types.get(name.toLowerCase());
        }
        return dataType;
    }

    public static boolean isCoreType(String name) {
        boolean coreType = false;
        if (name != null) {
            coreType = coreTypes.contains(name.toLowerCase());
        }
        return coreType;
    }

    public static void setType(String name, ContentsDataType type) {
        if (name != null) {
            String lowerName = name.toLowerCase();
            ContentsDataType dataType = types.get(lowerName);
            if (dataType == null) {
                types.put(lowerName, type);
            } else if (dataType != type) {
                if (coreTypes.contains(lowerName)) {
                    throw new GeoPackageException("Core contents data type name '" + name + "' can not be changed to type '" + type.getName() + "'");
                }
                log.log(Level.WARNING, "Changed contents data type name '" + name + "' from type '" + dataType.getName() + "' to type '" + type.getName() + "'");
                types.put(lowerName, type);
            }
        }
    }

    public static boolean isType(String name, ContentsDataType type) {
        return ContentsDataType.isType(name, type, false);
    }

    public static boolean isType(String name, ContentsDataType type, boolean matchUnknown) {
        ContentsDataType dataType = ContentsDataType.fromName(name);
        boolean isType = dataType != null ? dataType == type : matchUnknown;
        return isType;
    }

    public static boolean isFeaturesType(String name) {
        return ContentsDataType.isFeaturesType(name, false);
    }

    public static boolean isFeaturesType(String name, boolean matchUnknown) {
        return ContentsDataType.isType(name, FEATURES, matchUnknown);
    }

    public static boolean isTilesType(String name) {
        return ContentsDataType.isTilesType(name, false);
    }

    public static boolean isTilesType(String name, boolean matchUnknown) {
        return ContentsDataType.isType(name, TILES, matchUnknown);
    }

    public static boolean isAttributesType(String name) {
        return ContentsDataType.isAttributesType(name, false);
    }

    public static boolean isAttributesType(String name, boolean matchUnknown) {
        return ContentsDataType.isType(name, ATTRIBUTES, matchUnknown);
    }

    static {
        log = Logger.getLogger(ContentsDataType.class.getName());
        coreTypes = new HashSet<String>();
        types = new HashMap<String, ContentsDataType>();
        for (ContentsDataType dataType : ContentsDataType.values()) {
            String name = dataType.getName();
            coreTypes.add(name);
            types.put(name, dataType);
        }
    }
}

