/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.util.LinkedHashSet;
import java.util.Set;
import mil.nga.geopackage.contents.ContentsDataType;

public enum DataType {
    FEATURES_2D(ContentsDataType.FEATURES, 2),
    FEATURES_3D(ContentsDataType.FEATURES, 3),
    TILES_2D(ContentsDataType.TILES, 2),
    TILES_3D(ContentsDataType.TILES, 3);

    private final ContentsDataType dataType;
    private final int dimension;

    private DataType(ContentsDataType dataType, int dimension) {
        this.dataType = dataType;
        this.dimension = dimension;
    }

    public ContentsDataType getDataType() {
        return this.dataType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isFeatures() {
        return this.dataType == ContentsDataType.FEATURES;
    }

    public boolean isTiles() {
        return this.dataType == ContentsDataType.TILES;
    }

    public boolean is2D() {
        return this.dimension == 2;
    }

    public boolean is3D() {
        return this.dimension == 3;
    }

    public byte getZ() {
        return (byte)(this.dimension - 2);
    }

    public static Set<DataType> getDataTypes(ContentsDataType type) {
        LinkedHashSet<DataType> dataTypes = new LinkedHashSet<DataType>();
        for (DataType dataType : DataType.values()) {
            if (dataType.getDataType() != type) continue;
            dataTypes.add(dataType);
        }
        return dataTypes;
    }
}

