/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga.scale;

import com.j256.ormlite.dao.Dao;
import java.sql.SQLException;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.nga.scale.TileScaling;
import mil.nga.geopackage.extension.nga.scale.TileScalingDao;
import mil.nga.geopackage.extension.nga.scale.TileScalingTableCreator;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.geopackage.user.UserCoreDao;

public class TileTableScaling
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "nga";
    public static final String EXTENSION_NAME_NO_AUTHOR = "tile_scaling";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("nga", "tile_scaling");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "tile_scaling");
    private final String tableName;
    private final TileScalingDao tileScalingDao;

    public TileTableScaling(GeoPackageCore geoPackage, TileMatrixSet tileMatrixSet) {
        this(geoPackage, tileMatrixSet.getTableName());
    }

    public TileTableScaling(GeoPackageCore geoPackage, TileMatrix tileMatrix) {
        this(geoPackage, tileMatrix.getTableName());
    }

    public TileTableScaling(GeoPackageCore geoPackage, UserCoreDao<?, ?, ?, ?> tileDao) {
        this(geoPackage, tileDao.getTableName());
    }

    public TileTableScaling(GeoPackageCore geoPackage, String tableName) {
        super(geoPackage);
        this.tableName = tableName;
        this.tileScalingDao = this.getTileScalingDao();
    }

    @Override
    public GeoPackageCore getGeoPackage() {
        return this.geoPackage;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TileScalingDao getDao() {
        return this.tileScalingDao;
    }

    public boolean has() {
        boolean exists = false;
        try {
            exists = this.has(EXTENSION_NAME, this.tableName, null) && this.tileScalingDao.isTableExists() && this.tileScalingDao.idExists(this.tableName);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check for tile scaling for GeoPackage: " + this.geoPackage.getName() + ", Tile Table: " + this.tableName, e);
        }
        return exists;
    }

    public TileScaling get() {
        TileScaling tileScaling = null;
        if (this.has()) {
            try {
                tileScaling = (TileScaling)this.tileScalingDao.queryForId(this.tableName);
            }
            catch (SQLException e) {
                throw new GeoPackageException("Failed to query for tile scaling for GeoPackage: " + this.geoPackage.getName() + ", Tile Table: " + this.tableName, e);
            }
        }
        return tileScaling;
    }

    public boolean create(TileScaling tileScaling) {
        return this.createOrUpdate(tileScaling);
    }

    public boolean update(TileScaling tileScaling) {
        return this.createOrUpdate(tileScaling);
    }

    public boolean createOrUpdate(TileScaling tileScaling) {
        boolean success = false;
        tileScaling.setTableName(this.tableName);
        this.getOrCreateExtension();
        try {
            Dao.CreateOrUpdateStatus status;
            if (!this.tileScalingDao.isTableExists()) {
                this.createTileScalingTable();
            }
            success = (status = this.tileScalingDao.createOrUpdate(tileScaling)).isCreated() || status.isUpdated();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to create or update tile scaling for GeoPackage: " + this.geoPackage.getName() + ", Tile Table: " + this.tableName, e);
        }
        return success;
    }

    public boolean delete() {
        boolean deleted = false;
        try {
            if (this.tileScalingDao.isTableExists()) {
                boolean bl = deleted = this.tileScalingDao.deleteById(this.tableName) > 0;
            }
            if (this.extensionsDao.isTableExists()) {
                deleted = this.extensionsDao.deleteByExtension(EXTENSION_NAME, this.tableName) > 0 || deleted;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete tile table scaling for GeoPackage: " + this.geoPackage.getName() + ", Table: " + this.tableName, e);
        }
        return deleted;
    }

    private Extensions getOrCreateExtension() {
        Extensions extension = this.getOrCreate(EXTENSION_NAME, this.tableName, null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public Extensions getExtension() {
        Extensions extension = this.get(EXTENSION_NAME, this.tableName, null);
        return extension;
    }

    public TileScalingDao getTileScalingDao() {
        return TileTableScaling.getTileScalingDao(this.geoPackage);
    }

    public static TileScalingDao getTileScalingDao(GeoPackageCore geoPackage) {
        return TileScalingDao.create(geoPackage);
    }

    public static TileScalingDao getTileScalingDao(GeoPackageCoreConnection db) {
        return TileScalingDao.create(db);
    }

    public boolean createTileScalingTable() {
        this.verifyWritable();
        boolean created = false;
        try {
            if (!this.tileScalingDao.isTableExists()) {
                TileScalingTableCreator tableCreator = new TileScalingTableCreator(this.geoPackage);
                created = tableCreator.createTileScaling() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + TileScaling.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }
}

