/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.user.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mil.nga.geopackage.user.UserColumns;
import mil.nga.geopackage.user.custom.UserCustomColumn;

public class UserCustomColumns
extends UserColumns<UserCustomColumn> {
    private Collection<String> requiredColumns;

    public UserCustomColumns(String tableName, List<UserCustomColumn> columns) {
        this(tableName, columns, null);
    }

    public UserCustomColumns(String tableName, List<UserCustomColumn> columns, Collection<String> requiredColumns) {
        this(tableName, columns, requiredColumns, false);
    }

    public UserCustomColumns(String tableName, List<UserCustomColumn> columns, boolean custom) {
        this(tableName, columns, null, custom);
    }

    public UserCustomColumns(String tableName, List<UserCustomColumn> columns, Collection<String> requiredColumns, boolean custom) {
        super(tableName, columns, custom);
        this.requiredColumns = requiredColumns;
        this.updateColumns();
    }

    public UserCustomColumns(UserCustomColumns userCustomColumns) {
        super(userCustomColumns);
        if (userCustomColumns.requiredColumns != null) {
            this.requiredColumns = new ArrayList<String>(userCustomColumns.requiredColumns);
        }
    }

    public UserCustomColumns copy() {
        return new UserCustomColumns(this);
    }

    @Override
    protected void updateColumns() {
        super.updateColumns();
        if (!this.isCustom() && this.requiredColumns != null && !this.requiredColumns.isEmpty()) {
            HashSet<String> search = new HashSet<String>(this.requiredColumns);
            HashMap<String, Integer> found = new HashMap<String, Integer>();
            for (UserCustomColumn column : this.getColumns()) {
                String columnName = column.getName();
                int columnIndex = column.getIndex();
                if (!search.contains(columnName)) continue;
                Integer previousIndex = (Integer)found.get(columnName);
                this.duplicateCheck(columnIndex, previousIndex, columnName);
                found.put(columnName, columnIndex);
            }
            for (String requiredColumn : search) {
                this.missingCheck((Integer)found.get(requiredColumn), requiredColumn);
            }
        }
    }

    public Collection<String> getRequiredColumns() {
        return this.requiredColumns;
    }

    public void setRequiredColumns(Collection<String> requiredColumns) {
        this.requiredColumns = requiredColumns;
    }
}

