package mil.nga.geopackage.extension.nga.properties;

/**
 * Pre-defined property names for defining GeoPackage properties
 * 
 * @author osbornb
 * @since 3.0.2
 */
public class PropertyNames {

	/**
	 * An entity responsible for making contributions to the resource
	 */
	public static final String CONTRIBUTOR = "contributor";

	/**
	 * The spatial or temporal topic of the resource, the spatial applicability
	 * of the resource, or the jurisdiction under which the resource is relevant
	 */
	public static final String COVERAGE = "coverage";

	/**
	 * Date Created - Date of creation of the resource
	 */
	public static final String CREATED = "created";

	/**
	 * An entity primarily responsible for making the resource
	 */
	public static final String CREATOR = "creator";

	/**
	 * A point or period of time associated with an event in the lifecycle of
	 * the resource
	 */
	public static final String DATE = "date";

	/**
	 * An account of the resource
	 */
	public static final String DESCRIPTION = "description";

	/**
	 * An unambiguous reference to the resource within a given context
	 */
	public static final String IDENTIFIER = "identifier";

	/**
	 * A legal document giving official permission to do something with the
	 * resource
	 */
	public static final String LICENSE = "license";

	/**
	 * Date Modified - Date on which the resource was changed
	 */
	public static final String MODIFIED = "modified";

	/**
	 * An entity responsible for making the resource available
	 */
	public static final String PUBLISHER = "publisher";

	/**
	 * A related resource that is referenced, cited, or otherwise pointed to by
	 * the described resource
	 */
	public static final String REFERENCES = "references";

	/**
	 * A related resource
	 */
	public static final String RELATION = "relation";

	/**
	 * A related resource from which the described resource is derived
	 */
	public static final String SOURCE = "source";

	/**
	 * Spatial Coverage - Spatial characteristics of the resource
	 */
	public static final String SPATIAL = "spatial";

	/**
	 * The topic of the resource
	 */
	public static final String SUBJECT = "subject";

	/**
	 * A tag or label of the resource
	 */
	public static final String TAG = "tag";

	/**
	 * Temporal Coverage - Temporal characteristics of the resource
	 */
	public static final String TEMPORAL = "temporal";

	/**
	 * A name given to the resource
	 */
	public static final String TITLE = "title";

	/**
	 * The nature or genre of the resource
	 */
	public static final String TYPE = "type";

	/**
	 * The set of identifiers constructed according to the generic syntax for
	 * Uniform Resource Identifiers as specified by the Internet Engineering
	 * Task Force
	 */
	public static final String URI = "URI";

	/**
	 * Date Valid - Date (often a range) of validity of a resource
	 */
	public static final String VALID = "valid";

	/**
	 * A version of the resource
	 */
	public static final String VERSION = "version";

}
