/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid;

import mil.nga.color.Color;
import mil.nga.grid.GridStyle;
import mil.nga.grid.Labeler;

public class BaseGrid {
    private boolean enabled;
    private int minZoom;
    private Integer maxZoom;
    private Integer linesMinZoom;
    private Integer linesMaxZoom;
    private GridStyle style = new GridStyle();
    private Labeler labeler;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public boolean hasMaxZoom() {
        return this.maxZoom != null;
    }

    public void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public boolean isWithin(int zoom) {
        return zoom >= this.minZoom && (this.maxZoom == null || zoom <= this.maxZoom);
    }

    public int getLinesMinZoom() {
        return this.linesMinZoom != null ? this.linesMinZoom.intValue() : this.getMinZoom();
    }

    public boolean hasLinesMinZoom() {
        return this.linesMinZoom != null;
    }

    public void setLinesMinZoom(Integer linesMinZoom) {
        this.linesMinZoom = linesMinZoom;
    }

    public Integer getLinesMaxZoom() {
        return this.linesMaxZoom != null ? this.linesMaxZoom : this.getMaxZoom();
    }

    public boolean hasLinesMaxZoom() {
        return this.linesMaxZoom != null;
    }

    public void setLinesMaxZoom(Integer linesMaxZoom) {
        this.linesMaxZoom = linesMaxZoom;
    }

    public boolean isLinesWithin(int zoom) {
        return !(this.linesMinZoom != null && zoom < this.linesMinZoom || this.linesMaxZoom != null && zoom > this.linesMaxZoom);
    }

    public GridStyle getStyle() {
        return this.style;
    }

    public void setStyle(GridStyle style) {
        this.style = style != null ? style : new GridStyle();
    }

    public Color getColor() {
        return this.getStyle().getColor();
    }

    public void setColor(Color color) {
        this.getStyle().setColor(color);
    }

    public double getWidth() {
        return this.getStyle().getWidth();
    }

    public void setWidth(double width) {
        this.getStyle().setWidth(width);
    }

    public Labeler getLabeler() {
        return this.labeler;
    }

    public boolean hasLabeler() {
        return this.labeler != null;
    }

    public void setLabeler(Labeler labeler) {
        this.labeler = labeler;
    }

    public boolean isLabelerWithin(int zoom) {
        return this.hasLabeler() && this.labeler.isEnabled() && this.labeler.isWithin(zoom);
    }

    public double getLabelBuffer() {
        return this.hasLabeler() ? this.labeler.getBuffer() : 0.0;
    }
}

