/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;
import mil.nga.color.Color;
import mil.nga.grid.BaseGrid;
import mil.nga.grid.BaseZoomGrids;
import mil.nga.grid.GridStyle;
import mil.nga.grid.Labeler;
import mil.nga.grid.property.GridProperties;

public abstract class BaseGrids<TGrid extends BaseGrid, TZoomGrids extends BaseZoomGrids<TGrid>> {
    protected final GridProperties properties;
    private TreeMap<Integer, TZoomGrids> zoomGrids = new TreeMap();

    public BaseGrids(GridProperties properties) {
        this.properties = properties;
    }

    public abstract double getDefaultWidth();

    public abstract Collection<TGrid> grids();

    protected abstract TZoomGrids newZoomGrids(int var1);

    protected void loadGrid(TGrid grid, String gridKey, Boolean enabled, Labeler labeler) {
        if (enabled == null && (enabled = this.properties.getBooleanProperty(false, "grids", gridKey, "enabled")) == null) {
            enabled = true;
        }
        ((BaseGrid)grid).setEnabled(enabled);
        Integer minZoom = this.properties.getIntegerProperty(false, "grids", gridKey, "min_zoom");
        if (minZoom == null) {
            minZoom = 0;
        }
        ((BaseGrid)grid).setMinZoom(minZoom);
        Integer maxZoom = this.properties.getIntegerProperty(false, "grids", gridKey, "max_zoom");
        ((BaseGrid)grid).setMaxZoom(maxZoom);
        Integer linesMinZoom = this.properties.getIntegerProperty(false, "grids", gridKey, "lines", "min_zoom");
        ((BaseGrid)grid).setLinesMinZoom(linesMinZoom);
        Integer linesMaxZoom = this.properties.getIntegerProperty(false, "grids", gridKey, "lines", "max_zoom");
        ((BaseGrid)grid).setLinesMaxZoom(linesMaxZoom);
        String colorProperty = this.properties.getProperty(false, "grids", gridKey, "color");
        Color color = colorProperty != null ? Color.color((String)colorProperty) : Color.black();
        ((BaseGrid)grid).setColor(color);
        Double width = this.properties.getDoubleProperty(false, "grids", gridKey, "width");
        if (width == null) {
            width = this.getDefaultWidth();
        }
        ((BaseGrid)grid).setWidth(width);
        if (labeler != null) {
            this.loadLabeler(labeler, gridKey);
        }
        ((BaseGrid)grid).setLabeler(labeler);
    }

    private void loadLabeler(Labeler labeler, String gridKey) {
        Double buffer;
        Double textSize;
        String color;
        Integer maxZoom;
        Boolean enabled = this.properties.getBooleanProperty(false, "grids", gridKey, "labeler", "enabled");
        labeler.setEnabled(enabled != null && enabled != false);
        Integer minZoom = this.properties.getIntegerProperty(false, "grids", gridKey, "labeler", "min_zoom");
        if (minZoom != null) {
            labeler.setMinZoom(minZoom);
        }
        if ((maxZoom = this.properties.getIntegerProperty(false, "grids", gridKey, "labeler", "max_zoom")) != null) {
            labeler.setMaxZoom(maxZoom);
        }
        if ((color = this.properties.getProperty(false, "grids", gridKey, "labeler", "color")) != null) {
            labeler.setColor(Color.color((String)color));
        }
        if ((textSize = this.properties.getDoubleProperty(false, "grids", gridKey, "labeler", "text_size")) != null) {
            labeler.setTextSize(textSize);
        }
        if ((buffer = this.properties.getDoubleProperty(false, "grids", gridKey, "labeler", "buffer")) != null) {
            labeler.setBuffer(buffer);
        }
    }

    protected Color loadGridStyleColor(String gridKey, String gridKey2) {
        String colorProperty = this.properties.getProperty(false, "grids", gridKey, gridKey2, "color");
        Color color = null;
        if (colorProperty != null) {
            color = Color.color((String)colorProperty);
        }
        return color;
    }

    protected Double loadGridStyleWidth(String gridKey, String gridKey2) {
        return this.properties.getDoubleProperty(false, "grids", gridKey, gridKey2, "width");
    }

    protected GridStyle getGridStyle(Color color, Double width, TGrid grid) {
        if (color == null) {
            color = ((BaseGrid)grid).getColor();
        }
        if (width == null || width == 0.0) {
            width = ((BaseGrid)grid).getWidth();
        }
        return GridStyle.style(color, width);
    }

    protected void createZoomGrids() {
        for (int zoom = 0; zoom <= 21; ++zoom) {
            this.createZoomGrids(zoom);
        }
    }

    public TZoomGrids getGrids(int zoom) {
        BaseZoomGrids<Object> grids = (BaseZoomGrids)this.zoomGrids.get(zoom);
        if (grids == null) {
            grids = this.createZoomGrids(zoom);
        }
        return (TZoomGrids)grids;
    }

    private TZoomGrids createZoomGrids(int zoom) {
        TZoomGrids zoomLevelGrids = this.newZoomGrids(zoom);
        for (BaseGrid grid : this.grids()) {
            if (!grid.isEnabled() || !grid.isWithin(zoom)) continue;
            ((BaseZoomGrids)zoomLevelGrids).addGrid((BaseGrid)grid);
        }
        this.zoomGrids.put(zoom, zoomLevelGrids);
        return zoomLevelGrids;
    }

    public void enableGrids(TGrid ... grids) {
        this.enableGrids((Collection<TGrid>)Arrays.asList(grids));
    }

    public void enableGrids(Collection<TGrid> grids) {
        for (BaseGrid grid : grids) {
            this.enable(grid);
        }
    }

    public void disableGrids(TGrid ... grids) {
        this.disableGrids((Collection<TGrid>)Arrays.asList(grids));
    }

    public void disableGrids(Collection<TGrid> grids) {
        for (BaseGrid grid : grids) {
            this.disable(grid);
        }
    }

    public void enable(TGrid grid) {
        if (!((BaseGrid)grid).isEnabled()) {
            ((BaseGrid)grid).setEnabled(true);
            int minZoom = ((BaseGrid)grid).getMinZoom();
            Integer maxZoom = ((BaseGrid)grid).getMaxZoom();
            if (maxZoom == null) {
                maxZoom = this.zoomGrids.lastKey();
            }
            for (int zoom = minZoom; zoom <= maxZoom; ++zoom) {
                this.addGrid(grid, zoom);
            }
        }
    }

    public void disable(TGrid grid) {
        if (((BaseGrid)grid).isEnabled()) {
            ((BaseGrid)grid).setEnabled(false);
            int minZoom = ((BaseGrid)grid).getMinZoom();
            Integer maxZoom = ((BaseGrid)grid).getMaxZoom();
            if (maxZoom == null) {
                maxZoom = this.zoomGrids.lastKey();
            }
            for (int zoom = minZoom; zoom <= maxZoom; ++zoom) {
                this.removeGrid(grid, zoom);
            }
        }
    }

    public void setMinZoom(TGrid grid, int minZoom) {
        Integer maxZoom = ((BaseGrid)grid).getMaxZoom();
        if (maxZoom != null && maxZoom < minZoom) {
            maxZoom = minZoom;
        }
        this.setZoomRange(grid, minZoom, maxZoom);
    }

    public void setMaxZoom(TGrid grid, Integer maxZoom) {
        int minZoom = ((BaseGrid)grid).getMinZoom();
        if (maxZoom != null && minZoom > maxZoom) {
            minZoom = maxZoom;
        }
        this.setZoomRange(grid, minZoom, maxZoom);
    }

    public void setZoomRange(TGrid grid, int minZoom, Integer maxZoom) {
        boolean overlaps;
        if (maxZoom != null && maxZoom < minZoom) {
            throw new IllegalArgumentException("Min zoom '" + minZoom + "' can not be larger than max zoom '" + maxZoom + "'");
        }
        int allGridsMin = this.zoomGrids.firstKey();
        int allGridsMax = this.zoomGrids.lastKey();
        int gridMinZoom = ((BaseGrid)grid).getMinZoom();
        Integer gridMaxZoom = ((BaseGrid)grid).getMaxZoom();
        gridMaxZoom = gridMaxZoom == null ? Integer.valueOf(allGridsMax) : Integer.valueOf(Math.min(gridMaxZoom, allGridsMax));
        ((BaseGrid)grid).setMinZoom(minZoom);
        ((BaseGrid)grid).setMaxZoom(maxZoom);
        minZoom = Math.max(minZoom, allGridsMin);
        maxZoom = maxZoom == null ? Integer.valueOf(allGridsMax) : Integer.valueOf(Math.min(maxZoom, allGridsMax));
        int minOverlap = Math.max(minZoom, gridMinZoom);
        int maxOverlap = Math.min(maxZoom, gridMaxZoom);
        boolean bl = overlaps = minOverlap <= maxOverlap;
        if (overlaps) {
            int min = Math.min(minZoom, gridMinZoom);
            int max = Math.max(maxZoom, gridMaxZoom);
            for (int zoom = min; zoom <= max; ++zoom) {
                if (zoom >= minOverlap && zoom <= maxOverlap) continue;
                if (zoom >= minZoom && zoom <= maxZoom) {
                    this.addGrid(grid, zoom);
                    continue;
                }
                this.removeGrid(grid, zoom);
            }
        } else {
            int zoom;
            for (zoom = gridMinZoom; zoom <= gridMaxZoom; ++zoom) {
                this.removeGrid(grid, zoom);
            }
            for (zoom = minZoom; zoom <= maxZoom; ++zoom) {
                this.addGrid(grid, zoom);
            }
        }
    }

    private void addGrid(TGrid grid, int zoom) {
        BaseZoomGrids grids = (BaseZoomGrids)this.zoomGrids.get(zoom);
        if (grids != null) {
            grids.addGrid(grid);
        }
    }

    private void removeGrid(TGrid grid, int zoom) {
        BaseZoomGrids grids = (BaseZoomGrids)this.zoomGrids.get(zoom);
        if (grids != null) {
            grids.removeGrid(grid);
        }
    }

    public void enableAllLabelers() {
        for (BaseGrid grid : this.grids()) {
            Labeler labeler = grid.getLabeler();
            if (labeler == null) continue;
            labeler.setEnabled(true);
        }
    }

    public void setAllLabelBuffers(double buffer) {
        for (BaseGrid grid : this.grids()) {
            Labeler labeler = grid.getLabeler();
            if (labeler == null) continue;
            labeler.setBuffer(buffer);
        }
    }
}

