/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid;

import mil.nga.grid.features.Bounds;
import mil.nga.grid.features.Line;
import mil.nga.grid.features.Point;
import mil.nga.grid.features.Unit;
import mil.nga.grid.tile.Pixel;
import mil.nga.sf.util.GeometryUtils;

public class GridUtils {
    public static Pixel getPixel(int width, int height, Bounds bounds, Point point) {
        point = point.toMeters();
        bounds = bounds.toMeters();
        float x = GridUtils.getXPixel(width, bounds, point.getLongitude());
        float y = GridUtils.getYPixel(height, bounds, point.getLatitude());
        return new Pixel(x, y);
    }

    public static float getXPixel(int width, Bounds bounds, double longitude) {
        bounds = bounds.toMeters();
        double boxWidth = bounds.getMaxLongitude() - bounds.getMinLongitude();
        double offset = longitude - bounds.getMinLongitude();
        double percentage = offset / boxWidth;
        float pixel = (float)(percentage * (double)width);
        return pixel;
    }

    public static float getYPixel(int height, Bounds bounds, double latitude) {
        bounds = bounds.toMeters();
        double boxHeight = bounds.getMaxLatitude() - bounds.getMinLatitude();
        double offset = bounds.getMaxLatitude() - latitude;
        double percentage = offset / boxHeight;
        float pixel = (float)(percentage * (double)height);
        return pixel;
    }

    public static Bounds getBounds(int x, int y, int zoom) {
        int tilesPerSide = GridUtils.tilesPerSide(zoom);
        double tileSize = GridUtils.tileSize(tilesPerSide);
        double minLon = -2.0037508342789244E7 + (double)x * tileSize;
        double minLat = 2.0037508342789244E7 - (double)(y + 1) * tileSize;
        double maxLon = -2.0037508342789244E7 + (double)(x + 1) * tileSize;
        double maxLat = 2.0037508342789244E7 - (double)y * tileSize;
        return Bounds.meters(minLon, minLat, maxLon, maxLat);
    }

    public static int tilesPerSide(int zoom) {
        return (int)Math.pow(2.0, zoom);
    }

    public static double tileSize(int tilesPerSide) {
        return 4.007501668557849E7 / (double)tilesPerSide;
    }

    public static double getZoomLevel(Bounds bounds) {
        bounds = bounds.toMeters();
        double tileSize = Math.min(bounds.getWidth(), bounds.getHeight());
        double tilesPerSide = 4.007501668557849E7 / tileSize;
        return Math.log(tilesPerSide) / Math.log(2.0);
    }

    public static Point toUnit(Unit fromUnit, double longitude, double latitude, Unit toUnit) {
        Point point = null;
        point = fromUnit == toUnit ? Point.point(longitude, latitude, toUnit) : GridUtils.toUnit(longitude, latitude, toUnit);
        return point;
    }

    public static Point toUnit(double longitude, double latitude, Unit unit) {
        mil.nga.sf.Point point = null;
        switch (unit) {
            case DEGREE: {
                point = GeometryUtils.metersToDegrees((double)longitude, (double)latitude);
                break;
            }
            case METER: {
                point = GeometryUtils.degreesToMeters((double)longitude, (double)latitude);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported unit: " + unit);
            }
        }
        return Point.point(point, unit);
    }

    public static boolean isOmittedBandLetter(char letter) {
        return letter == 'I' || letter == 'O';
    }

    public static double precisionBefore(double value, double precision) {
        double before = 0.0;
        if (Math.abs(value) >= precision) {
            before = value - (value % precision + precision) % precision;
        } else if (value < 0.0) {
            before = -precision;
        }
        return before;
    }

    public static double precisionAfter(double value, double precision) {
        return GridUtils.precisionBefore(value + precision, precision);
    }

    public static Point intersection(Line line1, Line line2) {
        return GridUtils.intersection(line1.getPoint1(), line1.getPoint2(), line2.getPoint1(), line2.getPoint2());
    }

    public static Point intersection(Point line1Point1, Point line1Point2, Point line2Point1, Point line2Point2) {
        Point intersection = null;
        mil.nga.sf.Point point = GeometryUtils.intersection((mil.nga.sf.Point)line1Point1.toMeters(), (mil.nga.sf.Point)line1Point2.toMeters(), (mil.nga.sf.Point)line2Point1.toMeters(), (mil.nga.sf.Point)line2Point2.toMeters());
        if (point != null) {
            intersection = Point.point(point, Unit.METER).toUnit(line1Point1.getUnit());
        }
        return intersection;
    }
}

