/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid;

import mil.nga.color.Color;

public abstract class Labeler {
    private boolean enabled;
    private int minZoom;
    private Integer maxZoom;
    private Color color;
    private double textSize;
    private double buffer;

    public Labeler(int minZoom, Color color, double textSize, double buffer) {
        this(minZoom, null, color, textSize, buffer);
    }

    public Labeler(int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        this(true, minZoom, maxZoom, color, textSize, buffer);
    }

    public Labeler(boolean enabled, int minZoom, Integer maxZoom, Color color, double textSize, double buffer) {
        this.enabled = enabled;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.color = color;
        this.textSize = textSize;
        this.buffer = buffer;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public boolean hasMaxZoom() {
        return this.maxZoom != null;
    }

    public void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public boolean isWithin(int zoom) {
        return zoom >= this.minZoom && (this.maxZoom == null || zoom <= this.maxZoom);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getTextSize() {
        return this.textSize;
    }

    public void setTextSize(double textSize) {
        this.textSize = textSize;
    }

    public double getBuffer() {
        return this.buffer;
    }

    public void setBuffer(double buffer) {
        if (buffer < 0.0 || buffer >= 0.5) {
            throw new IllegalArgumentException("Grid edge buffer must be >= 0 and < 0.5. buffer: " + buffer);
        }
        this.buffer = buffer;
    }
}

