/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid.features;

import java.util.ArrayList;
import java.util.List;
import mil.nga.grid.GridUtils;
import mil.nga.grid.features.Line;
import mil.nga.grid.features.Point;
import mil.nga.grid.features.Unit;
import mil.nga.grid.tile.GridTile;
import mil.nga.grid.tile.Pixel;
import mil.nga.grid.tile.PixelRange;
import mil.nga.sf.GeometryEnvelope;

public class Bounds
extends GeometryEnvelope {
    private static final long serialVersionUID = 1L;
    private Unit unit;

    public static Bounds bounds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude, Unit unit) {
        return new Bounds(minLongitude, minLatitude, maxLongitude, maxLatitude, unit);
    }

    public static Bounds degrees(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        return Bounds.bounds(minLongitude, minLatitude, maxLongitude, maxLatitude, Unit.DEGREE);
    }

    public static Bounds meters(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        return Bounds.bounds(minLongitude, minLatitude, maxLongitude, maxLatitude, Unit.METER);
    }

    public static Bounds bounds(Point southwest, Point northeast) {
        return new Bounds(southwest, northeast);
    }

    public static Bounds bounds(Bounds bounds) {
        return new Bounds(bounds);
    }

    public static Bounds bounds(GeometryEnvelope envelope, Unit unit) {
        return new Bounds(envelope, unit);
    }

    public Bounds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        this(minLongitude, minLatitude, maxLongitude, maxLatitude, Unit.DEGREE);
    }

    public Bounds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude, Unit unit) {
        super(minLongitude, minLatitude, maxLongitude, maxLatitude);
        this.unit = unit;
    }

    public Bounds(Point southwest, Point northeast) {
        this(southwest.getLongitude(), southwest.getLatitude(), northeast.getLongitude(), northeast.getLatitude(), southwest.getUnit());
        if (!this.isUnit(northeast.getUnit())) {
            throw new IllegalArgumentException("Points are in different units. southwest: " + this.unit + ", northeast: " + northeast.getUnit());
        }
    }

    public Bounds(Bounds bounds) {
        this(bounds, bounds.unit);
    }

    public Bounds(GeometryEnvelope envelope, Unit unit) {
        super(envelope);
        this.unit = unit;
    }

    public double getMinLongitude() {
        return this.getMinX();
    }

    public void setMinLongitude(double minLongitude) {
        this.setMinX(minLongitude);
    }

    public double getMinLatitude() {
        return this.getMinY();
    }

    public void setMinLatitude(double minLatitude) {
        this.setMinY(minLatitude);
    }

    public double getMaxLongitude() {
        return this.getMaxX();
    }

    public void setMaxLongitude(double maxLongitude) {
        this.setMaxX(maxLongitude);
    }

    public double getMaxLatitude() {
        return this.getMaxY();
    }

    public void setMaxLatitude(double maxLatitude) {
        this.setMaxY(maxLatitude);
    }

    public double getWest() {
        return this.getMinLongitude();
    }

    public void setWest(double west) {
        this.setMinLongitude(west);
    }

    public double getSouth() {
        return this.getMinLatitude();
    }

    public void setSouth(double south) {
        this.setMinLatitude(south);
    }

    public double getEast() {
        return this.getMaxLongitude();
    }

    public void setEast(double east) {
        this.setMaxLongitude(east);
    }

    public double getNorth() {
        return this.getMaxLatitude();
    }

    public void setNorth(double north) {
        this.setMaxLatitude(north);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public boolean isUnit(Unit unit) {
        return this.unit == unit;
    }

    public boolean isDegrees() {
        return this.isUnit(Unit.DEGREE);
    }

    public boolean isMeters() {
        return this.isUnit(Unit.METER);
    }

    public Bounds toUnit(Unit unit) {
        Bounds bounds = null;
        if (this.isUnit(unit)) {
            bounds = this;
        } else {
            Point southwest = this.getSouthwest().toUnit(unit);
            Point northeast = this.getNortheast().toUnit(unit);
            bounds = new Bounds(southwest, northeast);
        }
        return bounds;
    }

    public Bounds toDegrees() {
        return this.toUnit(Unit.DEGREE);
    }

    public Bounds toMeters() {
        return this.toUnit(Unit.METER);
    }

    public double getCentroidLongitude() {
        return this.getMidX();
    }

    public double getCentroidLatitude() {
        double centerLatitude = this.unit == Unit.DEGREE ? this.getCentroid().getLatitude() : this.getMidY();
        return centerLatitude;
    }

    public Point getCentroid() {
        Point point = null;
        point = this.unit == Unit.DEGREE ? this.toMeters().getCentroid().toDegrees() : Point.point(super.getCentroid(), this.unit);
        return point;
    }

    public double getWidth() {
        return this.getXRange();
    }

    public double getHeight() {
        return this.getYRange();
    }

    public Point getSouthwest() {
        return Point.point(this.getMinLongitude(), this.getMinLatitude(), this.unit);
    }

    public Point getNorthwest() {
        return Point.point(this.getMinLongitude(), this.getMaxLatitude(), this.unit);
    }

    public Point getSoutheast() {
        return Point.point(this.getMaxLongitude(), this.getMinLatitude(), this.unit);
    }

    public Point getNortheast() {
        return Point.point(this.getMaxLongitude(), this.getMaxLatitude(), this.unit);
    }

    public Bounds overlap(Bounds bounds) {
        Bounds overlap = null;
        GeometryEnvelope overlapEnvelope = super.overlap((GeometryEnvelope)bounds.toUnit(this.unit), true);
        if (overlapEnvelope != null) {
            overlap = new Bounds(overlapEnvelope, this.unit);
        }
        return overlap;
    }

    public Bounds union(Bounds bounds) {
        Bounds union = null;
        GeometryEnvelope unionEnvelope = super.union((GeometryEnvelope)bounds.toUnit(this.unit));
        if (unionEnvelope != null) {
            union = new Bounds(unionEnvelope, this.unit);
        }
        return union;
    }

    public Line getWestLine() {
        return Line.line(this.getNorthwest(), this.getSouthwest());
    }

    public Line getSouthLine() {
        return Line.line(this.getSouthwest(), this.getSoutheast());
    }

    public Line getEastLine() {
        return Line.line(this.getSoutheast(), this.getNortheast());
    }

    public Line getNorthLine() {
        return Line.line(this.getNortheast(), this.getNorthwest());
    }

    public Bounds toPrecision(double precision) {
        Bounds bounds = this.toDegrees();
        double minLon = GridUtils.precisionBefore(bounds.getMinLongitude(), precision);
        double minLat = GridUtils.precisionBefore(bounds.getMinLatitude(), precision);
        double maxLon = GridUtils.precisionAfter(bounds.getMaxLongitude(), precision);
        double maxLat = GridUtils.precisionAfter(bounds.getMaxLatitude(), precision);
        return Bounds.degrees(minLon, minLat, maxLon, maxLat);
    }

    public PixelRange getPixelRange(GridTile tile) {
        return this.getPixelRange(tile.getWidth(), tile.getHeight(), tile.getBounds());
    }

    public PixelRange getPixelRange(int width, int height, Bounds bounds) {
        bounds = bounds.toMeters();
        Pixel topLeft = GridUtils.getPixel(width, height, bounds, this.getNorthwest());
        Pixel bottomRight = GridUtils.getPixel(width, height, bounds, this.getSoutheast());
        return new PixelRange(topLeft, bottomRight);
    }

    public List<Line> getLines() {
        Point southwest = this.getSouthwest();
        Point northwest = this.getNorthwest();
        Point northeast = this.getNortheast();
        Point southeast = this.getSoutheast();
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(Line.line(southwest, northwest));
        lines.add(Line.line(northwest, northeast));
        lines.add(Line.line(northeast, southeast));
        lines.add(Line.line(southeast, southwest));
        return lines;
    }

    public Bounds copy() {
        return new Bounds(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Bounds other = (Bounds)((Object)obj);
        return this.unit == other.unit;
    }
}

