/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid.features;

import java.util.ArrayList;
import mil.nga.grid.GridUtils;
import mil.nga.grid.features.Point;
import mil.nga.grid.features.Unit;

public class Line
extends mil.nga.sf.Line {
    private static final long serialVersionUID = 1L;

    public static Line line(Point point1, Point point2) {
        return new Line(point1, point2);
    }

    public static Line line(Line line) {
        return new Line(line);
    }

    public Line(Point point1, Point point2) {
        this.setPoints(point1, point2);
    }

    public Line(Line line) {
        super((mil.nga.sf.Line)line);
    }

    public Point getPoint1() {
        return (Point)this.startPoint();
    }

    public void setPoint1(Point point1) {
        this.setPoints(point1, this.getPoint2());
    }

    public Point getPoint2() {
        return (Point)this.endPoint();
    }

    public void setPoint2(Point point2) {
        this.setPoints(this.getPoint1(), point2);
    }

    public void setPoints(Point point1, Point point2) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(point1);
        points.add(point2);
        this.setPoints(points);
        this.validateUnits();
    }

    public Unit getUnit() {
        return this.getPoint1().getUnit();
    }

    public boolean isUnit(Unit unit) {
        return this.getPoint1().isUnit(unit);
    }

    public boolean isDegrees() {
        return this.getPoint1().isDegrees();
    }

    public boolean isMeters() {
        return this.getPoint1().isMeters();
    }

    public Line toUnit(Unit unit) {
        Line line = null;
        if (this.isUnit(unit)) {
            line = this;
        } else {
            line = this.copy();
            line.setPoints(this.getPoint1().toUnit(unit), this.getPoint2().toUnit(unit));
        }
        return line;
    }

    public Line toDegrees() {
        return this.toUnit(Unit.DEGREE);
    }

    public Line toMeters() {
        return this.toUnit(Unit.METER);
    }

    public Point intersection(Line line) {
        return GridUtils.intersection(this, line);
    }

    public Line copy() {
        return new Line(this);
    }

    private void validateUnits() {
        if (!this.getPoint1().isUnit(this.getPoint2().getUnit())) {
            throw new IllegalArgumentException("Points are in different units. point1: " + this.getPoint1().getUnit() + ", point2: " + this.getPoint2().getUnit());
        }
    }
}

