/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid.features;

import mil.nga.grid.GridUtils;
import mil.nga.grid.features.Bounds;
import mil.nga.grid.features.Unit;
import mil.nga.grid.tile.GridTile;
import mil.nga.grid.tile.Pixel;

public class Point
extends mil.nga.sf.Point {
    private static final long serialVersionUID = 1L;
    private Unit unit;

    public static Point point(double longitude, double latitude) {
        return Point.degrees(longitude, latitude);
    }

    public static Point point(double longitude, double latitude, Unit unit) {
        return new Point(longitude, latitude, unit);
    }

    public static Point degrees(double longitude, double latitude) {
        return Point.point(longitude, latitude, Unit.DEGREE);
    }

    public static Point meters(double longitude, double latitude) {
        return Point.point(longitude, latitude, Unit.METER);
    }

    public static Point toUnit(Unit fromUnit, double longitude, double latitude, Unit toUnit) {
        return GridUtils.toUnit(fromUnit, longitude, latitude, toUnit);
    }

    public static Point toUnit(double longitude, double latitude, Unit unit) {
        return GridUtils.toUnit(longitude, latitude, unit);
    }

    public static Point degreesToMeters(double longitude, double latitude) {
        return Point.toUnit(Unit.DEGREE, longitude, latitude, Unit.METER);
    }

    public static Point metersToDegrees(double longitude, double latitude) {
        return Point.toUnit(Unit.METER, longitude, latitude, Unit.DEGREE);
    }

    public static Point point(Point point) {
        return new Point(point);
    }

    public static Point point(mil.nga.sf.Point point, Unit unit) {
        return new Point(point, unit);
    }

    public Point(double longitude, double latitude) {
        this(longitude, latitude, Unit.DEGREE);
    }

    public Point(double longitude, double latitude, Unit unit) {
        super(longitude, latitude);
        this.unit = unit;
    }

    public Point(Point point) {
        this(point, point.unit);
    }

    public Point(mil.nga.sf.Point point, Unit unit) {
        super(point);
        this.unit = unit;
    }

    public double getLongitude() {
        return this.getX();
    }

    public void setLongitude(double longitude) {
        this.setX(longitude);
    }

    public double getLatitude() {
        return this.getY();
    }

    public void setLatitude(double latitude) {
        this.setY(latitude);
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public boolean isUnit(Unit unit) {
        return this.unit == unit;
    }

    public boolean isDegrees() {
        return this.isUnit(Unit.DEGREE);
    }

    public boolean isMeters() {
        return this.isUnit(Unit.METER);
    }

    public Point toUnit(Unit unit) {
        Point point = null;
        point = this.isUnit(unit) ? this : GridUtils.toUnit(this.unit, this.getLongitude(), this.getLatitude(), unit);
        return point;
    }

    public Point toDegrees() {
        return this.toUnit(Unit.DEGREE);
    }

    public Point toMeters() {
        return this.toUnit(Unit.METER);
    }

    public Pixel getPixel(GridTile tile) {
        return this.getPixel(tile.getWidth(), tile.getHeight(), tile.getBounds());
    }

    public Pixel getPixel(int width, int height, Bounds bounds) {
        return GridUtils.getPixel(width, height, bounds, this);
    }

    public Point copy() {
        return new Point(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)((Object)obj);
        return this.unit == other.unit;
    }
}

