/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid.property;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GridProperties {
    private static final Logger log = Logger.getLogger(GridProperties.class.getName());
    protected Properties mProperties;

    public abstract String getFile();

    public String getProperty(String key) {
        return this.getProperty(key, true);
    }

    public synchronized String getProperty(String key, boolean required) {
        String value;
        if (this.mProperties == null) {
            this.mProperties = this.initializeConfigurationProperties();
        }
        if ((value = this.mProperties.getProperty(key)) != null && value.trim().isEmpty()) {
            value = null;
        }
        if (value == null && required) {
            throw new IllegalArgumentException("Property not found: " + key);
        }
        return value;
    }

    public String getProperty(String ... properties) {
        return this.getProperty(true, properties);
    }

    public String getProperty(boolean required, String ... properties) {
        return this.getProperty(this.buildProperty(properties), required);
    }

    public int getIntegerProperty(String key) {
        return this.getIntegerProperty(key, true);
    }

    public Integer getIntegerProperty(String key, boolean required) {
        Integer value = null;
        String stringValue = this.getProperty(key, required);
        if (stringValue != null) {
            value = Integer.valueOf(stringValue);
        }
        return value;
    }

    public int getIntegerProperty(String ... properties) {
        return this.getIntegerProperty(true, properties);
    }

    public Integer getIntegerProperty(boolean required, String ... properties) {
        return this.getIntegerProperty(this.buildProperty(properties), required);
    }

    public float getFloatProperty(String key) {
        return this.getFloatProperty(key, true).floatValue();
    }

    public Float getFloatProperty(String key, boolean required) {
        Float value = null;
        String stringValue = this.getProperty(key, required);
        if (stringValue != null) {
            value = Float.valueOf(stringValue);
        }
        return value;
    }

    public float getFloatProperty(String ... properties) {
        return this.getFloatProperty(true, properties).floatValue();
    }

    public Float getFloatProperty(boolean required, String ... properties) {
        return this.getFloatProperty(this.buildProperty(properties), required);
    }

    public double getDoubleProperty(String key) {
        return this.getDoubleProperty(key, true);
    }

    public Double getDoubleProperty(String key, boolean required) {
        Double value = null;
        String stringValue = this.getProperty(key, required);
        if (stringValue != null) {
            value = Double.valueOf(stringValue);
        }
        return value;
    }

    public double getDoubleProperty(String ... properties) {
        return this.getDoubleProperty(true, properties);
    }

    public Double getDoubleProperty(boolean required, String ... properties) {
        return this.getDoubleProperty(this.buildProperty(properties), required);
    }

    public boolean getBooleanProperty(String key) {
        return this.getBooleanProperty(key, true);
    }

    public Boolean getBooleanProperty(String key, boolean required) {
        Boolean value = null;
        String stringValue = this.getProperty(key, required);
        if (stringValue != null) {
            value = Boolean.valueOf(stringValue);
        }
        return value;
    }

    public boolean getBooleanProperty(String ... properties) {
        return this.getBooleanProperty(true, properties);
    }

    public Boolean getBooleanProperty(boolean required, String ... properties) {
        return this.getBooleanProperty(this.buildProperty(properties), required);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties initializeConfigurationProperties() {
        Properties properties = new Properties();
        String file = this.getFile();
        InputStream in = GridProperties.class.getResourceAsStream("/" + file);
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to load properties file: " + file, e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, "Failed to close properties file: " + file, e);
                }
            }
        } else {
            log.log(Level.SEVERE, "Failed to load properties, file not found: " + file);
        }
        return properties;
    }

    public String buildProperty(String ... properties) {
        StringBuilder combined = new StringBuilder();
        for (String property : properties) {
            if (property == null) continue;
            if (combined.length() > 0) {
                combined.append(".");
            }
            combined.append(property);
        }
        return combined.toString();
    }
}

