/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.grid.tile;

import mil.nga.grid.GridUtils;
import mil.nga.grid.features.Bounds;
import mil.nga.grid.features.Point;
import mil.nga.grid.features.Unit;
import mil.nga.grid.tile.Pixel;

public class GridTile {
    private int width;
    private int height;
    private int zoom;
    private Bounds bounds;

    public static GridTile tile(int width, int height, int x, int y, int zoom) {
        return new GridTile(width, height, x, y, zoom);
    }

    public static GridTile tile(int width, int height, Bounds bounds) {
        return new GridTile(width, height, bounds);
    }

    public GridTile(int width, int height, int x, int y, int zoom) {
        this.width = width;
        this.height = height;
        this.zoom = zoom;
        this.bounds = GridUtils.getBounds(x, y, zoom);
    }

    public GridTile(int width, int height, Bounds bounds) {
        this.width = width;
        this.height = height;
        this.bounds = bounds;
        this.zoom = (int)Math.round(GridUtils.getZoomLevel(bounds));
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getZoom() {
        return this.zoom;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public Bounds getBounds(Unit unit) {
        return this.bounds.toUnit(unit);
    }

    public Bounds getBoundsDegrees() {
        return this.getBounds(Unit.DEGREE);
    }

    public Bounds getBoundsMeters() {
        return this.getBounds(Unit.METER);
    }

    public Pixel getPixel(Point point) {
        return GridUtils.getPixel(this.width, this.height, this.bounds, point);
    }

    public float getXPixel(double longitude) {
        return GridUtils.getXPixel(this.width, this.bounds, longitude);
    }

    public float getYPixel(double latitude) {
        return GridUtils.getYPixel(this.height, this.bounds, latitude);
    }
}

