/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs;

import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.features.Line;
import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.features.Unit;
import mil.nga.mgrs.tile.Pixel;

public class MGRSUtils {
    public static Pixel getPixel(int width, int height, Bounds bounds, Point point) {
        point = point.toMeters();
        bounds = bounds.toMeters();
        float x = MGRSUtils.getXPixel(width, bounds, point.getLongitude());
        float y = MGRSUtils.getYPixel(height, bounds, point.getLatitude());
        return new Pixel(x, y);
    }

    public static float getXPixel(int width, Bounds bounds, double longitude) {
        bounds = bounds.toMeters();
        double boxWidth = bounds.getMaxLongitude() - bounds.getMinLongitude();
        double offset = longitude - bounds.getMinLongitude();
        double percentage = offset / boxWidth;
        float pixel = (float)(percentage * (double)width);
        return pixel;
    }

    public static float getYPixel(int height, Bounds bounds, double latitude) {
        bounds = bounds.toMeters();
        double boxHeight = bounds.getMaxLatitude() - bounds.getMinLatitude();
        double offset = bounds.getMaxLatitude() - latitude;
        double percentage = offset / boxHeight;
        float pixel = (float)(percentage * (double)height);
        return pixel;
    }

    public static Bounds getBounds(int x, int y, int zoom) {
        int tilesPerSide = MGRSUtils.tilesPerSide(zoom);
        double tileSize = MGRSUtils.tileSize(tilesPerSide);
        double minLon = -2.0037508342789244E7 + (double)x * tileSize;
        double minLat = 2.0037508342789244E7 - (double)(y + 1) * tileSize;
        double maxLon = -2.0037508342789244E7 + (double)(x + 1) * tileSize;
        double maxLat = 2.0037508342789244E7 - (double)y * tileSize;
        return Bounds.meters(minLon, minLat, maxLon, maxLat);
    }

    public static int tilesPerSide(int zoom) {
        return (int)Math.pow(2.0, zoom);
    }

    public static double tileSize(int tilesPerSide) {
        return 4.007501668557849E7 / (double)tilesPerSide;
    }

    public static double getZoomLevel(Bounds bounds) {
        bounds = bounds.toMeters();
        double tileSize = Math.min(bounds.getWidth(), bounds.getHeight());
        double tilesPerSide = 4.007501668557849E7 / tileSize;
        return Math.log(tilesPerSide) / Math.log(2.0);
    }

    public static Point toUnit(Unit fromUnit, double longitude, double latitude, Unit toUnit) {
        Point point = null;
        point = fromUnit == toUnit ? Point.create(longitude, latitude, toUnit) : MGRSUtils.toUnit(longitude, latitude, toUnit);
        return point;
    }

    public static Point toUnit(double longitude, double latitude, Unit unit) {
        Point point = null;
        switch (unit) {
            case DEGREE: {
                point = MGRSUtils.toDegrees(longitude, latitude);
                break;
            }
            case METER: {
                point = MGRSUtils.toMeters(longitude, latitude);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported unit: " + unit);
            }
        }
        return point;
    }

    public static Point toMeters(double longitude, double latitude) {
        double lon = longitude * 2.0037508342789244E7 / 180.0;
        double lat = Math.log(Math.tan((90.0 + latitude) * Math.PI / 360.0)) / (Math.PI / 180);
        lat = lat * 2.0037508342789244E7 / 180.0;
        return Point.meters(lon, lat);
    }

    public static Point toDegrees(double longitude, double latitude) {
        double lon = longitude * 180.0 / 2.0037508342789244E7;
        double lat = latitude * 180.0 / 2.0037508342789244E7;
        lat = Math.atan(Math.exp(lat * (Math.PI / 180))) / Math.PI * 360.0 - 90.0;
        return Point.degrees(lon, lat);
    }

    public static void validateZoneNumber(int number) {
        if (number < 1 || number > 60) {
            throw new IllegalArgumentException("Illegal zone number (expected 1 - 60): " + number);
        }
    }

    public static void validateBandLetter(char letter) {
        if (letter < 'C' || letter > 'X' || MGRSUtils.isOmittedBandLetter(letter)) {
            throw new IllegalArgumentException("Illegal band letter (CDEFGHJKLMNPQRSTUVWX): " + letter);
        }
    }

    public static char nextBandLetter(char letter) {
        MGRSUtils.validateBandLetter(letter);
        letter = (char)(letter + '\u0001');
        if (MGRSUtils.isOmittedBandLetter(letter)) {
            letter = (char)(letter + '\u0001');
        }
        return letter;
    }

    public static char previousBandLetter(char letter) {
        MGRSUtils.validateBandLetter(letter);
        letter = (char)(letter - '\u0001');
        if (MGRSUtils.isOmittedBandLetter(letter)) {
            letter = (char)(letter - '\u0001');
        }
        return letter;
    }

    public static boolean isOmittedBandLetter(char letter) {
        return letter == 'I' || letter == 'O';
    }

    public static String getLabelName(int zoneNumber, char bandLetter) {
        return String.valueOf(zoneNumber) + bandLetter;
    }

    public static Point intersection(Line line1, Line line2) {
        return MGRSUtils.intsersection(line1.getPoint1(), line1.getPoint2(), line2.getPoint1(), line2.getPoint2());
    }

    public static Point intsersection(Point line1Point1, Point line1Point2, Point line2Point1, Point line2Point2) {
        Unit unit = line1Point1.getUnit();
        line1Point1 = line1Point1.toMeters();
        line1Point2 = line1Point2.toMeters();
        line2Point1 = line2Point1.toMeters();
        line2Point2 = line2Point2.toMeters();
        Point intersection = null;
        double a1 = line1Point2.getLatitude() - line1Point1.getLatitude();
        double b1 = line1Point1.getLongitude() - line1Point2.getLongitude();
        double c1 = a1 * line1Point1.getLongitude() + b1 * line1Point1.getLatitude();
        double a2 = line2Point2.getLatitude() - line2Point1.getLatitude();
        double b2 = line2Point1.getLongitude() - line2Point2.getLongitude();
        double c2 = a2 * line2Point1.getLongitude() + b2 * line2Point1.getLatitude();
        double determinant = a1 * b2 - a2 * b1;
        if (determinant != 0.0) {
            double x = (b2 * c1 - b1 * c2) / determinant;
            double y = (a1 * c2 - a2 * c1) / determinant;
            intersection = Point.meters(x, y).toUnit(unit);
        }
        return intersection;
    }
}

