/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.features;

import java.util.ArrayList;
import java.util.List;
import mil.nga.mgrs.MGRSUtils;
import mil.nga.mgrs.features.Line;
import mil.nga.mgrs.features.Point;
import mil.nga.mgrs.features.Unit;
import mil.nga.mgrs.gzd.BandLetterRange;
import mil.nga.mgrs.gzd.GridRange;
import mil.nga.mgrs.gzd.GridZones;
import mil.nga.mgrs.gzd.LatitudeBand;
import mil.nga.mgrs.gzd.LongitudinalStrip;
import mil.nga.mgrs.gzd.ZoneNumberRange;
import mil.nga.mgrs.tile.MGRSTile;
import mil.nga.mgrs.tile.Pixel;
import mil.nga.mgrs.tile.PixelRange;

public class Bounds {
    private double west;
    private double south;
    private double east;
    private double north;
    private Unit unit;

    public static Bounds bounds(double west, double south, double east, double north, Unit unit) {
        return new Bounds(west, south, east, north, unit);
    }

    public static Bounds degrees(double west, double south, double east, double north) {
        return Bounds.bounds(west, south, east, north, Unit.DEGREE);
    }

    public static Bounds meters(double west, double south, double east, double north) {
        return Bounds.bounds(west, south, east, north, Unit.METER);
    }

    public static Bounds bounds(Point southwest, Point northeast) {
        return new Bounds(southwest, northeast);
    }

    public static Bounds bounds(LongitudinalStrip strip, LatitudeBand band) {
        return new Bounds(strip, band);
    }

    public static Bounds bounds(double[] bounds) {
        return new Bounds(bounds);
    }

    public static Bounds bounds(double[] bounds, Unit unit) {
        return new Bounds(bounds, unit);
    }

    public static Bounds degrees(double[] bounds) {
        return Bounds.bounds(bounds, Unit.DEGREE);
    }

    public static Bounds meters(double[] bounds) {
        return Bounds.bounds(bounds, Unit.METER);
    }

    public Bounds(double west, double south, double east, double north) {
        this(west, south, east, north, Unit.DEGREE);
    }

    public Bounds(double west, double south, double east, double north, Unit unit) {
        this.west = west;
        this.south = south;
        this.east = east;
        this.north = north;
        this.unit = unit;
    }

    public Bounds(Point southwest, Point northeast) {
        this(southwest.getLongitude(), southwest.getLatitude(), northeast.getLongitude(), northeast.getLatitude(), southwest.getUnit());
        if (!this.isUnit(northeast.getUnit())) {
            throw new IllegalArgumentException("Points are in different units. southwest: " + this.unit + ", northeast: " + northeast.getUnit());
        }
    }

    public Bounds(LongitudinalStrip strip, LatitudeBand band) {
        this(strip.getWest(), band.getSouth(), strip.getEast(), band.getNorth(), Unit.DEGREE);
    }

    public Bounds(double[] bounds) {
        this(bounds, Unit.DEGREE);
    }

    public Bounds(double[] bounds, Unit unit) {
        this(bounds[0], bounds[1], bounds[2], bounds[3], unit);
    }

    public double getWest() {
        return this.west;
    }

    public void setWest(double west) {
        this.west = west;
    }

    public double getSouth() {
        return this.south;
    }

    public void setSouth(double south) {
        this.south = south;
    }

    public double getEast() {
        return this.east;
    }

    public void setEast(double east) {
        this.east = east;
    }

    public double getNorth() {
        return this.north;
    }

    public void setNorth(double north) {
        this.north = north;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public boolean isUnit(Unit unit) {
        return this.unit == unit;
    }

    public boolean isDegrees() {
        return this.isUnit(Unit.DEGREE);
    }

    public boolean isMeters() {
        return this.isUnit(Unit.METER);
    }

    public Bounds toUnit(Unit unit) {
        Bounds bounds = null;
        if (this.isUnit(unit)) {
            bounds = this;
        } else {
            Point southwest = this.getSouthwest().toUnit(unit);
            Point northeast = this.getNortheast().toUnit(unit);
            bounds = new Bounds(southwest, northeast);
        }
        return bounds;
    }

    public Bounds toDegrees() {
        return this.toUnit(Unit.DEGREE);
    }

    public Bounds toMeters() {
        return this.toUnit(Unit.METER);
    }

    public double getMinLongitude() {
        return this.getWest();
    }

    public void setMinLongitude(double west) {
        this.setWest(west);
    }

    public double getMinLatitude() {
        return this.getSouth();
    }

    public void setMinLatitude(double south) {
        this.setSouth(south);
    }

    public double getMaxLongitude() {
        return this.getEast();
    }

    public void setMaxLongitude(double east) {
        this.setEast(east);
    }

    public double getMaxLatitude() {
        return this.getNorth();
    }

    public void setMaxLatitude(double north) {
        this.setNorth(north);
    }

    public double getCenterLongitude() {
        return (this.east - this.west) / 2.0 + this.west;
    }

    public double getCenterLatitude() {
        return this.getCenter().getLatitude();
    }

    public Point getCenter() {
        double centerLongitude = this.getCenterLongitude();
        Point northPoint = null;
        Point southPoint = null;
        switch (this.unit) {
            case DEGREE: {
                northPoint = Point.degreesToMeters(centerLongitude, this.north);
                southPoint = Point.degreesToMeters(centerLongitude, this.south);
                break;
            }
            case METER: {
                northPoint = Point.meters(centerLongitude, this.north);
                southPoint = Point.meters(centerLongitude, this.south);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported unit: " + this.unit);
            }
        }
        double centerX = northPoint.getLongitude();
        double centerY = southPoint.getLatitude() + 0.5 * (northPoint.getLatitude() - southPoint.getLatitude());
        Point point = Point.meters(centerX, centerY);
        if (this.unit == Unit.DEGREE) {
            point = point.toDegrees();
        }
        return point;
    }

    public double getWidth() {
        return this.east - this.west;
    }

    public double getHeight() {
        return this.north - this.south;
    }

    public boolean isEmpty() {
        return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
    }

    public Point getSouthwest() {
        return Point.create(this.getWest(), this.getSouth(), this.unit);
    }

    public Point getNorthwest() {
        return Point.create(this.getWest(), this.getNorth(), this.unit);
    }

    public Point getSoutheast() {
        return Point.create(this.getEast(), this.getSouth(), this.unit);
    }

    public Point getNortheast() {
        return Point.create(this.getEast(), this.getNorth(), this.unit);
    }

    public Bounds union(Bounds bounds) {
        bounds = bounds.toUnit(this.unit);
        double west = Math.min(this.getWest(), bounds.getWest());
        double south = Math.min(this.getSouth(), bounds.getSouth());
        double east = Math.max(this.getEast(), bounds.getEast());
        double north = Math.max(this.getNorth(), bounds.getNorth());
        return new Bounds(west, south, east, north, this.unit);
    }

    public Bounds overlap(Bounds bounds) {
        bounds = bounds.toUnit(this.unit);
        double west = Math.max(this.getWest(), bounds.getWest());
        double south = Math.max(this.getSouth(), bounds.getSouth());
        double east = Math.min(this.getEast(), bounds.getEast());
        double north = Math.min(this.getNorth(), bounds.getNorth());
        return new Bounds(west, south, east, north, this.unit);
    }

    public boolean contains(Point point) {
        point = point.toUnit(this.unit);
        double longitude = point.getLongitude();
        double latitude = point.getLatitude();
        return longitude >= this.getWest() && longitude <= this.getEast() && latitude >= this.getSouth() && latitude <= this.getNorth();
    }

    public Line getWestLine() {
        return Line.line(this.getNorthwest(), this.getSouthwest());
    }

    public Line getSouthLine() {
        return Line.line(this.getSouthwest(), this.getSoutheast());
    }

    public Line getEastLine() {
        return Line.line(this.getSoutheast(), this.getNortheast());
    }

    public Line getNorthLine() {
        return Line.line(this.getNortheast(), this.getNorthwest());
    }

    public PixelRange getPixelRange(MGRSTile tile) {
        return this.getPixelRange(tile.getWidth(), tile.getHeight(), tile.getBounds());
    }

    public PixelRange getPixelRange(int width, int height, Bounds bounds) {
        bounds = bounds.toMeters();
        Pixel topLeft = MGRSUtils.getPixel(width, height, bounds, this.getNorthwest());
        Pixel bottomRight = MGRSUtils.getPixel(width, height, bounds, this.getSoutheast());
        return new PixelRange(topLeft, bottomRight);
    }

    public List<Line> getLines() {
        Point southwest = this.getSouthwest();
        Point northwest = this.getNorthwest();
        Point northeast = this.getNortheast();
        Point southeast = this.getSoutheast();
        ArrayList<Line> lines = new ArrayList<Line>();
        lines.add(Line.line(southwest, northwest));
        lines.add(Line.line(northwest, northeast));
        lines.add(Line.line(northeast, southeast));
        lines.add(Line.line(southeast, southwest));
        return lines;
    }

    public GridRange getGridRange() {
        return GridZones.getGridRange(this);
    }

    public ZoneNumberRange getZoneNumberRange() {
        return GridZones.getZoneNumberRange(this);
    }

    public BandLetterRange getBandLetterRange() {
        return GridZones.getBandLetterRange(this);
    }
}

