/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mil.nga.mgrs.color.Color;
import mil.nga.mgrs.features.Bounds;
import mil.nga.mgrs.features.Line;
import mil.nga.mgrs.grid.GridStyle;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.grid.Label;
import mil.nga.mgrs.grid.Labeler;
import mil.nga.mgrs.gzd.GridZone;
import mil.nga.mgrs.property.MGRSProperties;
import mil.nga.mgrs.tile.MGRSTile;

public class Grid
implements Comparable<Grid> {
    public static final double DEFAULT_WIDTH = MGRSProperties.getDoubleProperty("grid", "width");
    private final GridType type;
    private boolean enabled;
    private int minZoom;
    private Integer maxZoom;
    private Integer linesMinZoom;
    private Integer linesMaxZoom;
    private Map<GridType, GridStyle> styles = new HashMap<GridType, GridStyle>();
    private Labeler labeler;

    protected Grid(GridType type) {
        this.type = type;
        this.styles.put(type, new GridStyle());
    }

    public GridType getType() {
        return this.type;
    }

    public boolean isType(GridType type) {
        return this.type == type;
    }

    public int getPrecision() {
        return this.type.getPrecision();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    protected void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public boolean hasMaxZoom() {
        return this.maxZoom != null;
    }

    protected void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public boolean isWithin(int zoom) {
        return zoom >= this.minZoom && (this.maxZoom == null || zoom <= this.maxZoom);
    }

    public int getLinesMinZoom() {
        return this.linesMinZoom != null ? this.linesMinZoom.intValue() : this.getMinZoom();
    }

    public boolean hasLinesMinZoom() {
        return this.linesMinZoom != null;
    }

    public void setLinesMinZoom(Integer linesMinZoom) {
        this.linesMinZoom = linesMinZoom;
    }

    public Integer getLinesMaxZoom() {
        return this.linesMaxZoom != null ? this.linesMaxZoom : this.getMaxZoom();
    }

    public boolean hasLinesMaxZoom() {
        return this.linesMaxZoom != null;
    }

    public void setLinesMaxZoom(Integer linesMaxZoom) {
        this.linesMaxZoom = linesMaxZoom;
    }

    public boolean isLinesWithin(int zoom) {
        return !(this.linesMinZoom != null && zoom < this.linesMinZoom || this.linesMaxZoom != null && zoom > this.linesMaxZoom);
    }

    public GridStyle getStyle() {
        return this.styles.get((Object)this.type);
    }

    public void setStyle(GridStyle style) {
        if (style == null) {
            style = new GridStyle();
        }
        this.styles.put(this.type, style);
    }

    public Color getColor() {
        return this.getStyle().getColor();
    }

    public void setColor(Color color) {
        this.getStyle().setColor(color);
    }

    public double getWidth() {
        return this.getStyle().getWidth();
    }

    public void setWidth(double width) {
        this.getStyle().setWidth(width);
    }

    public GridStyle getStyle(GridType gridType) {
        return this.styles.get((Object)gridType);
    }

    private GridStyle getOrCreateStyle(GridType gridType) {
        GridStyle style = this.getStyle(gridType);
        if (style == null) {
            style = new GridStyle();
            this.setStyle(gridType, style);
        }
        return style;
    }

    public void setStyle(GridType gridType, GridStyle style) {
        if (gridType.getPrecision() < this.getPrecision()) {
            throw new IllegalArgumentException("Grid can not define a style for a higher precision grid type. Type: " + this.type + ", Style Type: " + gridType);
        }
        if (style == null) {
            style = new GridStyle();
        }
        this.styles.put(gridType, style);
    }

    public Color getColor(GridType gridType) {
        Color color = null;
        GridStyle style = this.getStyle(gridType);
        if (style != null) {
            color = style.getColor();
        }
        if (color == null) {
            color = this.getColor();
        }
        return color;
    }

    public void setColor(GridType gridType, Color color) {
        this.getOrCreateStyle(gridType).setColor(color);
    }

    public double getWidth(GridType gridType) {
        double width = 0.0;
        GridStyle style = this.getStyle(gridType);
        if (style != null) {
            width = style.getWidth();
        }
        if (width == 0.0) {
            width = this.getWidth();
        }
        return width;
    }

    public void setWidth(GridType gridType, double width) {
        this.getOrCreateStyle(gridType).setWidth(width);
    }

    public Labeler getLabeler() {
        return this.labeler;
    }

    public boolean hasLabeler() {
        return this.labeler != null;
    }

    protected void setLabeler(Labeler labeler) {
        this.labeler = labeler;
    }

    public List<Line> getLines(MGRSTile tile, GridZone zone) {
        return this.getLines(tile.getZoom(), tile.getBounds(), zone);
    }

    public List<Line> getLines(int zoom, Bounds tileBounds, GridZone zone) {
        List<Line> lines = null;
        if (this.isLinesWithin(zoom)) {
            lines = this.getLines(tileBounds, zone);
        }
        return lines;
    }

    public List<Line> getLines(Bounds tileBounds, GridZone zone) {
        return zone.getLines(tileBounds, this.type);
    }

    public List<Label> getLabels(MGRSTile tile, GridZone zone) {
        return this.getLabels(tile.getZoom(), tile.getBounds(), zone);
    }

    public List<Label> getLabels(int zoom, Bounds tileBounds, GridZone zone) {
        List<Label> labels = null;
        if (this.hasLabeler() && this.labeler.isEnabled() && this.labeler.isWithin(zoom)) {
            labels = this.labeler.getLabels(tileBounds, this.type, zone);
        }
        return labels;
    }

    public double getLabelBuffer() {
        return this.hasLabeler() ? this.labeler.getBuffer() : 0.0;
    }

    @Override
    public int compareTo(Grid other) {
        return this.getPrecisionCompare() - other.getPrecisionCompare();
    }

    public int getPrecisionCompare() {
        int precision = this.getPrecision();
        if (precision <= GridType.GZD.getPrecision()) {
            precision = Integer.MAX_VALUE;
        }
        return precision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Grid other = (Grid)obj;
        return this.type == other.type;
    }
}

