/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.mgrs.grid;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import mil.nga.mgrs.color.Color;
import mil.nga.mgrs.grid.Grid;
import mil.nga.mgrs.grid.GridLabeler;
import mil.nga.mgrs.grid.GridStyle;
import mil.nga.mgrs.grid.GridType;
import mil.nga.mgrs.grid.Labeler;
import mil.nga.mgrs.grid.ZoomGrids;
import mil.nga.mgrs.gzd.GZDLabeler;
import mil.nga.mgrs.property.MGRSProperties;

public class Grids {
    private Map<GridType, Grid> grids = new HashMap<GridType, Grid>();
    private TreeMap<Integer, ZoomGrids> zoomGrids = new TreeMap();

    public static Grids create() {
        return new Grids();
    }

    public static Grids create(GridType ... types) {
        return new Grids(types);
    }

    public static Grids create(Collection<GridType> types) {
        return new Grids(types);
    }

    public static Grids createGZD() {
        return Grids.create(GridType.GZD);
    }

    public Grids() {
        this.createGrids();
        this.createZoomGrids();
    }

    public Grids(GridType ... types) {
        this(Arrays.asList(types));
    }

    public Grids(Collection<GridType> types) {
        this.createGrids(false);
        for (GridType type : types) {
            this.getGrid(type).setEnabled(true);
        }
        this.createZoomGrids();
    }

    private void createGrids() {
        this.createGrids(null);
    }

    private void createGrids(Boolean enabled) {
        Boolean propagate = MGRSProperties.getBooleanProperty(false, "grids", "propagate");
        HashMap<GridType, GridStyle> styles = null;
        if (propagate != null && propagate.booleanValue()) {
            styles = new HashMap<GridType, GridStyle>();
        }
        this.createGrid(GridType.GZD, styles, enabled, new GZDLabeler());
        this.createGrid(GridType.HUNDRED_KILOMETER, styles, enabled, new GridLabeler());
        this.createGrid(GridType.TEN_KILOMETER, styles, enabled, new GridLabeler());
        this.createGrid(GridType.KILOMETER, styles, enabled, new GridLabeler());
        this.createGrid(GridType.HUNDRED_METER, styles, enabled, new GridLabeler());
        this.createGrid(GridType.TEN_METER, styles, enabled, new GridLabeler());
        this.createGrid(GridType.METER, styles, enabled, new GridLabeler());
    }

    private void createGrid(GridType type, Map<GridType, GridStyle> styles, Boolean enabled, Labeler labeler) {
        Grid grid = this.newGrid(type);
        String gridKey = type.name().toLowerCase();
        if (enabled == null && (enabled = MGRSProperties.getBooleanProperty(false, "grids", gridKey, "enabled")) == null) {
            enabled = true;
        }
        grid.setEnabled(enabled);
        Integer minZoom = MGRSProperties.getIntegerProperty(false, "grids", gridKey, "min_zoom");
        if (minZoom == null) {
            minZoom = 0;
        }
        grid.setMinZoom(minZoom);
        Integer maxZoom = MGRSProperties.getIntegerProperty(false, "grids", gridKey, "max_zoom");
        grid.setMaxZoom(maxZoom);
        Integer linesMinZoom = MGRSProperties.getIntegerProperty(false, "grids", gridKey, "lines", "min_zoom");
        grid.setLinesMinZoom(linesMinZoom);
        Integer linesMaxZoom = MGRSProperties.getIntegerProperty(false, "grids", gridKey, "lines", "max_zoom");
        grid.setLinesMaxZoom(linesMaxZoom);
        String colorProperty = MGRSProperties.getProperty(false, "grids", gridKey, "color");
        Color color = colorProperty != null ? Color.color(colorProperty) : Color.black();
        grid.setColor(color);
        Double width = MGRSProperties.getDoubleProperty(false, "grids", gridKey, "width");
        if (width == null) {
            width = Grid.DEFAULT_WIDTH;
        }
        grid.setWidth(width);
        if (styles != null) {
            styles.put(type, GridStyle.style(color, width));
        }
        this.loadGridStyles(grid, styles, gridKey);
        if (labeler != null) {
            this.loadLabeler(labeler, gridKey);
        }
        grid.setLabeler(labeler);
        this.grids.put(type, grid);
    }

    private void loadGridStyles(Grid grid, Map<GridType, GridStyle> styles, String gridKey) {
        int precision = grid.getPrecision();
        if (precision < GridType.HUNDRED_KILOMETER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.HUNDRED_KILOMETER);
        }
        if (precision < GridType.TEN_KILOMETER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.TEN_KILOMETER);
        }
        if (precision < GridType.KILOMETER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.KILOMETER);
        }
        if (precision < GridType.HUNDRED_METER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.HUNDRED_METER);
        }
        if (precision < GridType.TEN_METER.getPrecision()) {
            this.loadGridStyle(grid, styles, gridKey, GridType.TEN_METER);
        }
    }

    private void loadGridStyle(Grid grid, Map<GridType, GridStyle> styles, String gridKey, GridType gridType) {
        GridStyle style;
        String gridKey2 = gridType.name().toLowerCase();
        String colorProperty = MGRSProperties.getProperty(false, "grids", gridKey, gridKey2, "color");
        Color color = null;
        if (colorProperty != null) {
            color = Color.color(colorProperty);
        }
        Double width = MGRSProperties.getDoubleProperty(false, "grids", gridKey, gridKey2, "width");
        if ((color == null || width == null) && styles != null && (style = styles.get((Object)gridType)) != null) {
            Color styleColor;
            if (color == null && (styleColor = style.getColor()) != null) {
                color = styleColor.copy();
            }
            if (width == null) {
                width = style.getWidth();
            }
        }
        if (color != null || width != null) {
            if (color == null) {
                color = grid.getColor();
            }
            if (width == null || width == 0.0) {
                width = grid.getWidth();
            }
            style = GridStyle.style(color, width);
            grid.setStyle(gridType, style);
            if (styles != null) {
                styles.put(gridType, style);
            }
        }
    }

    private void loadLabeler(Labeler labeler, String gridKey) {
        Double buffer;
        Double textSize;
        String color;
        Integer maxZoom;
        Boolean enabled = MGRSProperties.getBooleanProperty(false, "grids", gridKey, "labeler", "enabled");
        labeler.setEnabled(enabled != null && enabled != false);
        Integer minZoom = MGRSProperties.getIntegerProperty(false, "grids", gridKey, "labeler", "min_zoom");
        if (minZoom != null) {
            labeler.setMinZoom(minZoom);
        }
        if ((maxZoom = MGRSProperties.getIntegerProperty(false, "grids", gridKey, "labeler", "max_zoom")) != null) {
            labeler.setMaxZoom(maxZoom);
        }
        if ((color = MGRSProperties.getProperty(false, "grids", gridKey, "labeler", "color")) != null) {
            labeler.setColor(Color.color(color));
        }
        if ((textSize = MGRSProperties.getDoubleProperty(false, "grids", gridKey, "labeler", "text_size")) != null) {
            labeler.setTextSize(textSize);
        }
        if ((buffer = MGRSProperties.getDoubleProperty(false, "grids", gridKey, "labeler", "buffer")) != null) {
            labeler.setBuffer(buffer);
        }
    }

    protected Grid newGrid(GridType type) {
        return new Grid(type);
    }

    private void createZoomGrids() {
        for (int zoom = 0; zoom <= 21; ++zoom) {
            this.createZoomGrids(zoom);
        }
    }

    public Grid getGrid(GridType type) {
        return this.grids.get((Object)type);
    }

    public ZoomGrids getGrids(int zoom) {
        ZoomGrids grids = this.zoomGrids.get(zoom);
        if (grids == null) {
            grids = this.createZoomGrids(zoom);
        }
        return grids;
    }

    private ZoomGrids createZoomGrids(int zoom) {
        ZoomGrids zoomLevelGrids = this.newZoomGrids(zoom);
        for (Grid grid : this.grids.values()) {
            if (!grid.isEnabled() || !grid.isWithin(zoom)) continue;
            zoomLevelGrids.addGrid(grid);
        }
        this.zoomGrids.put(zoom, zoomLevelGrids);
        return zoomLevelGrids;
    }

    protected ZoomGrids newZoomGrids(int zoom) {
        return new ZoomGrids(zoom);
    }

    public GridType getPrecision(int zoom) {
        return this.getGrids(zoom).getPrecision();
    }

    public void setGrids(GridType ... types) {
        this.setGridTypes(Arrays.asList(types));
    }

    public void setGrids(Grid ... grids) {
        this.setGrids(Arrays.asList(grids));
    }

    public void setGridTypes(Collection<GridType> types) {
        HashSet<GridType> disableTypes = new HashSet<GridType>(Arrays.asList(GridType.values()));
        for (GridType gridType : types) {
            this.enable(gridType);
            disableTypes.remove((Object)gridType);
        }
        this.disableTypes(disableTypes);
    }

    public void setGrids(Collection<Grid> grids) {
        HashSet<GridType> disableTypes = new HashSet<GridType>(Arrays.asList(GridType.values()));
        for (Grid grid : grids) {
            this.enable(grid);
            disableTypes.remove((Object)grid.getType());
        }
        this.disableTypes(disableTypes);
    }

    public void enableTypes(GridType ... types) {
        this.enableTypes(Arrays.asList(types));
    }

    public void enableGrids(Grid ... grids) {
        this.enableGrids(Arrays.asList(grids));
    }

    public void enableTypes(Collection<GridType> types) {
        for (GridType type : types) {
            this.enable(type);
        }
    }

    public void enableGrids(Collection<Grid> grids) {
        for (Grid grid : grids) {
            this.enable(grid);
        }
    }

    public void disableTypes(GridType ... types) {
        this.disableTypes(Arrays.asList(types));
    }

    public void disableGrids(Grid ... grids) {
        this.disableGrids(Arrays.asList(grids));
    }

    public void disableTypes(Collection<GridType> types) {
        for (GridType type : types) {
            this.disable(type);
        }
    }

    public void disableGrids(Collection<Grid> grids) {
        for (Grid grid : grids) {
            this.disable(grid);
        }
    }

    public boolean isEnabled(GridType type) {
        return this.getGrid(type).isEnabled();
    }

    public void enable(GridType type) {
        this.enable(this.getGrid(type));
    }

    public void enable(Grid grid) {
        if (!grid.isEnabled()) {
            grid.setEnabled(true);
            int minZoom = grid.getMinZoom();
            Integer maxZoom = grid.getMaxZoom();
            if (maxZoom == null) {
                maxZoom = this.zoomGrids.lastKey();
            }
            for (int zoom = minZoom; zoom <= maxZoom; ++zoom) {
                this.addGrid(grid, zoom);
            }
        }
    }

    public void disable(GridType type) {
        this.disable(this.getGrid(type));
    }

    public void disable(Grid grid) {
        if (grid.isEnabled()) {
            grid.setEnabled(false);
            int minZoom = grid.getMinZoom();
            Integer maxZoom = grid.getMaxZoom();
            if (maxZoom == null) {
                maxZoom = this.zoomGrids.lastKey();
            }
            for (int zoom = minZoom; zoom <= maxZoom; ++zoom) {
                this.removeGrid(grid, zoom);
            }
        }
    }

    public void setMinZoom(GridType type, int minZoom) {
        this.setMinZoom(this.getGrid(type), minZoom);
    }

    public void setMinZoom(Grid grid, int minZoom) {
        Integer maxZoom = grid.getMaxZoom();
        if (maxZoom != null && maxZoom < minZoom) {
            maxZoom = minZoom;
        }
        this.setZoomRange(grid, minZoom, maxZoom);
    }

    public void setMaxZoom(GridType type, Integer maxZoom) {
        this.setMaxZoom(this.getGrid(type), maxZoom);
    }

    public void setMaxZoom(Grid grid, Integer maxZoom) {
        int minZoom = grid.getMinZoom();
        if (maxZoom != null && minZoom > maxZoom) {
            minZoom = maxZoom;
        }
        this.setZoomRange(grid, minZoom, maxZoom);
    }

    public void setZoomRange(GridType type, int minZoom, Integer maxZoom) {
        this.setZoomRange(this.getGrid(type), minZoom, maxZoom);
    }

    public void setZoomRange(Grid grid, int minZoom, Integer maxZoom) {
        boolean overlaps;
        if (maxZoom != null && maxZoom < minZoom) {
            throw new IllegalArgumentException("Min zoom '" + minZoom + "' can not be larger than max zoom '" + maxZoom + "'");
        }
        int allGridsMin = this.zoomGrids.firstKey();
        int allGridsMax = this.zoomGrids.lastKey();
        int gridMinZoom = grid.getMinZoom();
        Integer gridMaxZoom = grid.getMaxZoom();
        gridMaxZoom = gridMaxZoom == null ? Integer.valueOf(allGridsMax) : Integer.valueOf(Math.min(gridMaxZoom, allGridsMax));
        grid.setMinZoom(minZoom);
        grid.setMaxZoom(maxZoom);
        minZoom = Math.max(minZoom, allGridsMin);
        maxZoom = maxZoom == null ? Integer.valueOf(allGridsMax) : Integer.valueOf(Math.min(maxZoom, allGridsMax));
        int minOverlap = Math.max(minZoom, gridMinZoom);
        int maxOverlap = Math.min(maxZoom, gridMaxZoom);
        boolean bl = overlaps = minOverlap <= maxOverlap;
        if (overlaps) {
            int min = Math.min(minZoom, gridMinZoom);
            int max = Math.max(maxZoom, gridMaxZoom);
            for (int zoom = min; zoom <= max; ++zoom) {
                if (zoom >= minOverlap && zoom <= maxOverlap) continue;
                if (zoom >= minZoom && zoom <= maxZoom) {
                    this.addGrid(grid, zoom);
                    continue;
                }
                this.removeGrid(grid, zoom);
            }
        } else {
            int zoom;
            for (zoom = gridMinZoom; zoom <= gridMaxZoom; ++zoom) {
                this.removeGrid(grid, zoom);
            }
            for (zoom = minZoom; zoom <= maxZoom; ++zoom) {
                this.addGrid(grid, zoom);
            }
        }
    }

    private void addGrid(Grid grid, int zoom) {
        ZoomGrids grids = this.zoomGrids.get(zoom);
        if (grids != null) {
            grids.addGrid(grid);
        }
    }

    private void removeGrid(Grid grid, int zoom) {
        ZoomGrids grids = this.zoomGrids.get(zoom);
        if (grids != null) {
            grids.removeGrid(grid);
        }
    }

    public void setLinesMinZoom(GridType type, Integer minZoom) {
        this.getGrid(type).setLinesMinZoom(minZoom);
    }

    public void setLinesMaxZoom(GridType type, Integer maxZoom) {
        this.getGrid(type).setLinesMaxZoom(maxZoom);
    }

    public void setAllColors(Color color) {
        this.setColor(color, GridType.values());
    }

    public void setColor(Color color, GridType ... types) {
        this.setColor(Arrays.asList(types), color);
    }

    public void setColor(Collection<GridType> types, Color color) {
        for (GridType type : types) {
            this.setColor(type, color);
        }
    }

    public void setColor(GridType type, Color color) {
        this.getGrid(type).setColor(color);
    }

    public void setAllWidths(double width) {
        this.setWidth(width, GridType.values());
    }

    public void setWidth(double width, GridType ... types) {
        this.setWidth(Arrays.asList(types), width);
    }

    public void setWidth(Collection<GridType> types, double width) {
        for (GridType type : types) {
            this.setWidth(type, width);
        }
    }

    public void setWidth(GridType type, double width) {
        this.getGrid(type).setWidth(width);
    }

    public void setColor(Collection<GridType> types, GridType precisionType, Color color) {
        for (GridType type : types) {
            this.setColor(type, precisionType, color);
        }
    }

    public void setColor(GridType type, Color color, GridType ... precisionTypes) {
        this.setColor(type, Arrays.asList(precisionTypes), color);
    }

    public void setColor(GridType type, Collection<GridType> precisionTypes, Color color) {
        for (GridType precisionType : precisionTypes) {
            this.setColor(type, precisionType, color);
        }
    }

    public void setColor(GridType type, GridType precisionType, Color color) {
        this.getGrid(type).setColor(precisionType, color);
    }

    public void setWidth(Collection<GridType> types, GridType precisionType, double width) {
        for (GridType type : types) {
            this.setWidth(type, precisionType, width);
        }
    }

    public void setWidth(GridType type, double width, GridType ... precisionTypes) {
        this.setWidth(type, Arrays.asList(precisionTypes), width);
    }

    public void setWidth(GridType type, Collection<GridType> precisionTypes, double width) {
        for (GridType precisionType : precisionTypes) {
            this.setWidth(type, precisionType, width);
        }
    }

    public void setWidth(GridType type, GridType precisionType, double width) {
        this.getGrid(type).setWidth(precisionType, width);
    }

    public Labeler getLabeler(GridType type) {
        return this.getGrid(type).getLabeler();
    }

    public boolean hasLabeler(GridType type) {
        return this.getGrid(type).hasLabeler();
    }

    public void setLabeler(GridType type, Labeler labeler) {
        this.getGrid(type).setLabeler(labeler);
    }

    public void enableAllLabelers() {
        for (Grid grid : this.grids.values()) {
            Labeler labeler = grid.getLabeler();
            if (labeler == null) continue;
            labeler.setEnabled(true);
        }
    }

    public void disableAllLabelers() {
        this.disableLabelers(GridType.values());
    }

    public void enableLabelers(GridType ... types) {
        this.enableLabelers(Arrays.asList(types));
    }

    public void enableLabelers(Collection<GridType> types) {
        for (GridType type : types) {
            this.enableLabeler(type);
        }
    }

    public void disableLabelers(GridType ... types) {
        this.disableLabelers(Arrays.asList(types));
    }

    public void disableLabelers(Collection<GridType> types) {
        for (GridType type : types) {
            this.disableLabeler(type);
        }
    }

    public boolean isLabelerEnabled(GridType type) {
        Labeler labeler = this.getLabeler(type);
        return labeler != null && labeler.isEnabled();
    }

    public void enableLabeler(GridType type) {
        this.getRequiredLabeler(type).setEnabled(true);
    }

    public void disableLabeler(GridType type) {
        Labeler labeler = this.getLabeler(type);
        if (labeler != null) {
            labeler.setEnabled(false);
        }
    }

    private Labeler getRequiredLabeler(GridType type) {
        Labeler labeler = this.getLabeler(type);
        if (labeler == null) {
            throw new IllegalStateException("Grid type does not have a labeler: " + type);
        }
        return labeler;
    }

    public void setLabelMinZoom(GridType type, int minZoom) {
        Labeler labeler = this.getRequiredLabeler(type);
        labeler.setMinZoom(minZoom);
        Integer maxZoom = labeler.getMaxZoom();
        if (maxZoom != null && maxZoom < minZoom) {
            labeler.setMaxZoom(minZoom);
        }
    }

    public void setLabelMaxZoom(GridType type, Integer maxZoom) {
        Labeler labeler = this.getRequiredLabeler(type);
        labeler.setMaxZoom(maxZoom);
        if (maxZoom != null && labeler.getMinZoom() > maxZoom) {
            labeler.setMinZoom(maxZoom);
        }
    }

    public void setLabelZoomRange(GridType type, int minZoom, Integer maxZoom) {
        Labeler labeler = this.getRequiredLabeler(type);
        if (maxZoom != null && maxZoom < minZoom) {
            throw new IllegalArgumentException("Min zoom '" + minZoom + "' can not be larger than max zoom '" + maxZoom + "'");
        }
        labeler.setMinZoom(minZoom);
        labeler.setMaxZoom(maxZoom);
    }

    public void setAllLabelBuffers(double buffer) {
        for (Grid grid : this.grids.values()) {
            Labeler labeler = grid.getLabeler();
            if (labeler == null) continue;
            labeler.setBuffer(buffer);
        }
    }

    public void setLabelBuffer(double buffer, GridType ... types) {
        this.setLabelBuffer(Arrays.asList(types), buffer);
    }

    public void setLabelBuffer(Collection<GridType> types, double buffer) {
        for (GridType type : types) {
            this.setLabelBuffer(type, buffer);
        }
    }

    public double getLabelBuffer(GridType type) {
        return this.getGrid(type).getLabelBuffer();
    }

    public void setLabelBuffer(GridType type, double buffer) {
        this.getRequiredLabeler(type).setBuffer(buffer);
    }

    public void setAllLabelColors(Color color) {
        for (Grid grid : this.grids.values()) {
            if (!grid.hasLabeler()) continue;
            this.setLabelColor(grid.getType(), color);
        }
    }

    public void setLabelColor(Color color, GridType ... types) {
        this.setLabelColor(Arrays.asList(types), color);
    }

    public void setLabelColor(Collection<GridType> types, Color color) {
        for (GridType type : types) {
            this.setLabelColor(type, color);
        }
    }

    public void setLabelColor(GridType type, Color color) {
        this.getRequiredLabeler(type).setColor(color);
    }

    public void setAllLabelTextSizes(double textSize) {
        for (Grid grid : this.grids.values()) {
            if (!grid.hasLabeler()) continue;
            this.setLabelTextSize(grid.getType(), textSize);
        }
    }

    public void setLabelTextSize(double textSize, GridType ... types) {
        this.setLabelTextSize(Arrays.asList(types), textSize);
    }

    public void setLabelTextSize(Collection<GridType> types, double textSize) {
        for (GridType type : types) {
            this.setLabelTextSize(type, textSize);
        }
    }

    public void setLabelTextSize(GridType type, double textSize) {
        this.getRequiredLabeler(type).setTextSize(textSize);
    }
}

